#include <stdio.h>
#include <InterfaceKit.h>
#include "Preferences.h"

Preferences ThePrefs;

const char *Preferences::PrefsDataFile= "/boot/home/config/settings/CL-Amp_VisPlugin_Simple_VU-Meter.preferences";


void Preferences::SetDefData()
{
	BRect DefWinRect(50,50,250,150);

	D.WinRect= DefWinRect;
	D.GainPercent= 100;
}

Preferences::Preferences()
{
	if ((DataSemaphore = create_sem(1, "Preferences")) != B_NO_ERROR);
	Init();
}

void Preferences::Init()
{
	FILE *f;

	SetDefData();
	if (NULL!=(f=fopen(PrefsDataFile,"r"))) {
		fread (&D,1, sizeof(D), f);
		fclose(f);
	}
	if (D.GainPercent<1 || D.GainPercent>1000) D.GainPercent=100;
}

Preferences::~Preferences()
{
	FILE *f;
	
	if (NULL!=(f=fopen(PrefsDataFile,"w"))) {
		if (sizeof(D)!=fwrite (&D,1, sizeof(D), f));
		fclose(f);
	}
	delete_sem(DataSemaphore);
}
