#include "PluginWindow.h"
#include "Preferences.h"


PluginWindow::PluginWindow(BRect frame, char *name, VisualizationPlugin *plug, window_look look, window_feel feel, uint32 flags, uint32 workspaces) : BWindow(frame, name, look, feel, flags, workspaces)
{
	BRect rect = Bounds();
	
	plugin= plug;
	OldPosL_X= OldPosR_X= -1;
	view= new PluginView(rect, plugin, B_FOLLOW_ALL_SIDES, B_WILL_DRAW);
	AddChild(view);
}

PluginWindow::~PluginWindow()
{
}

void PluginWindow::FrameResized(float width, float height)
{
	OldPosL_X= OldPosR_X= -1;
	view->SetHighColor(255, 255, 255);
	view->FillRect(Bounds());
}

bool PluginWindow::Render(const short *data, long Len)
{
	#define AMPLIFIER_VALUE		((32 * ThePrefs.GainPercent())/100+1)
	#define SKIP_FRAMES   		 2
	
	short oldr=0, oldl=0;
	unsigned long VolumeR=0, VolumeL=0;
	long PosLX, PosRX;
	BPoint Pos1, Pos2;
	BRect Rect = Bounds();
	long TotWidth= (long)(Rect.right-Rect.left);
	long MaxStep= TotWidth/120;

	// Set maximum fall back to at least one pixel
	if (MaxStep<1) MaxStep= 1;
	
	// Calculate the Volume for left and right speaker (0-65535)
	for (int L=Len; L>0; L-=2) {
		VolumeL+= abs(*data-oldl);
		oldl= *data++;
		VolumeR+= abs(*data-oldr);
		oldr= *data++;
	}
	// Convert to a trimmed average value
	VolumeL/= (Len/AMPLIFIER_VALUE);
	VolumeR/= (Len/AMPLIFIER_VALUE);
	// and clip if the value is too high
	if (VolumeL>65535) VolumeL= 65535;
	if (VolumeR>65535) VolumeR= 65535;
	
	// Calculate the High X positions
	PosLX= (TotWidth*VolumeL)/(65536*2);
	PosRX= TotWidth/2+(TotWidth*VolumeR)/(65536*2);
	// and use a slow fall back, (to get a more relaxed needle! :-)
	if (PosLX < OldPosL_X-MaxStep)	PosLX= OldPosL_X-MaxStep;
	if (PosRX < OldPosR_X-MaxStep)	PosRX= OldPosR_X-MaxStep;
	
	// Skip all if nothing has changed since last time
	if (PosLX!=OldPosL_X || PosRX!=OldPosR_X) {
		// Set top and bottom
		Pos1.y= Rect.bottom-Rect.top;
		Pos2.y= 0;

		// First we erase the old lines (white colour)
		view->SetHighColor(255, 255, 255);

		// Erase the left line (if necessary...)
		if (PosLX!=OldPosL_X) {
			Pos1.x= TotWidth/4;
			Pos2.x= OldPosL_X;
			view->StrokeLine(Pos1, Pos2);
		}

		// Erase the right line (if necessary...)
		if (PosRX!=OldPosR_X) {
			Pos1.x= TotWidth - TotWidth/4;
			Pos2.x= OldPosR_X;
			view->StrokeLine(Pos1, Pos2);
		}

		// Draw the left line (if necessary...)
		if (PosLX!=OldPosL_X) {
			// low->high volume == black->red colour
			view->SetHighColor(VolumeL>>8, 0, 0);

			Pos1.x= TotWidth/4;
			Pos2.x= PosLX;
			view->StrokeLine(Pos1, Pos2);
			// Remember this position so we can erase it later!
			OldPosL_X= PosLX;
		}

		// Draw the right line (if necessary...)
		if (PosRX!=OldPosR_X) {
			// low->high volume == black->red colour
			view->SetHighColor(VolumeR>>8, 0, 0);

			Pos1.x= TotWidth - TotWidth/4;
			Pos2.x= PosRX;
			view->StrokeLine(Pos1, Pos2);
			// Remember this position so we can erase it later!
			OldPosR_X= PosRX;
		}
		
		view->Sync();
	}
	return (true);
}

void PluginWindow::MessageReceived(BMessage *message)
{
	switch (message->what)
	{
   		default:
			BWindow::MessageReceived(message);
			break;
	}
}

bool PluginWindow::QuitRequested()
{
	plugin->SendToCLAmp_Deactivate();
	return false;
}