#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <AppKit.h>
#include <InterfaceKit.h>
#include "Preferences.h"
#include "PrefsPanel/ViEdMainWindow.h"
#include "MyPlugin.h"

#define BUFFER_SIZE (100 * 1024);

// The first string is intended to be a short label for the type of audio this plugin handles
// The second string should give a more complete description of the plugin
MyPlugin::MyPlugin() : VisualizationPlugin ("vu-meter", "Simple VU-Meter by Claes Löfqvist")
{
	win= NULL;
}

bool MyPlugin::Init()
{
	ViEdMainWindow::CreateWinSemaphore();
	win= new PluginWindow(ThePrefs.WinRect(), "Simple VU-Meter", this, B_TITLED_WINDOW_LOOK, B_NORMAL_WINDOW_FEEL, B_WILL_ACCEPT_FIRST_CLICK, B_CURRENT_WORKSPACE);
	if (win) win->Show();
	return (win!=NULL);
}

void MyPlugin::Cleanup()
{
	if (win) {
		win->Lock();
		ThePrefs.SetWinRect(win->Frame());
		win->Quit();
		win= NULL;
	}
	ViEdMainWindow::DeleteWinSemaphore();
	ViEdMainWindow::QuitWindow();
}

unsigned long MyPlugin::GetFlags()
{
	return (VISPLUG_NEED_AUDIO_DATA);
}

bool MyPlugin::About(bool Question)
{
	if (!Question) {

		BAlert *theAlert = new BAlert("",
				"VU-Meter\nVersion 1.0\n\nMade by Claes Löfqvist\nE-mail: slarti@tripnet.se\nhttp://www4.tripnet.se/~slarti/\n\n",
				"Aha!", NULL, NULL, B_WIDTH_FROM_LABEL);

		BTextView *theText = theAlert->TextView();
		if(theText) {
			theText->SetStylable(true);
			theText->Select(0,8);	// Adjust this to the length of your header!
									// (The header in this example is "VU-Meter")
			BFont ourFont;

			theText->SetFontAndColor(be_bold_font);
			theText->GetFontAndColor(2, &ourFont, NULL);
			ourFont.SetSize(24);
			theText->SetFontAndColor(&ourFont);
		}
		theAlert->Go();
	}
	return (true);
}

bool MyPlugin::Prefs(bool Question)
{
	if (!Question && ViEdMainWindow::RequestWindow()) {
		ViEdMainWindow::CreateWindow();
	}
	return (true);
}

void MyPlugin::SongInfo(struct SongInfoStruct *info)
{
	// CL-Amp doesn't support this, yet!
}

bool MyPlugin::Render(const struct VisAudioInfoStruct *info)
{
	bool Ok= false;
	
	if(win->Lock()) {
		Ok= win->Render(info->WaveFormData, WAVEFORMDATA_LEN);
		win->Unlock();
	}
	return (Ok); // returning false will cause CL-Amp to call Cleanup(), since something is wrong...
}
