#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <AppKit.h>
#include <InterfaceKit.h>
#include "MyPlugin.h"


// The first string is intended to be a short label for the type of audio this plugin handles
// The second string should give a more complete description of the plugin
MyPlugin::MyPlugin() : OutputPlugin ("example", "Empty recorder by someone (a dummy plugin)")
{
}

bool MyPlugin::Init()
{
	return true;
}

void MyPlugin::Cleanup(void)
{
}

unsigned long MyPlugin::GetFlags()
{
	return (OUTPLUG_AFTER_MIXER | OUTPLUG_CROSSFADE_START | OUTPLUG_CROSSFADE_END);
}

bool MyPlugin::About(bool Question)
{
	if (!Question) {

		BAlert *theAlert = new BAlert("",
				"Empty\nVersion 0.0\n\nMade by Someone\nE-mail: someone@somewhere.com\nhttp://www.somewhere.com/my_homepage.html\n\n",
				"Aha!", NULL, NULL, B_WIDTH_FROM_LABEL);

		BTextView *theText = theAlert->TextView();
		if(theText) {
			theText->SetStylable(true);
			theText->Select(0,5);	// Adjust this to the length of your header!
									// (The header in this example is 'Empty')
			
			BFont ourFont;

			theText->SetFontAndColor(be_bold_font);
			theText->GetFontAndColor(2, &ourFont, NULL);
			ourFont.SetSize(24);
			theText->SetFontAndColor(&ourFont);
		}
		theAlert->Go();
	}
	return (true);
}

bool MyPlugin::Prefs(bool Question)
{
	if (!Question) {
	}
	return (false);
}

bool MyPlugin::InitRecording(const char *FileName, const char *FileName2, long frequency, short channels, bool sampleIsOnly8Bits)
{
	Record= true; // Set this to true if the initialization succeeded
	return (Record); // False = this function has failed!
}

bool MyPlugin::PutAudio(const char *Buff, long Size)
{
	if (Record) {
	}
	return (Record);	// False = this function has failed!
						// If it fails, CL-Amp will call CleanupRecording(),
						// to give you a chance to clean up things...
}

void MyPlugin::CleanupRecording()
{
	Record= false;
}
