#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <AppKit.h>
#include <InterfaceKit.h>
#include "MyPlugin.h"

// The first string is intended to be a short label for the type of audio this plugin handles
// The second string should give a more complete description of the plugin
MyPlugin::MyPlugin() : InputPlugin ("example", "Empty player by someone (a dummy plugin)")
{
}

void MyPlugin::Init()
{
}

void MyPlugin::Cleanup()
{
}

bool MyPlugin::About(bool Question)
{
	if (!Question) {

		BAlert *theAlert = new BAlert("",
				"Empty\nVersion 0.0\n\nMade by Someone\nE-mail: someone@somewhere.com\nhttp://www.somewhere.com/my_homepage.html\n\n",
				"Aha!", NULL, NULL, B_WIDTH_FROM_LABEL);

		BTextView *theText = theAlert->TextView();
		if(theText) {
			theText->SetStylable(true);
			theText->Select(0,5);	// Adjust this to the length of your header!
									// (The header in this example is 'Empty')
			
			BFont ourFont;

			theText->SetFontAndColor(be_bold_font);
			theText->GetFontAndColor(2, &ourFont, NULL);
			ourFont.SetSize(24);
			theText->SetFontAndColor(&ourFont);
		}
		theAlert->Go();
	}
	return (true);
}

bool MyPlugin::Prefs(bool Question)
{
	return (false);
}

bool MyPlugin::Edit(const char *FileName, bool Question)
{
	return (false);
}

bool MyPlugin::GetMimeType (BMimeType *m, int Nr)
{
	bool Ok= true;
	BMessage Msg;

	switch(Nr) {
		case 0:
			m->SetTo ("audio/example");
			Msg.AddString("extensions", "exa");
			Msg.AddString("extensions", "example");
			m->SetFileExtensions(&Msg);
			m->SetLongDescription("Just an example of a mime type with extensions");
			break;
		case 1:
			m->SetTo ("audio/x-empty");
			m->SetLongDescription("Just an example of a mime type without extensions");
			break;
		default:
			Ok= false;
	}

	// Change this to return (Ok) when you filled in your mime types
	return (false/*Ok*/);
}

void MyPlugin::AbortPlaying()
{
}

void MyPlugin::Pause(bool On)
{
}

void MyPlugin::NewSpeed(long Promille)
{
}

void MyPlugin::NewVolume(long Promille)
{
}

bool MyPlugin::IsOur(const char *FileName)
{
	char *ext;
	BNode N(FileName);
	char Type[B_MIME_TYPE_LENGTH];
	BNodeInfo NI(&N);

	// Check mime types
	if (B_OK==NI.GetType(Type)) {
		BMimeType Mime(Type);
		if (Mime.IsValid()) {
			if (Mime=="audio/example") return true;
			if (Mime=="audio/x-example") return true;
		}
	}
	
	// Check extensions
	ext=strrchr(FileName,'.');
	// Check if possible Url
	bool http= (0==strncasecmp(FileName,"http://",7));
	// In this example, we don't want Url's
	if (!http && ext) {
		if(0==strcasecmp(ext,".exa")) return true;
		if(0==strcasecmp(ext,".example")) return true;
	}
	return false;
}

void MyPlugin::JumpTo(long NewTime)
{
	if (PlayInfo) {
	}
}

bool MyPlugin::GetSongInfo(const char *FileName, struct PlayerInfoStruct *Info)
{
	// Remember to not mix the playing routines with this one!
	// They are called from different threads!
	
	Info->TotTime= 0;
	Info->Flags= INPLUG_JUMP_OK;
	Info->Frequency= 44100;
	Info->Stereo= true;
	Info->SampleIsOnly8Bits= false;
	// The bitrate should be kiloBits per second.
	// If its 0 after InitPlaying() CL-Amp will calculate one...
	Info->BitRate= 0;
	return false;
}

bool MyPlugin::InitPlaying(const char *FileName, struct PlayerInfoStruct *Info)
{
	PlayInfo= Info;
	
	// Add your play initializing code here!
	
	PlayInfo->TotTime= 0; // Total play time (ms)
	PlayInfo->Flags= INPLUG_JUMP_OK;
	PlayInfo->Frequency= 44100;
	PlayInfo->Stereo= true;
	PlayInfo->SampleIsOnly8Bits= false;
	// The bitrate should be kiloBits per second.
	// If its 0 after InitPlaying() CL-Amp will calculate one...
	PlayInfo->BitRate= 0;
	return false; // False = this function has failed!
}

int MyPlugin::GetAudio(char **Buff, int Size)
{
	int Cnt= 0; // Returning 0 means End Of File
	
	// Add your code here
	// CL-Amp is never asking for more than MAX_GETAUDIO_SIZE bytes!

	PlayInfo->CurrTime= 0; // Give the current play time (ms)
	// Dont forget to point *Buff to your buffer!
	// *Buff= myBuffer;
	return (Cnt);
}

void MyPlugin::CleanupPlaying()
{
	PlayInfo= NULL;
}
