#ifndef CLAES_THREAD_H
 #define CLAES_THREAD_H
 
 #ifndef CLAES_CLAES_H
  #include <Claes/Claes.h>
 #endif
 
 #ifndef EXEC_TYPES_H
  #include <Amiga/ExecType.h>
 #endif
 
 #ifndef _OS_H
  #include <kernel/OS.h>
 #endif
 
 class CLThread {
  public:
	CLThread()  { abort= FALSE; Ready= TRUE; }
	virtual ~CLThread() { Abort(); }
	status_t Go(const char *Name="CLThread", int32 Priority=B_NORMAL_PRIORITY) { abort= Ready= FALSE; TheThread = spawn_thread(MainStarter, Name, Priority, this); return (resume_thread(TheThread)); }
	virtual int32 Main() { ThreadInit(); ThreadCleanUp(); return(0); }
	void Abort() { abort= TRUE; while(!Ready) snooze(1000); }
	void SetAbort() { abort= TRUE; }
	Bool ChkAbort() { return (abort); }
	void ThreadInit() {  }
	void ThreadCleanUp() { Ready= TRUE; }
	void ChangePriority(int32 Priority=B_NORMAL_PRIORITY) { set_thread_priority(TheThread, Priority); }
  private: 
	static int32 MainStarter(void *thisPtr) { return (((CLThread *)thisPtr)->Main()); }
	thread_id TheThread;
	Bool abort, Ready;
 };

#endif

