//
// FileName: ExeLog.cpp
// 
// Programmer: David Sowsy
// 
// Purpose: To implement a debugging and logfile program 
//          to ease development. 

#include "ExeLog.h"

ExeLog :: ExeLog(char *filepath)
{
// outFile = fopen("exe_log", "aw+"); 
 outFile = fopen(filepath, "aw+"); 
 fprintf( outFile, "\nBegin Logging\n\n" ); 
}

ExeLog :: ~ExeLog()
{
 fprintf( outFile, "\n\nEnd logging"); 
 fclose( outFile );  
}

void ExeLog :: print( char * functionName, char * optionalParams )
{
 time_t foo = time( NULL ); 
 char * dateTime = ctime( &foo ); 
 snprintf( dateTime, 25, "%s", dateTime );  
 // Yeah it aint pretty, but it cuts down by one function call. 
 fprintf( outFile,"%s %s:(%s)", dateTime , functionName, optionalParams ); 
}

/*
int main()
{
 //ExeLog eLog; 
 //eLog.print( "foo" );
 
 ExeLog * eLog; 
 eLog = new ExeLog;
 eLog->print( "bar" ); 
 
 return(0); 
}
*/