//truncateString.cpp

#include "truncateString.h"
#include "warning.h"

bool
TruncateString(	const char * paramString,
				char * paramIntoBuf,
				float paramMaxPixelWidth,
				BFont * paramFont)
{
	BRect br(0, 0, 32, 32);
	BView view(br, NoShowView, B_FOLLOW_NONE, NULL);
	view.SetFont(paramFont);
	float truncStringPixLen = view.StringWidth(paramString);
	if (truncStringPixLen <= paramMaxPixelWidth)
	{
		strcpy(paramIntoBuf, paramString);
		return true;
	}
	uint32 stringLen = strlen(paramString);
	if (stringLen < 5)
	{
		warning(truncShort);
		return false;
	}
	uint32 stringCenter = stringLen / 2;
	bool tooLong = true;
	uint32 remove = 1;
	char * tempBuf = new char[stringLen];
	do
	{
		tempBuf[0] = '\0';
		uint32 scminus = (stringCenter - remove);
		strncpy(tempBuf, paramString, scminus);
		tempBuf[scminus] = '\0';
		strcat(tempBuf, "…");
		strcat(tempBuf, &paramString[(stringCenter + remove)]);
		truncStringPixLen = view.StringWidth(tempBuf);
		if (truncStringPixLen <= paramMaxPixelWidth)
		{
			tooLong = false;
			strcpy(paramIntoBuf, tempBuf);
		}
		else
		{
			remove++;
		}
	}
	while (tooLong);
	delete [] tempBuf;
	return true;
}//end