//star.cpp

#include "constants.h"
#include "Xwarning.h"
#include "Xunique.h"
#include "dobj.h"
#include "def.h"
#include "error.h"
#include "mergeHow.h"
#include "mergeNode.h"
#include "mergeList.h"
#include "XdataNode.h"
#include "XdataList.h"
#include "dataNode.h"
#include "dataList.h"
#include "universalConstants.h"
#include "XuIntPtrNode.h"
#include "uIntPtrNode.h"
#include "ptrList.h"
#include "mPtrNode.h"
#include "Xstar.h"
#include "Dstar.h"
#include "star.h"

Star	::	Star() 
{
	err = NO_ERR;
	starClass = NULL;
}//end


Star	::	Star(Star * fromItem, const char * n) 
{
	err = NO_ERR;
	name = (char *)malloc(strlen(n) + 1);
	if (name) 
	{
		DataNode * node = new DataNode(this);
		if (node) 
		{
			strcpy(name, n);
			starClass->number = fromItem->starClass->number;
			if (!Unique()) 
			{
				err = CREATEDNOTADDED;
				return;
			}
			if (dataListGlobal[STAR_TYPE]->AddItem(node)) 
			{
				starCurrent = this;
				err = CREATED;
				return;
			}
			err = NO_ADDITEM;
		}
		err = NO_DATANODE;
	}
	err = NO_NAME;
}//end


Star	::	Star(Star * fromItem, MergeList * list) 
{
	err = NO_ERR;
	name = (char *)malloc(strlen(fromItem->name) + 1);
	if (name) 
	{
		MergeNode * node = new MergeNode(this, MERGEDNOT);
		if (node) 
		{
			strcpy(name, fromItem->name);
			starClass->number = fromItem->starClass->number;
			if (list->AddItem(node)) 
			{
				node->placedAt = list->list->IndexOf(list->list->LastItem());
				err = CREATED;
				return;
			}
			err = NO_ADDITEM;
		}
		err = NO_DATANODE;
	}
	err = NO_NAME;
}//end


Star	::	~Star() 
{
	//left blank
}//end


bool Star	::	Unique() 
{
	DataNode * node;
	err = NO_UNIQUE;
	for (	int32 i = 0;
			#pragma warn_possunwant off
			node = (DataNode * )dataListGlobal[STAR_TYPE]->list->ItemAt(i);
			#pragma warn_possunwant reset
			i++) 
	{
		if (!strcmp(name, node->MyName(STAR_TYPE))) 
		{
			warning(FailCreate[STAR_TYPE]);
			warning(FailCreateName);
			return false;
		}
	}
	err = NO_ERR;
	return true;
}//end


bool Star	::	Save(BFile * file) 
{
	if (!BuildConstantsSave(file)) return false;
	//save other stuff
	return true;
}//end


bool Star	::	Load(BFile * file) 
{
	if (!BuildConstantsLoad(file)) 
	{
		return false;
	}
	//load other stuff
	return true;
}//end


bool Star	::	Copy(	Star * fromItem) 
{
	if (name && fromItem->name) 
	{
		if (strcmp(name, fromItem->name)) 
		{
			if (name) 
			{
				free(name);
			}
			name = (char *)malloc(strlen(fromItem->name) + 1);
			if (name) strcpy(name, fromItem->name);
			else 
			{
				err = NO_NAME;
				warning(FailName);
				return false;
			}
		}
	}
	//debug must do object as well
	return true;
}//end
