//class definition for Species objects in Spheres of Influence 0.1

#ifndef SPECIES
#define SPECIES

#define SPECIES_TYPE 16
#define NO_SPECIES (-SPECIES_TYPE)

class MergeList;

class Species : 
public BuildConstants 
{
private:
				Species(	const Species& copy);//not implimented on purpose
	Species&	operator = (	const Species& assign);//not implimented on purpose
public:
	uint32			MinOriginStarClass;
	uint32			MinOriginPlanetCharacteristic;
	uint32			MinOriginOrbit;
	uint32			MinMinHabitableStarClass;
	uint32			MinMinHabitablePlanetCharacteristic;
	uint32			MinMinHabitableOrbit;
	uint32			MinMaxHabitableStarClass;
	uint32			MinMaxHabitablePlanetCharacteristic;
	uint32			MinMaxHabitableOrbit;
	uint32			MaxOriginStarClass;
	uint32			MaxOriginPlanetCharacteristic;
	uint32			MaxOriginOrbit;
	uint32			MaxMinHabitableStarClass;
	uint32			MaxMinHabitablePlanetCharacteristic;
	uint32			MaxMinHabitableOrbit;
	uint32			MaxMaxHabitableStarClass;
	uint32			MaxMaxHabitablePlanetCharacteristic;
	uint32			MaxMaxHabitableOrbit;
					Species();
					Species(	Species * fromS, 
								const char * n);
					Species(	Species * fromS, 
								MergeList * list);
					~Species();
	bool			Copy(	Species * fromItem);
	bool			Unique();
	bool			Save(	BFile * file);
	bool			Load(	BFile * file);
};
#endif