//element.cpp

#include "Xelement.h"
#include "constants.h"
#include "Xwarning.h"
#include "Xunique.h"
#include "dobj.h"
#include "def.h"
#include "error.h"
#include "mergeHow.h"
#include "mergeNode.h"
#include "mergeList.h"
#include "XdataNode.h"
#include "XdataList.h"
#include "dataNode.h"
#include "dataList.h"
#include "universalConstants.h"
#include "XuIntPtrNode.h"
#include "uIntPtrNode.h"
#include "ptrList.h"
#include "mPtrNode.h"
#include "Xelement.h"
#include "element.h"

Element	::	Element() 
{
	err = NO_ERR;
}//end  Element()


Element	::	Element(	Element * fromItem, 
						const char * n) 
{
	err = NO_ERR;
	name = (char *)malloc(strlen(n) + 1);
	if (name) 
	{
		DataNode * node = new DataNode(this);
		if (node) 
		{
			strcpy(name, n);
			//debug comment
//			electron = fromItem->electron;
//			neutron = fromItem->neutron;
//			proton = fromItem->proton;
//			mass = (universe->electronMass * electron) + (universe->neutronMass * neutron) + (universe->protonMass * proton);
//			volume = fromItem->volume;
//			vper = fromItem->vper;
			if (!Unique()) 
			{
				err = CREATEDNOTADDED;
				return;
			}
			if (dataListGlobal[ELEMENT_TYPE]->AddItem(node)) 
			{
				elementCurrent = this;
				err = CREATED;
				return;
			}
			err = NO_ADDITEM;
		}
		err = NO_DATANODE;
	}
	err = NO_NAME;
}//end


Element	::	Element(	Element * fromItem, 
						MergeList * list) 
{
	err = NO_ERR;
	name = (char *)malloc(strlen(fromItem->name) + 1);
	if (name) 
	{
		MergeNode * node = new MergeNode(this, MERGEDNOT);
		if (node) 
		{
			strcpy(name, fromItem->name);
			//debuf comment
			//electron = fromItem->electron;
	//		neutron = fromItem->neutron;
	//		proton = fromItem->proton;
	//		mass = (universe->electronMass * electron) + (universe->neutronMass * neutron) + (universe->protonMass * proton);
	//		volume = fromItem->volume;
	//		vper = fromItem->vper;
			if (list->AddItem(node)) 
			{
				node->placedAt = list->list->IndexOf(list->list->LastItem());
				err = CREATED;
				return;
			}
			err = NO_ADDITEM;
		}
		err = NO_DATANODE;
	}
	err = NO_NAME;
}//end


Element	::	~Element() 
{
	//left blank
}//end

bool 
Element	::	Unique() 
{
	DataNode * node;
	err = NO_UNIQUE;
	for (	int32 i = 0;
			#pragma warn_possunwant off
			node = (DataNode * )dataListGlobal[ELEMENT_TYPE]->list->ItemAt(i);
			#pragma warn_possunwant reset
			i++) 
	{
		if (!strcmp(name, node->MyName(ELEMENT_TYPE))) 
		{
			warning(FailCreate[ELEMENT_TYPE]);
			warning(FailCreateName);
			return false;
		}
		if (this->electron == ((Element * )node->data)->electron) 
		{
			if (this->neutron == ((Element * )node->data)->neutron) 
			{
				if (this->proton == ((Element * )node->data)->proton) 
				{
					warning(FailCreate[ELEMENT_TYPE]);
					warning(FailCreateData);//debug add to all other thing's data
					return false;
				}	
			}
		}
	}
	err = NO_ERR;
	return true;
}//end


bool 
Element	::	Save(	BFile * file) 
{
	if (!BuildConstantsSave(file)) goto bad;
	if (!SmallConstantsSave(file)) goto bad;
	
	int32 len = sizeof(uint32);
	if (file->Write(&electron, len) != len) 
	{
		goto bad;
	}
	if (file->Write(&neutron, len) != len) 
	{
		goto bad;
	}
	if (file->Write(&proton, len) != len) 
	{
		goto bad;
	}
	return true;
	bad:
	warning(badFileLength);
	return false;
}//end


bool 
Element	::	Load(	BFile * file) 
{
	if (!BuildConstantsLoad(file)) goto bad;
	if (!SmallConstantsLoad(file)) goto bad;
	
	int32 len = sizeof(uint32);
	if (file->Read(&electron, len) != len) 
	{
		goto bad;
	}
	if (file->Read(&neutron, len) != len) 
	{
		goto bad;
	}
	if (file->Read(&proton, len) != len) 
	{
		goto bad;
	}
	return true;
	bad:
	warning(badFileLength);
	return false;
}//end


bool 
Element	::	Copy(	Element * fromItem) 
{
	if (name && fromItem->name) 
	{
		if (strcmp(name, fromItem->name)) 
		{
			if (name) 
			{
				free(name);
			}
			name = (char *)malloc(strlen(fromItem->name) + 1);
			if (name) strcpy(name, fromItem->name);
			else 
			{
				err = NO_NAME;
				warning(FailName);
				return false;
			}
		}
	}
	//debug must do object as well
	electron = fromItem->electron;
	neutron = fromItem->neutron;
	proton = fromItem->proton;
	volume = fromItem->volume;
	vper = fromItem->vper;
	mass = fromItem->mass;
	return true;
}//end
