//compound.cpp

#include "constants.h"
#include "Xwarning.h"
#include "Xunique.h"
#include "dobj.h"
#include "def.h"
#include "error.h"
#include "mergeHow.h"
#include "mergeNode.h"
#include "mergeList.h"
#include "XdataNode.h"
#include "XdataList.h"
#include "dataNode.h"
#include "dataList.h"
#include "universalConstants.h"
#include "XuIntPtrNode.h"
#include "uIntPtrNode.h"
#include "XptrList.h"
#include "ptrList.h"
#include "mPtrNode.h"
#include "element.h"
#include "compound.h"

Compound	::	~Compound() 
{
	if (eList) delete eList;
	if (cList) delete cList;
}//end


Compound	::	Compound() 
{
	err = NO_ERR;
	eList = new PtrList(ELEMENT_TYPE);
	if (!eList) err = NO_PTRLIST;
	else 
	{
		cList = new PtrList(COMPOUND_TYPE);
		if (!cList) err = NO_PTRLIST;
	}
}//end


Compound	::	Compound(	Compound * fromItem, 
							const char * n) 
{
	err = NO_ERR;
	name = (char *)malloc(strlen(n) + 1);
	if (name) 
	{
		DataNode * node = new DataNode(this);
		if (node) 
		{
			eList = new PtrList(ELEMENT_TYPE);
			if (!eList) 
			{
				warning(FailPtrList);
				err = CREATEDNOTADDED;
				return;
			}
			eList->Copy(fromItem->eList);
			cList = new PtrList(COMPOUND_TYPE);
			if (!cList) 
			{
				warning(FailPtrList);
				err = CREATEDNOTADDED;
				return;
			}
			cList->Copy(fromItem->cList);
			mass = fromItem->mass;
			volume = fromItem->volume;
			vper = fromItem->vper;
			strcpy(name, n);
			if (!Unique()) 
			{
				err = CREATEDNOTADDED;
				return;
			}
			if (dataListGlobal[COMPOUND_TYPE]->AddItem(node)) 
			{
				compoundCurrent = this;
				err = CREATED;
				return;
			}
			err = NO_ADDITEM;
		}
		err = NO_DATANODE;
	}
	err = NO_NAME;
}//end


Compound	::	Compound(	Compound * fromItem, 
							MergeList * list) 
{
	err = NO_ERR;
	name = (char *)malloc(strlen(fromItem->name) + 1);
	if (name) 
	{
		MergeNode * node = new MergeNode(this, MERGEDNOT);
		if (node) 
		{
			eList = new PtrList(ELEMENT_TYPE);
			if (!eList) 
			{
				warning(FailPtrList);
				err = CREATEDNOTADDED;
				return;
			}
			eList->Copy(fromItem->eList);
			cList = new PtrList(COMPOUND_TYPE);
			if (!cList) 
			{
				warning(FailPtrList);
				err = CREATEDNOTADDED;
				return;
			}
			cList->Copy(fromItem->cList);
			mass = fromItem->mass;
			volume = fromItem->volume;
			vper = fromItem->vper;
			strcpy(name, fromItem->name);
			if (list->AddItem(node)) 
			{
				node->placedAt = list->list->IndexOf(list->list->LastItem());
				err = CREATED;
				return;
			}
			err = NO_ADDITEM;
		}
		err = NO_DATANODE;
	}
	err = NO_NAME;
}//end


bool 
Compound	::	Unique() 
{
	err = NO_UNIQUE;
	DataNode * node;
	for (	int32 i = 0;
			#pragma warn_possunwant off
			node = (DataNode * )dataListGlobal[COMPOUND_TYPE]->list->ItemAt(i);
			#pragma warn_possunwant reset
			i++) 
	{
		if (!strcmp(name, node->MyName(COMPOUND_TYPE))) 
		{
			warning(FailCreate[COMPOUND_TYPE]);
			warning(FailCreateName);
			return false;
		}
	}
	err = NO_ERR;
	return true;
}//end


bool 
Compound	::	Save(	BFile * file) 
{
	if (!BuildConstantsSave(file)) goto bad;
	if (!SmallConstantsSave(file)) goto bad;
	int32 realItemNumber;
	void * realItemFromName;
	void * pnode;
	UIntPtrNode * cpn;
	int32 len;
	int32 items = eList->list->CountItems();
	len = sizeof(items);
	if (!(file->Write(&items, len) == len)) goto bad;
	for (	int32 i = 0;
			#pragma warn_possunwant off
			pnode = eList->list->ItemAt(i);
			#pragma warn_possunwant reset
			i++) 
	{
		cpn = (UIntPtrNode *)pnode;
		realItemFromName = dataListGlobal[ELEMENT_TYPE]->RealItemFromName(cpn->MyName(ELEMENT_TYPE), &realItemNumber);
		if (!realItemFromName) 
		{
			warning(notOnDataList);
			goto bad;
		}
		len = sizeof(realItemNumber);
		if (!(file->Write(&realItemNumber, sizeof(len)) == sizeof(len))) goto bad;
		len = sizeof(cpn->number);
		if (!(file->Write(&cpn->number, len) == len)) goto bad;
	}
	items = cList->list->CountItems();
	len = sizeof(items);
	if (!(file->Write(&items, len) == len)) goto bad;
	for (	int32 i = 0;
			#pragma warn_possunwant off
			pnode = cList->list->ItemAt(i);
			#pragma warn_possunwant reset
			i++) 
	{
		cpn = (UIntPtrNode *)pnode;
		realItemFromName = dataListGlobal[COMPOUND_TYPE]->RealItemFromName(cpn->MyName(COMPOUND_TYPE), &realItemNumber);
		if (!realItemFromName) 
		{
			warning(notOnDataList);
			goto bad;
		}
		len = sizeof(realItemNumber);
		if (!(file->Write(&realItemNumber, sizeof(len)) == sizeof(len))) goto bad;
		len = sizeof(cpn->number);
		if (!(file->Write(&cpn->number, len) == len)) goto bad;
	}
	return true;
	bad:
	warning(badFileLength);
	return false;
}//end


bool 
Compound	::	Load(	BFile * file) 
{
	if (!BuildConstantsLoad(file)) goto bad;
	if (!SmallConstantsLoad(file)) goto bad;
	//2 lists
	int32 items;
	int32 realItemNumber;
	int32 number;
	int32 len = sizeof(items);
	if (file->Read(&items, len) == len) 
	{
		for (	int32 i = 0;i < items;i++) 
		{
			//len = sizeof(realItemNumber);
			if (file->Read(&realItemNumber, len) == len) 
			{
				//len = sizeof(number);
				if (file->Read(&number, len) == len) 
				{
					MPtrNode * mPtrNode;
					try {
						mPtrNode = new MPtrNode(realItemNumber, number, MERGEDNOT);
					}
					catch (...) 
					{
						mPtrNode = NULL;
						warning(FailMPtrNode);
						goto bad;
					}
					eList->AddItem(mPtrNode);
				}
				else goto bad;
			}
			else goto bad;
		}
	}
	else goto bad;
	if (file->Read(&items, len) == len) 
	{
		for (	int32 i = 0;i < items;i++) 
		{
			//len = sizeof(realItemNumber);
			if (file->Read(&realItemNumber, len) == len) 
			{
				//len = sizeof(number);
				if (file->Read(&number, len) == len) 
				{
					MPtrNode * mPtrNode = new MPtrNode(realItemNumber, number, MERGEDNOT);
					if (!mPtrNode) 
					{
						warning(FailMPtrNode);
						goto bad;
					}
					cList->AddItem(mPtrNode);
				}
				else goto bad;
			}
			else goto bad;
		}
	}
	else goto bad;
	return true;
	bad:
	warning(badFileLength);
	return false;
}//end


bool 
Compound	::	Copy(	Compound * fromItem) 
{
	if (name && fromItem->name) 
	{
		if (strcmp(name, fromItem->name)) 
		{
			if (name) 
			{
				free(name);
			}
			name = (char *)malloc(strlen(fromItem->name) + 1);
			if (name) strcpy(name, fromItem->name);
			else 
			{
				err = NO_NAME;
				warning(FailName);
				return false;
			}
		}
	}
	mass = fromItem->mass;
	eList->Copy(fromItem->eList);
	cList->Copy(fromItem->cList);
	volume = fromItem->volume;
	vper = fromItem->vper;
	//debug must do object as well
	return true;
}//end
