//showSomeThings.cpp

#include "XwarnStr.h"
#include "XselectListStr.h"
#include "windowGuts.h"
#include "themAll.h"
#include "warning.h"
#include "unique.h"
#include "dobj.h"
#include "def.h"
#include "error.h"
#include "mergeHow.h"
#include "mergeNode.h"
#include "mergeList.h"
#include "dataNode.h"
#include "dataList.h"
#include "uIntPtrNode.h"
#include "ptrList.h"
#include "mPtrNode.h"
#include "unique.h"
#include "showSomeThings.h"
#include "listViewWindow.h"
#include "intGadget.h"
#include "bottomLine.h"
#include "myButton.h"
#include "bottomButtons.h"
#include "stringGadget.h"
#include "unique.h"
#include "textItem.h"
#include "myStringDrawer.h"
#include "layoutMatrixItem.h"
#include "layoutMatrix.h"
#include "constants.h"
#include "universalConstants.h"
#include "editUniversalConstantsWindow.h"
#include "myPreferences.h"

void ShowSomeThings(const void * data, int32 dataSize, char * listerName, int32 listerType, PtrList * list, const char * scgName, void * fromWindow, DataList * dataListGlobal) 
{
	err = NO_ERR;
	BRect lvwRect(40,45, 632,473);
	ListViewWindow *lvw = new ListViewWindow(	lvwRect, 
												sstWindowTitle[dataListGlobal->kind], 
												/*toList*/NULL, 
												(DataList *)list, 
												scgName, 
												fromWindow,
												LISTVIEWSELECTZERO);
	if (lvw) 
	{
		BRect listRect(10,10, 572,413);
		lvw->listView = new BListView(listRect, sstTitle[list->kind], B_SINGLE_SELECTION_LIST, B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE | B_FRAME_EVENTS);
		if (lvw->listView) 
		{
			UIntPtrNode * node;
			for (	int32 i = 0;
					#pragma warn_possunwant off
					node = (UIntPtrNode *)list->list->ItemAt(i);
					#pragma warn_possunwant reset
					i++) 
			{
				try
				{
					BStringItem * bsi = new BStringItem(node->MyName(dataListGlobal->kind));
					lvw->listView->AddItem(bsi);
				}
				catch (...)
				{
					delete lvw;
					warning(failMemory);
					throw;
				}
			}
			lvw->AddChild(lvw->listView);
			//lvw->listView->//debug SetFontName("Times New Roman Bold");
			//lvw->listView->//debug SetFontSize(14.0);
			//lvw->listView->SetViewColor(165,0,165);
			BMessage * selectMsg = new BMessage(LISTVIEWSELECTZERO);
			if (selectMsg) 
			{
				selectMsg->AddInt32("listerType", listerType);
				selectMsg->AddString("listerName", listerName);
				selectMsg->AddData("theData", B_POINTER_TYPE,  data, dataSize);
				selectMsg->AddData("theAblePtr", B_POINTER_TYPE, &list, sizeof(list));
				selectMsg->AddPointer("source", (const void *)lvw->listView);
				lvw->listView->SetSelectionMessage(selectMsg);
				lvw->listView->SetTarget(lvw);
			}
			else {
				warning(failMemory);
			}
			lvw->Show();
		}
		else {
			delete lvw;
		}
	}
}//end
