//doableButtonsPut.cpp

#include "themAll.h"
#include "Xwarning.h"
#include "Xunique.h"
#include "dobj.h"
#include "def.h"
#include "error.h"
#include "mergeHow.h"
#include "mergeNode.h"
#include "mergeList.h"
#include "dataNode.h"
#include "dataList.h"
#include "stringGadget.h"
#include "myButton.h"
#include "bottomButtons.h"
#include "windowGuts.h"
#include "designButtons.h"
#include "listViewWindow.h"
#include "editUniverseWindow.h"
#include "XdoableButtons.h"
#include "doableButtons.h"

int32 
DoableButtonsPut(	bool show, 
					int32 topIs, 
					EditUniverseWindow * fromWindow, 
					DoableButtons * db, 
					const char * selectValue) 
{
	int32 top = topIs;
	int32 width = 180;
	int32 height = 18;
	int32 hgap = HGAP;
	int32 vgap = VGAP;
	int32 left0e = 10;
	int32 lw = left0e + width;
	int32 mid1e = lw + hgap;
	int32 mw = mid1e + width;
	int32 right2e = mw + hgap;
	int32 rw = right2e + width;
	
	int32 aMsg, bMsg, cMsg, dMsg, eMsg, fMsg, gMsg, hMsg, iMsg, jMsg, kMsg, lMsg, mMsg;
	if (selectValue == selectProdValue) 
	{
		aMsg = BUILDABLEBUTTONLABEL;
		bMsg = BUILDABLEBUTTONPRIMALELEMENTS;
		cMsg = BUILDABLEBUTTONPRIMALCOMPOUNDS;
		dMsg = BUILDABLEBUTTONELEMENTS;
		eMsg = BUILDABLEBUTTONCOMPOUNDS;
		fMsg = BUILDABLEBUTTONMINES;
		gMsg = BUILDABLEBUTTONFACTORYS;
		hMsg = BUILDABLEBUTTONENGINES;
		iMsg = BUILDABLEBUTTONSHIPS;
		jMsg = BUILDABLEBUTTONSHIPSHIELDS;
		kMsg = BUILDABLEBUTTONSHIPWEAPONS;
		lMsg = BUILDABLEBUTTONPLANETSHIELDS;
		mMsg = BUILDABLEBUTTONPLANETWEAPONS;
	}
	else if (selectValue == selectConsumeValue) 
	{
		aMsg = DOABLEBUTTONLABEL;
		bMsg = DOABLEBUTTONPRIMALELEMENTS;
		cMsg = DOABLEBUTTONPRIMALCOMPOUNDS;
		dMsg = DOABLEBUTTONELEMENTS;
		eMsg = DOABLEBUTTONCOMPOUNDS;
		fMsg = DOABLEBUTTONMINES;
		gMsg = DOABLEBUTTONFACTORYS;
		hMsg = DOABLEBUTTONENGINES;
		iMsg = DOABLEBUTTONSHIPS;
		jMsg = DOABLEBUTTONSHIPSHIELDS;
		kMsg = DOABLEBUTTONSHIPWEAPONS;
		lMsg = DOABLEBUTTONPLANETSHIELDS;
		mMsg = DOABLEBUTTONPLANETWEAPONS;
	}
	else if (selectValue == selectMaintValue) 
	{
		aMsg = MAINTAINABLEBUTTONLABEL;
		bMsg = MAINTAINABLEBUTTONPRIMALELEMENTS;
		cMsg = MAINTAINABLEBUTTONPRIMALCOMPOUNDS;
		dMsg = MAINTAINABLEBUTTONELEMENTS;
		eMsg = MAINTAINABLEBUTTONCOMPOUNDS;
		fMsg = MAINTAINABLEBUTTONMINES;
		gMsg = MAINTAINABLEBUTTONFACTORYS;
		hMsg = MAINTAINABLEBUTTONENGINES;
		iMsg = MAINTAINABLEBUTTONSHIPS;
		jMsg = MAINTAINABLEBUTTONSHIPSHIELDS;
		kMsg = MAINTAINABLEBUTTONSHIPWEAPONS;
		lMsg = MAINTAINABLEBUTTONPLANETSHIELDS;
		mMsg = MAINTAINABLEBUTTONPLANETWEAPONS;
	}
	else {
		warning(FailBadSelectValueDoableButPut);
	}
	BRect labelRect(100, top, 500, top + 20);
	try
	{
		db->label = new BButton(labelRect, "", selectValue, new BMessage(aMsg));
		fromWindow->AddChild(db->label);
		db->label->SetTarget(fromWindow);
		db->label->SetEnabled(show);
		
		top += vgap;
		BRect elementPrimalButtonRect(left0e,top,lw,height);
		db->elementPrimalButton = new BButton(elementPrimalButtonRect, "", primalEStr, new BMessage(bMsg));
		fromWindow->AddChild(db->elementPrimalButton);
		if (dataListGlobal[ELEMENT_TYPE]->list->IsEmpty()) 
		{
			db->elementPrimalButton->SetEnabled(false);
		}
		db->elementPrimalButton->SetTarget(fromWindow);
		
		BRect compoundPrimalButtonRect(mid1e,top, mw,height);
		db->compoundPrimalButton = new BButton(compoundPrimalButtonRect, "", primalCStr, new BMessage(cMsg));
		fromWindow->AddChild(db->compoundPrimalButton);
		if (dataListGlobal[COMPOUND_TYPE]->list->IsEmpty()) 
		{
			db->compoundPrimalButton->SetEnabled(false);
		}
		db->compoundPrimalButton->SetTarget(fromWindow);
		
		BRect elementManufacturedButtonRect(right2e,top, rw,height);
		db->elementManufacturedButton = new BButton(elementManufacturedButtonRect, "", manuEStr, new BMessage(dMsg));
		fromWindow->AddChild(db->elementManufacturedButton);
		if (dataListGlobal[ELEMENT_TYPE]->list->IsEmpty()) 
		{
			db->elementManufacturedButton->SetEnabled(false);
		}
		db->elementManufacturedButton->SetTarget(fromWindow);
		
		top += vgap;
		BRect compoundManufacturedButtonRect(left0e,top,lw,height);
		db->compoundManufacturedButton = new BButton(compoundManufacturedButtonRect, "", manuCStr, new BMessage(eMsg));
		fromWindow->AddChild(db->compoundManufacturedButton);
		if (dataListGlobal[COMPOUND_TYPE]->list->IsEmpty()) 
		{
			db->compoundManufacturedButton->SetEnabled(false);
		}
		db->compoundManufacturedButton->SetTarget(fromWindow);
		
		BRect mineManufacturedButtonRect(mid1e,top, mw,height);
		db->mineManufacturedButton = new BButton(mineManufacturedButtonRect, "", manuMStr, new BMessage(fMsg));
		fromWindow->AddChild(db->mineManufacturedButton);
		if (dataListGlobal[MINE_TYPE]->list->IsEmpty()) 
		{
			db->mineManufacturedButton->SetEnabled(false);
		}
		db->mineManufacturedButton->SetTarget(fromWindow);
		
		BRect factoryManufacturedButtonRect(right2e,top, rw,height);
		db->factoryManufacturedButton = new BButton(factoryManufacturedButtonRect, "", manuFStr, new BMessage(gMsg));
		fromWindow->AddChild(db->factoryManufacturedButton);
		if (dataListGlobal[FACTORY_TYPE]->list->IsEmpty()) 
		{
			db->factoryManufacturedButton->SetEnabled(false);
		}
		db->factoryManufacturedButton->SetTarget(fromWindow);
		
		top += vgap;
		BRect engineManufacturedButtonRect(left0e,top,lw,height);
		db->engineManufacturedButton = new BButton(engineManufacturedButtonRect, "", manuEngStr, new BMessage(hMsg));
		fromWindow->AddChild(db->engineManufacturedButton);
		if (dataListGlobal[ENGINE_TYPE]->list->IsEmpty()) 
		{
			db->engineManufacturedButton->SetEnabled(false);
		}
		db->engineManufacturedButton->SetTarget(fromWindow);
		
		BRect shipManufacturedButtonRect(mid1e,top, mw,height);
		db->shipManufacturedButton = new BButton(shipManufacturedButtonRect, "", manuSStr, new BMessage(iMsg));
		fromWindow->AddChild(db->shipManufacturedButton);
		if (dataListGlobal[SHIP_TYPE]->list->IsEmpty()) 
		{
			db->shipManufacturedButton->SetEnabled(false);
		}
		db->shipManufacturedButton->SetTarget(fromWindow);
		
		BRect shipShieldManufacturedButtonRect(right2e,top, rw,height);
		db->shipShieldManufacturedButton = new BButton(shipShieldManufacturedButtonRect, "", manuSSStr, new BMessage(jMsg));
		fromWindow->AddChild(db->shipShieldManufacturedButton);
		if (dataListGlobal[SHIPSHIELD_TYPE]->list->IsEmpty()) 
		{
			db->shipShieldManufacturedButton->SetEnabled(false);
		}
		db->shipShieldManufacturedButton->SetTarget(fromWindow);
		
		top += vgap;
		BRect shipWeaponManufacturedButtonRect(left0e,top,lw,height);
		db->shipWeaponManufacturedButton = new BButton(shipWeaponManufacturedButtonRect, "", manuSWStr, new BMessage(kMsg));
		fromWindow->AddChild(db->shipWeaponManufacturedButton);
		if (dataListGlobal[SHIPWEAPON_TYPE]->list->IsEmpty()) 
		{
			db->shipWeaponManufacturedButton->SetEnabled(false);
		}
		db->shipWeaponManufacturedButton->SetTarget(fromWindow);
		
		BRect planetShieldManufacturedButtonRect(mid1e,top, mw,height);
		db->planetShieldManufacturedButton = new BButton(planetShieldManufacturedButtonRect, "", manuPSStr, new BMessage(lMsg));
		fromWindow->AddChild(db->planetShieldManufacturedButton);
		if (dataListGlobal[PLANETSHIELD_TYPE]->list->IsEmpty()) 
		{
			db->planetShieldManufacturedButton->SetEnabled(false);
		}
		db->planetShieldManufacturedButton->SetTarget(fromWindow);
		
		BRect planetWeaponManufacturedButtonRect(right2e,top, rw,height);
		db->planetWeaponManufacturedButton = new BButton(planetWeaponManufacturedButtonRect, "", manuPWStr, new BMessage(mMsg));
		fromWindow->AddChild(db->planetWeaponManufacturedButton);
		if (dataListGlobal[PLANETWEAPON_TYPE]->list->IsEmpty()) 
		{
			db->planetWeaponManufacturedButton->SetEnabled(false);
		}
		db->planetWeaponManufacturedButton->SetTarget(fromWindow);
	}
	catch (...)
	{
		warning(FailMemory);
		throw;
	}
	return (top + vgap);
}//end