//dataList.cpp

#include "Dstar.h"
#include "themAll.h"
#include "Xwarning.h"
#include "Xunique.h"
#include "dobj.h"
#include "def.h"
#include "error.h"
#include "myButton.h"
#include "bottomButtons.h"
#include "mergeHow.h"
#include "mergeNode.h"
#include "mergeList.h"
#include "dataNode.h"
#include "dataList.h"
#include "XuIntPtrNode.h"
#include "uIntPtrNode.h"
#include "ptrList.h"
#include "mPtrNode.h"
#include "XdataList.h"
#include "dataList.h"

DataList	::	DataList(	int32 k) 
{
	//only valid way to create/construct a DataList
	list = new BList(LIST_BLOCK_SIZE);
	if (!list) warning(FailMemory);
	kind = k;
}//end  DataList()


DataList	::	~DataList() 
{
	if (list->CountItems()) 
	{
		DataNode * node;
		for (	int32 i = 0;
				#pragma warn_possunwant off
				node = (DataNode *)list->ItemAt(i);
				#pragma warn_possunwant reset
				i++) 
		{
			switch (kind) 
			{
				case ELEMENT_TYPE:
					delete ((Element *)node->data);
				break;
				case COMPOUND_TYPE:
					delete ((Compound *)node->data);
				break;
				case UNIVERSE_TYPE:
					delete ((Universe *)node->data);
				break;
				case UNIVERSALCONSTANTS_TYPE:
					delete ((UniversalConstants *)node->data);
				break;
				case GALAXY_TYPE:
					delete ((Galaxy *)node->data);
				break;
				case WORMHOLE_TYPE:
					delete ((Wormhole *)node->data);
				break;
				case BLACKHOLE_TYPE:
					delete ((Blackhole *)node->data);
				break;
				case STAR_TYPE:
					delete ((Star *)node->data);
				break;
				case PLANET_TYPE:
					delete ((Planet *)node->data);
				break;
				case PLANETWEAPON_TYPE:
					delete ((PlanetWeapon *)node->data);
				break;
				case PLANETSHIELD_TYPE:
					delete ((PlanetShield *)node->data);
				break;
				case SHIP_TYPE:
					delete ((Ship *)node->data);
				break;
				case SHIPWEAPON_TYPE:
					delete ((ShipWeapon *)node->data);
				break;
				case SHIPSHIELD_TYPE:
					delete ((ShipShield *)node->data);
				break;
				case ENGINE_TYPE:
					delete ((Engine *)node->data);
				break;
				case FACTORY_TYPE:
					delete ((Factory *)node->data);
				break;
				case MINE_TYPE:
					delete ((Mine *)node->data);
				break;
				case SPECIES_TYPE:
					delete ((Species *)node->data);
				break;
				default:
					warning(FailCaseDefaultDataList);
				break;
			}
			delete node;
		}
	}
	delete list;
	list = NULL;
}//end


bool 
DataList	::	AddItem(	void *item) 
{
	int32 at = list->IndexOf(list->LastItem());
	return(list->AddItem(item, ++at));
}//end


void * DataList	::	NextPrevItems(	void * thisItem, 
									void ** nextItem, 
									void ** prevItem, 
									BottomButtons * bb) 
{
	DataNode * node;
	bool next;
	bool prev;
	bool listMe = false;
	void * returnNode = NULL;
	int32 p = -2, n, len = list->CountItems();
	if (!len) 
	{
		*nextItem = NULL;
		*prevItem = NULL;
		return(NULL);
	}
	else if (len == 1) 
	{
		*nextItem = NULL;
		*prevItem = NULL;
		return(thisItem);
	}
	n = len + 1;
	for (	int32 i = 0;
			i < len;
			i++) 
	{
		node = (DataNode *)((DataNode *)list->ItemAt(i))->data;
		if (node == thisItem) 
		{
			p = i - 1;
			n = i + 1;
			returnNode = node;
			i = len;
		}
	}
	if (p != -2) 
	{
		if (p == -1) *prevItem = NULL;
		else *prevItem = list->ItemAt(p);
	}
	else 
	{
		*prevItem = NULL;
	}
	if (n != (len + 1)) 
	{
		if (n == len) *nextItem = NULL;
		else *nextItem = list->ItemAt(n);
	}
	else 
	{
		*nextItem = NULL;
	}
	if (len > 1) 
	{
		listMe = true;
	}
	if (thisItem) 
	{
		if (*nextItem) 
		{
			next = true;
		}
		else 
		{
			next = false;
		}
		if (*prevItem) 
		{
			prev = true;
		}
		else 
		{
			prev = false;
		}
	}
	else 
	{
		next = false;
		prev = false;
	}
	bb->prev->SetEnabled(prev);
	bb->next->SetEnabled(next);
	bb->list->SetEnabled(listMe);
	return (returnNode);
}//end


void 
DataList	::	Remove(	void) 
{
	int32 len;
	if (!(len = list->CountItems())) 
	{
		return;
	}
	bool found = false;
	void * holdNode;
	DataNode * node;
	char * name;
	if (len == 1) 
	{
		switch (kind) 
		{
			case ELEMENT_TYPE:
				list->RemoveItem((void *)elementCurrent);
				delete elementCurrent;
				elementCurrent = NULL;
				return;
			break;
			case COMPOUND_TYPE:
				list->RemoveItem((void *)compoundCurrent);
				delete compoundCurrent;
				compoundCurrent = NULL;
				return;
			break;
			case UNIVERSE_TYPE:
				list->RemoveItem((void *)universeCurrent);
				delete universeCurrent;
				universeCurrent = NULL;
				return;
			break;
			case UNIVERSALCONSTANTS_TYPE:
				list->RemoveItem((void *)universalConstantsCurrent);
				delete universalConstantsCurrent;
				universalConstantsCurrent = NULL;
				return;
			break;
			case GALAXY_TYPE:
				list->RemoveItem((void *)galaxyCurrent);
				delete galaxyCurrent;
				galaxyCurrent = NULL;
				return;
			break;
			case WORMHOLE_TYPE:
				list->RemoveItem((void *)wormholeCurrent);
				delete wormholeCurrent;
				wormholeCurrent = NULL;
				return;
			break;
			case BLACKHOLE_TYPE:
				list->RemoveItem((void *)blackholeCurrent);
				delete blackholeCurrent;
				blackholeCurrent = NULL;
				return;
			break;
			case STAR_TYPE:
				list->RemoveItem((void *)starCurrent);
				delete starCurrent;
				starCurrent = NULL;
				return;
			break;
			case PLANET_TYPE:
				list->RemoveItem((void *)planetCurrent);
				delete planetCurrent;
				planetCurrent = NULL;
				return;
			break;
			case PLANETWEAPON_TYPE:
				list->RemoveItem((void *)planetWeaponCurrent);
				delete planetWeaponCurrent;
				planetWeaponCurrent = NULL;
				return;
			break;
			case PLANETSHIELD_TYPE:
				list->RemoveItem((void *)planetShieldCurrent);
				delete planetShieldCurrent;
				planetShieldCurrent = NULL;
				return;
			break;
			case SHIP_TYPE:
				list->RemoveItem((void *)shipCurrent);
				delete shipCurrent;
				shipCurrent = NULL;
				return;
			break;
			case SHIPWEAPON_TYPE:
				list->RemoveItem((void *)shipWeaponCurrent);
				delete shipWeaponCurrent;
				shipWeaponCurrent = NULL;
				return;
			break;
			case SHIPSHIELD_TYPE:
				list->RemoveItem((void *)shipShieldCurrent);
				delete shipShieldCurrent;
				shipShieldCurrent = NULL;
				return;
			break;
			case ENGINE_TYPE:
				list->RemoveItem((void *)engineCurrent);
				delete engineCurrent;
				engineCurrent = NULL;
				return;
			break;
			case FACTORY_TYPE:
				list->RemoveItem((void *)factoryCurrent);
				delete factoryCurrent;
				factoryCurrent = NULL;
				return;
			break;
			case MINE_TYPE:
				list->RemoveItem((void *)mineCurrent);
				delete mineCurrent;
				mineCurrent = NULL;
				return;
			break;
			case SPECIES_TYPE:
				list->RemoveItem((void *)speciesCurrent);
				delete speciesCurrent;
				speciesCurrent = NULL;
				return;
			break;
			default:
				warning(FailCaseDefaultDataList);
				return;
			break;
		}
	}
	switch (kind) 
	{
		case ELEMENT_TYPE:
			name = elementCurrent->name;
			return;
		break;
		case COMPOUND_TYPE:
			name = compoundCurrent->name;
			return;
		break;
		case UNIVERSE_TYPE:
			name = universeCurrent->name;
			return;
		break;
		case UNIVERSALCONSTANTS_TYPE:
			name = universalConstantsCurrent->name;
			return;
		break;
		case GALAXY_TYPE:
			name = galaxyCurrent->name;
			return;
		break;
		case WORMHOLE_TYPE:
			name = wormholeCurrent->name;
			return;
		break;
		case BLACKHOLE_TYPE:
			name = blackholeCurrent->name;
			return;
		break;
		case STAR_TYPE:
			name = starCurrent->name;
			return;
		break;
		case PLANET_TYPE:
			name = planetCurrent->name;
			return;
		break;
		case PLANETWEAPON_TYPE:
			name = planetWeaponCurrent->name;
			return;
		break;
		case PLANETSHIELD_TYPE:
			name = planetShieldCurrent->name;
			return;
		break;
		case SHIP_TYPE:
			name = shipCurrent->name;
			return;
		break;
		case SHIPWEAPON_TYPE:
			name = shipWeaponCurrent->name;
			return;
		break;
		case SHIPSHIELD_TYPE:
			name = shipShieldCurrent->name;
			return;
		break;
		case ENGINE_TYPE:
			name = engineCurrent->name;
			return;
		break;
		case FACTORY_TYPE:
			name = factoryCurrent->name;
			return;
		break;
		case MINE_TYPE:
			name = mineCurrent->name;
			return;
		break;
		case SPECIES_TYPE:
			name = speciesCurrent->name;
			return;
		break;
		default:
			warning(FailCaseDefaultDataList);
			return;
		break;
	}
	for (	int32 i = 0;
			#pragma warn_possunwant off
			node = (DataNode *)((DataNode *)list->ItemAt(i))->data;
			#pragma warn_possunwant reset
			i++) 
	{
		if (!strcmp(node->MyName(kind), name)) 
		{
			if (i == 0) 
			{
				switch (kind) 
				{
					case ELEMENT_TYPE:
						list->RemoveItem((void *)elementCurrent);
						delete elementCurrent;
						elementCurrent = (Element *)(((DataNode *)list->ItemAt(0))->data);
						return;
					break;
					case COMPOUND_TYPE:
						list->RemoveItem((void *)compoundCurrent);
						delete compoundCurrent;
						compoundCurrent = (Compound *)(((DataNode *)list->ItemAt(0))->data);
						return;
					break;
					case UNIVERSE_TYPE:
						list->RemoveItem((void *)universeCurrent);
						delete universeCurrent;
						universeCurrent = (Universe *)(((DataNode *)list->ItemAt(0))->data);
						return;
					break;
					case UNIVERSALCONSTANTS_TYPE:
						list->RemoveItem((void *)universalConstantsCurrent);
						delete universalConstantsCurrent;
						universalConstantsCurrent = (Universe *)(((DataNode *)list->ItemAt(0))->data);
						return;
					break;
					case GALAXY_TYPE:
						list->RemoveItem((void *)galaxyCurrent);
						delete galaxyCurrent;
						galaxyCurrent = (Galaxy *)(((DataNode *)list->ItemAt(0))->data);
						return;
					break;
					case WORMHOLE_TYPE:
						list->RemoveItem((void *)wormholeCurrent);
						delete wormholeCurrent;
						wormholeCurrent = (Wormhole *)(((DataNode *)list->ItemAt(0))->data);
						return;
					break;
					case BLACKHOLE_TYPE:
						list->RemoveItem((void *)blackholeCurrent);
						delete blackholeCurrent;
						blackholeCurrent = (Blackhole *)(((DataNode *)list->ItemAt(0))->data);
						return;
					break;
					case STAR_TYPE:
						list->RemoveItem((void *)starCurrent);
						delete starCurrent;
						starCurrent = (Star *)(((DataNode *)list->ItemAt(0))->data);
						return;
					break;
					case PLANET_TYPE:
						list->RemoveItem((void *)planetCurrent);
						delete planetCurrent;
						planetCurrent = (Planet *)(((DataNode *)list->ItemAt(0))->data);
						return;
					break;
					case PLANETWEAPON_TYPE:
						list->RemoveItem((void *)planetWeaponCurrent);
						delete planetWeaponCurrent;
						planetWeaponCurrent = (PlanetWeapon *)(((DataNode *)list->ItemAt(0))->data);
						return;
					break;
					case PLANETSHIELD_TYPE:
						list->RemoveItem((void *)planetShieldCurrent);
						delete planetShieldCurrent;
						planetShieldCurrent = (PlanetShield *)(((DataNode *)list->ItemAt(0))->data);
						return;
					break;
					case SHIP_TYPE:
						list->RemoveItem((void *)shipCurrent);
						delete shipCurrent;
						shipCurrent = (Ship *)(((DataNode *)list->ItemAt(0))->data);
						return;
					break;
					case SHIPWEAPON_TYPE:
						list->RemoveItem((void *)shipWeaponCurrent);
						delete shipWeaponCurrent;
							shipWeaponCurrent = (ShipWeapon *)(((DataNode *)list->ItemAt(0))->data);
						return;
					break;
					case SHIPSHIELD_TYPE:
						list->RemoveItem((void *)shipShieldCurrent);
						delete shipShieldCurrent;
						shipShieldCurrent = (ShipShield *)(((DataNode *)list->ItemAt(0))->data);
						return;
					break;
					case ENGINE_TYPE:
						list->RemoveItem((void *)engineCurrent);
						delete engineCurrent;
						engineCurrent = (Engine *)(((DataNode *)list->ItemAt(0))->data);
						return;
					break;
					case FACTORY_TYPE:
						list->RemoveItem((void *)factoryCurrent);
						delete factoryCurrent;
						factoryCurrent = (Factory *)(((DataNode *)list->ItemAt(0))->data);
						return;
					break;
					case MINE_TYPE:
						list->RemoveItem((void *)mineCurrent);
						delete mineCurrent;
						mineCurrent = (Mine *)(((DataNode *)list->ItemAt(0))->data);
						return;
					break;
					case SPECIES_TYPE:
						list->RemoveItem((void *)speciesCurrent);
						delete speciesCurrent;
						speciesCurrent = (Species *)(((DataNode *)list->ItemAt(0))->data);
						return;
					break;
					default:
						warning(FailCaseDefaultDataList);
						return;
					break;
				}
			}
			else if (i == (len - 1)) 
			{
				switch (kind) 
				{
					case ELEMENT_TYPE:
						list->RemoveItem((void *)elementCurrent);
						delete elementCurrent;
						elementCurrent = (Element *)(((DataNode *)list->ItemAt(len - 2))->data);
						return;
					break;
					case COMPOUND_TYPE:
						list->RemoveItem((void *)compoundCurrent);
						delete compoundCurrent;
						compoundCurrent = (Compound *)(((DataNode *)list->ItemAt(len - 2))->data);
						return;
					break;
					case UNIVERSE_TYPE:
						list->RemoveItem((void *)universeCurrent);
						delete universeCurrent;
						universeCurrent = (Universe *)(((DataNode *)list->ItemAt(len - 2))->data);
						return;
					break;
					case UNIVERSALCONSTANTS_TYPE:
						list->RemoveItem((void *)universalConstantsCurrent);
						delete universalConstantsCurrent;
						universalConstantsCurrent = (Universe *)(((DataNode *)list->ItemAt(len - 2))->data);
						return;
					break;
					case GALAXY_TYPE:
						list->RemoveItem((void *)galaxyCurrent);
						delete galaxyCurrent;
						galaxyCurrent = (Galaxy *)(((DataNode *)list->ItemAt(len - 2))->data);
						return;
					break;
					case WORMHOLE_TYPE:
						list->RemoveItem((void *)wormholeCurrent);
						delete wormholeCurrent;
						wormholeCurrent = (Wormhole *)(((DataNode *)list->ItemAt(len - 2))->data);
						return;
					break;
					case BLACKHOLE_TYPE:
						list->RemoveItem((void *)blackholeCurrent);
						delete blackholeCurrent;
						blackholeCurrent = (Blackhole *)(((DataNode *)list->ItemAt(len - 2))->data);
						return;
					break;
					case STAR_TYPE:
						list->RemoveItem((void *)starCurrent);
						delete starCurrent;
						starCurrent = (Star *)(((DataNode *)list->ItemAt(len - 2))->data);
						return;
					break;
					case PLANET_TYPE:
						list->RemoveItem((void *)planetCurrent);
						delete planetCurrent;
						planetCurrent = (Planet *)(((DataNode *)list->ItemAt(len - 2))->data);
						return;
					break;
					case PLANETWEAPON_TYPE:
						list->RemoveItem((void *)planetWeaponCurrent);
						delete planetWeaponCurrent;
						planetWeaponCurrent = (PlanetWeapon *)(((DataNode *)list->ItemAt(len - 2))->data);
						return;
					break;
					case PLANETSHIELD_TYPE:
						list->RemoveItem((void *)planetShieldCurrent);
						delete planetShieldCurrent;
						planetShieldCurrent = (PlanetShield *)(((DataNode *)list->ItemAt(len - 2))->data);
						return;
					break;
					case SHIP_TYPE:
						list->RemoveItem((void *)shipCurrent);
						delete shipCurrent;
						shipCurrent = (Ship *)(((DataNode *)list->ItemAt(len - 2))->data);
						return;
					break;
					case SHIPWEAPON_TYPE:
						list->RemoveItem((void *)shipWeaponCurrent);
						delete shipWeaponCurrent;
						shipWeaponCurrent = (ShipWeapon *)(((DataNode *)list->ItemAt(len - 2))->data);
						return;
					break;
					case SHIPSHIELD_TYPE:
						list->RemoveItem((void *)shipShieldCurrent);
						delete shipShieldCurrent;
						shipShieldCurrent = (ShipShield *)(((DataNode *)list->ItemAt(len - 2))->data);
						return;
					break;
					case ENGINE_TYPE:
						list->RemoveItem((void *)engineCurrent);
						delete engineCurrent;
						engineCurrent = (Engine *)(((DataNode *)list->ItemAt(len - 2))->data);
						return;
					break;
					case FACTORY_TYPE:
						list->RemoveItem((void *)factoryCurrent);
						delete factoryCurrent;
						factoryCurrent = (Factory *)(((DataNode *)list->ItemAt(len - 2))->data);
						return;
					break;
					case MINE_TYPE:
						list->RemoveItem((void *)mineCurrent);
						delete mineCurrent;
						mineCurrent = (Mine *)(((DataNode *)list->ItemAt(len - 2))->data);
						return;
					break;
					case SPECIES_TYPE:
						list->RemoveItem((void *)speciesCurrent);
						delete speciesCurrent;
						speciesCurrent = (Species *)(((DataNode *)list->ItemAt(len - 2))->data);
						return;
					break;
					default:
						warning(FailCaseDefaultDataList);
						return;
					break;
				}
			}
			else 
			{//right now ->ItemAt(i) gives us the next item as current
				switch (kind) 
				{
					case ELEMENT_TYPE:
						list->RemoveItem((void *)elementCurrent);
						delete elementCurrent;
						elementCurrent = (Element *)(((DataNode *)list->ItemAt(i))->data);
						return;
					break;
					case COMPOUND_TYPE:
						list->RemoveItem((void *)compoundCurrent);
						delete compoundCurrent;
						compoundCurrent = (Compound *)(((DataNode *)list->ItemAt(i))->data);
						return;
					break;
					case UNIVERSE_TYPE:
						list->RemoveItem((void *)universeCurrent);
						delete universeCurrent;
						universeCurrent = (Universe *)(((DataNode *)list->ItemAt(i))->data);
						return;
					break;
					case UNIVERSALCONSTANTS_TYPE:
						list->RemoveItem((void *)universalConstantsCurrent);
						delete universalConstantsCurrent;
						universalConstantsCurrent = (Universe *)(((DataNode *)list->ItemAt(i))->data);
						return;
					break;
					case GALAXY_TYPE:
						list->RemoveItem((void *)galaxyCurrent);
						delete galaxyCurrent;
						galaxyCurrent = (Galaxy *)(((DataNode *)list->ItemAt(i))->data);
						return;
					break;
					case WORMHOLE_TYPE:
						list->RemoveItem((void *)wormholeCurrent);
						delete wormholeCurrent;
						wormholeCurrent = (Wormhole *)(((DataNode *)list->ItemAt(i))->data);
						return;
					break;
					case BLACKHOLE_TYPE:
						list->RemoveItem((void *)blackholeCurrent);
						delete blackholeCurrent;
						blackholeCurrent = (Blackhole *)(((DataNode *)list->ItemAt(i))->data);
						return;
					break;
					case STAR_TYPE:
						list->RemoveItem((void *)starCurrent);
						delete starCurrent;
						starCurrent = (Star *)(((DataNode *)list->ItemAt(i))->data);
						return;
					break;
					case PLANET_TYPE:
						list->RemoveItem((void *)planetCurrent);
						delete planetCurrent;
						planetCurrent = (Planet *)(((DataNode *)list->ItemAt(i))->data);
						return;
					break;
					case PLANETWEAPON_TYPE:
						list->RemoveItem((void *)planetWeaponCurrent);
						delete planetWeaponCurrent;
						planetWeaponCurrent = (PlanetWeapon *)(((DataNode *)list->ItemAt(i))->data);
						return;
					break;
					case PLANETSHIELD_TYPE:
						list->RemoveItem((void *)planetShieldCurrent);
						delete planetShieldCurrent;
						planetShieldCurrent = (PlanetShield *)(((DataNode *)list->ItemAt(i))->data);
						return;
					break;
					case SHIP_TYPE:
						list->RemoveItem((void *)shipCurrent);
						delete shipCurrent;
						shipCurrent = (Ship *)(((DataNode *)list->ItemAt(i))->data);
						return;
					break;
					case SHIPWEAPON_TYPE:
						list->RemoveItem((void *)shipWeaponCurrent);
						delete shipWeaponCurrent;
						shipWeaponCurrent = (ShipWeapon *)(((DataNode *)list->ItemAt(i))->data);
						return;
					break;
					case SHIPSHIELD_TYPE:
						list->RemoveItem((void *)shipShieldCurrent);
						delete shipShieldCurrent;
						shipShieldCurrent = (ShipShield *)(((DataNode *)list->ItemAt(i))->data);
						return;
					break;
					case ENGINE_TYPE:
						list->RemoveItem((void *)engineCurrent);
						delete engineCurrent;
						engineCurrent = (Engine *)(((DataNode *)list->ItemAt(i))->data);
						return;
					break;
					case FACTORY_TYPE:
						list->RemoveItem((void *)factoryCurrent);
						delete factoryCurrent;
						factoryCurrent = (Factory *)(((DataNode *)list->ItemAt(i))->data);
						return;
					break;
					case MINE_TYPE:
						list->RemoveItem((void *)mineCurrent);
						delete mineCurrent;
						mineCurrent = (Mine *)(((DataNode *)list->ItemAt(i))->data);
						return;
					break;
					case SPECIES_TYPE:
						list->RemoveItem((void *)speciesCurrent);
						delete speciesCurrent;
						speciesCurrent = (Species *)(((DataNode *)list->ItemAt(i))->data);
						return;
					break;
					default:
						warning(FailCaseDefaultDataList);
						return;
					break;
				}
			}
		}
	}
	warning(notOnDataList);
}//end


void * 
DataList	::	RealItemFromName(	const char * testName, 
									int32 * fillFromI) 
{
	DataNode * node;
	for (	int32 i = 0;
			#pragma warn_possunwant off
			node = (DataNode *)list->ItemAt(i);
			#pragma warn_possunwant reset
			i++) 
	{
		if (!strcmp(testName, node->MyName(kind))) 
		{
			*fillFromI = i;
			return node;
		}
	}
	return NULL;
}//end


void 
DataList	::	Merge(	MergeList * mergeMe) 
{
	int32 len;
	int32 lenMe = mergeMe->list->CountItems();
	bool merged = false;
	if (!lenMe) 
	{
		return;
	}
	DataNode * thisNode;
	MergeNode * mergeMeNode;
	for (	int32 i = 0;
			i < lenMe;
			i++) 
	{
		merged = false;
		mergeMeNode = (MergeNode *)mergeMe->list->ItemAt(i);
		len = list->CountItems();
		for (	int32 j = 0;
				j < len;
				j++) 
		{
			thisNode = (DataNode *)list->ItemAt(j);
			if (!strcmp(thisNode->MyName(kind), mergeMeNode->MyName(mergeMe->kind))) 
			{
				merged = true;
				if (MergeHow(thisNode, mergeMeNode)) 
				{
					switch (kind) 
					{
						case ELEMENT_TYPE:
							Element * thisElement = (Element *)thisNode->data;
							Element * thatElement = (Element *)mergeMeNode->data;
							thisElement->mass = thatElement->mass;
							thisElement->volume = thatElement->volume;
							thisElement->vper = thatElement->vper;
							thisElement->electron = thatElement->electron;
							thisElement->neutron = thatElement->neutron;
							thisElement->proton = thatElement->proton;
						break;
						case COMPOUND_TYPE:
							Compound * thisCompound = (Compound *)thisNode->data;
							Compound * thatCompound = (Compound *)mergeMeNode->data;
							thisCompound->mass = thatCompound->mass;
							thisCompound->volume = thatCompound->volume;
							thisCompound->vper = thatCompound->vper;
						break;
						case UNIVERSE_TYPE:
							Universe * thisUniverse = (Universe *)thisNode->data;
							Universe * thatUniverse = (Universe *)mergeMeNode->data;
						break;
						case UNIVERSALCONSTANTS_TYPE:
							UniversalConstants * thisUniversalConstants = (UniversalConstants *)thisNode->data;
							UniversalConstants * thatUniversalConstants = (UniversalConstants *)mergeMeNode->data;
						break;
						case GALAXY_TYPE://debug finish these
						break;
						case WORMHOLE_TYPE:
						break;
						case BLACKHOLE_TYPE:
						break;
						case STAR_TYPE:
						break;
						case PLANET_TYPE:
						break;
						case PLANETWEAPON_TYPE:
						break;
						case PLANETSHIELD_TYPE:
						break;
						case SHIP_TYPE:
						break;
						case SHIPWEAPON_TYPE:
						break;
						case SHIPSHIELD_TYPE:
						break;
						case ENGINE_TYPE:
						break;
						case FACTORY_TYPE:
						break;
						case MINE_TYPE:
							Mine * thisMine = (Mine *)thisNode->data;
							Mine * thatMine = (Mine *)mergeMeNode->data;
							thisMine->mass = thatMine->mass;
							thisMine->volume = thatMine->volume;
							thisMine->vper = thatMine->vper;
						break;
						case SPECIES_TYPE:
						break;
						default:
							warning(FailCaseDefaultDataList);
						break;
					}
				}
			}
			if (merged) j = len;
		}
		if (!merged) 
		{
			mergeMeNode->howMerged = MERGEDADD;
			switch (kind) 
			{
				case ELEMENT_TYPE:
					Element * mergeElement = (Element *)mergeMeNode->data;
					Element * newElement = new Element(mergeElement, mergeElement->name);
					if (!newElement) warning(FailCreate[kind]);
				break;
				case COMPOUND_TYPE:
					Compound * mergeCompound = (Compound *)mergeMeNode->data;
					Compound * newCompound = new Compound(mergeCompound, mergeCompound->name);
					if (!newCompound) warning(FailCreate[kind]);
				break;
				case UNIVERSE_TYPE:
					Universe * mergeUniverse = (Universe *)mergeMeNode->data;
					Universe * newUniverse = new Universe(mergeUniverse, mergeUniverse->name);
					if (!newUniverse) warning(FailCreate[kind]);
				break;
				case UNIVERSALCONSTANTS_TYPE:
					UniversalConstants * mergeUniversalConstants = (UniversalConstants *)mergeMeNode->data;
					UniversalConstants * newUniversalConstants = new UniversalConstants(mergeUniverse, mergeUniverse->name);
					if (!newUniversalConstants) warning(FailCreate[kind]);
				break;
				case GALAXY_TYPE:
					Galaxy * mergeGalaxy = (Galaxy *)mergeMeNode->data;
					Galaxy * newGalaxy = new Galaxy(mergeGalaxy, mergeGalaxy->name);
					if (!newGalaxy) warning(FailCreate[kind]);
				break;
				case WORMHOLE_TYPE:
					Wormhole * mergeWormhole = (Wormhole *)mergeMeNode->data;
					Wormhole * newWormhole = new Wormhole(mergeWormhole, mergeWormhole->name);
					if (!newWormhole) warning(FailCreate[kind]);
				break;
				case BLACKHOLE_TYPE:
					Blackhole * mergeBlackhole = (Blackhole *)mergeMeNode->data;
					Blackhole * newBlackhole = new Blackhole(mergeBlackhole, mergeBlackhole->name);
					if (!newBlackhole) warning(FailCreate[kind]);
				break;
				case STAR_TYPE:
					Star * mergeStar = (Star *)mergeMeNode->data;
					Star * newStar = new Star(mergeStar, mergeStar->name);
					if (!newStar) warning(FailCreate[kind]);
				break;
				case PLANET_TYPE:
					Planet * mergePlanet = (Planet *)mergeMeNode->data;
					Planet * newPlanet = new Planet(mergePlanet, mergePlanet->name);
					if (!newPlanet) warning(FailCreate[kind]);
				break;
				case PLANETWEAPON_TYPE:
					PlanetWeapon * mergePlanetWeapon = (PlanetWeapon *)mergeMeNode->data;
					PlanetWeapon * newPlanetWeapon = new PlanetWeapon(mergePlanetWeapon, mergePlanetWeapon->name);
					if (!newPlanetWeapon) warning(FailCreate[kind]);
				break;
				case PLANETSHIELD_TYPE:
					PlanetShield * mergePlanetShield = (PlanetShield *)mergeMeNode->data;
					PlanetShield * newPlanetShield = new PlanetShield(mergePlanetShield, mergePlanetShield->name);
					if (!newPlanetShield) warning(FailCreate[kind]);
				break;
				case SHIP_TYPE:
					Ship * mergeShip = (Ship *)mergeMeNode->data;
					Ship * newShip = new Ship(mergeShip, mergeShip->name);
					if (!newShip) warning(FailCreate[kind]);
				break;
				case SHIPWEAPON_TYPE:
					ShipWeapon * mergeShipWeapon = (ShipWeapon *)mergeMeNode->data;
					ShipWeapon * newShipWeapon = new ShipWeapon(mergeShipWeapon, mergeShipWeapon->name);
					if (!newShipWeapon) warning(FailCreate[kind]);
				break;
				case SHIPSHIELD_TYPE:
					ShipShield * mergeShipShield = (ShipShield *)mergeMeNode->data;
					ShipShield * newShipShield = new ShipShield(mergeShipShield, mergeShipShield->name);
					if (!newShipShield) warning(FailCreate[kind]);
				break;
				case ENGINE_TYPE:
					Engine * mergeEngine = (Engine *)mergeMeNode->data;
					Engine * newEngine = new Engine(mergeEngine, mergeEngine->name);
					if (!newEngine) warning(FailCreate[kind]);
				break;
				case FACTORY_TYPE:
					Factory * mergeFactory = (Factory *)mergeMeNode->data;
					Factory * newFactory = new Factory(mergeFactory, mergeFactory->name);
					if (!newFactory) warning(FailCreate[kind]);
				break;
				case MINE_TYPE:
					Mine * mergeMine = (Mine *)mergeMeNode->data;
					Mine * newMine = new Mine(mergeMine, mergeMine->name);
					if (!newMine) warning(FailCreate[kind]);
				break;
				case SPECIES_TYPE:
					Species * mergeSpecies = (Species *)mergeMeNode->data;
					Species * newSpecies = new Species(mergeSpecies, mergeSpecies->name);
					if (!newSpecies) warning(FailCreate[kind]);
				break;
				default:
					warning(FailCaseDefaultDataList);
				break;
			}
		}
	}
}//end


bool 
DataList	::	MergeHow(	DataNode *oldNode, 
							MergeNode *newNode) 
{
	char * alertMsg = NULL;
	int32 msgLen;
	int32 lenPreAlertMsg = strlen(preAlertMsgStr);
	int32 lenAlertMsg = lenPreAlertMsg + strlen(oldNode->MyName(kind)) + strlen(thingStr[kind]) + 4;
	
	switch (kind) 
	{
		case ELEMENT_TYPE:
			int32 lennumElementalElectrons = 3 + (2 * strlen(numElementalElectrons));
			int32 lennumElementalNeutrons = 3 + (2 * strlen(numElementalNeutrons));
			int32 lennumElementalProtons = 3 + (2 * strlen(numElementalProtons));
			int32 lennumVolumeStr = 3 + (2 * strlen(numVolumeStr));
			int32 lennumVPerStr = 3 + (2 * strlen(numVPerStr));
			Element * oldElement = (Element *)oldNode->data;
			Element * newElement = (Element *)newNode->data;
			char oldElementElectron[32];
			char oldElementNeutron[32];
			char oldElementn[32];
			char oldElementVolume[32];
			char oldElementVPer[32];
			char newElementElectron[32];
			char newElementNeutron[32];
			char newElementn[32];
			char newElementVolume[32];
			char newElementVPer[32];
			SPRTF(oldElementElectron, "%u\n", oldElement->electron);
			SPRTF(oldElementNeutron, "%u\n", oldElement->neutron);
			SPRTF(oldElementn, "%u\n", oldElement->proton);
			SPRTF(oldElementVolume, "%u", oldElement->volume);
			SPRTF(oldElementVPer, "%u\n\n", oldElement->vper);
			SPRTF(newElementElectron, "%u\n", newElement->electron);
			SPRTF(newElementNeutron, "%u\n", newElement->neutron);
			SPRTF(newElementn, "%u\n", newElement->proton);
			SPRTF(newElementVolume, "%u", newElement->volume);
			SPRTF(newElementVPer, "%u\n", newElement->vper);
			msgLen = lenAlertMsg + 
				lennumElementalElectrons + lennumElementalNeutrons + lennumElementalProtons + lennumVolumeStr + lennumVPerStr +
				strlen(oldEHeaderStr) + 
				strlen(oldElementElectron) + strlen(oldElementNeutron) + strlen(oldElementn) + strlen(oldElementVolume) + strlen(oldElementVPer) + 
				strlen(newEHeaderStr) + 
				strlen(newElementElectron) + strlen(newElementNeutron) + strlen(newElementn) + strlen(newElementVolume) + strlen(newElementVPer) + 1;
			alertMsg = (char *)malloc(msgLen);
			if (!alertMsg) 
			{
				warning(FailMemory);
				return false;
			}
			strcpy(alertMsg, preAlertMsgStr);
			strcat(alertMsg, thingStr[kind]);
			strcat(alertMsg, " ");
			strcat(alertMsg, oldNode->MyName(kind));
			strcat(alertMsg, "\n\n");
			strcat(alertMsg, oldEHeaderStr);
			strcat(alertMsg, numElementalElectrons);
			strcat(alertMsg, " ");
			strcat(alertMsg, oldElementElectron);
			strcat(alertMsg, numElementalNeutrons);
			strcat(alertMsg, " ");
			strcat(alertMsg, oldElementNeutron);
			strcat(alertMsg, numElementalProtons);
			strcat(alertMsg, " ");
			strcat(alertMsg, oldElementn);
			strcat(alertMsg, numVolumeStr);
			strcat(alertMsg, " ");
			strcat(alertMsg, oldElementVolume);
			strcat(alertMsg, " ");
			strcat(alertMsg, numVPerStr);
			strcat(alertMsg, " ");
			strcat(alertMsg, oldElementVPer);
			strcat(alertMsg, newEHeaderStr);
			strcat(alertMsg, numElementalElectrons);
			strcat(alertMsg, " ");
			strcat(alertMsg, newElementElectron);
			strcat(alertMsg, numElementalNeutrons);
			strcat(alertMsg, " ");
			strcat(alertMsg, newElementNeutron);
			strcat(alertMsg, numElementalProtons);
			strcat(alertMsg, " ");
			strcat(alertMsg, newElementn);
			strcat(alertMsg, numVolumeStr);
			strcat(alertMsg, " ");
			strcat(alertMsg, newElementVolume);
			strcat(alertMsg, " ");
			strcat(alertMsg, numVPerStr);
			strcat(alertMsg, " ");
			strcat(alertMsg, newElementVPer);
		break;
		case COMPOUND_TYPE:
			Compound * oldCompound = (Compound *)oldNode->data;
			Compound * newCompound = (Compound *)newNode->data;
			int32 numOldElements = oldCompound->eList->list->CountItems();
			int32 numOldCompounds = oldCompound->cList->list->CountItems();
			int32 numNewElements = newCompound->eList->list->CountItems();
			int32 numNewCompounds = newCompound->cList->list->CountItems();
			char oldCompoundENum[32];
			char oldCompoundCNum[32];
			char newCompoundENum[32];
			char newCompoundCNum[32];
			SPRTF(oldCompoundENum, "%d\n", numOldElements);
			SPRTF(oldCompoundCNum, "%d\n\n", numOldCompounds);
			SPRTF(newCompoundENum, "%d\n", numNewElements);
			SPRTF(newCompoundCNum, "%d\n\n", numNewCompounds);
			msgLen = lenAlertMsg + 
				(2 * (strlen(numElementsStr))) + (2 * (strlen(numCompoundsStr))) + 
				strlen(oldCHeaderStr) + 
				strlen(oldCompoundENum) + strlen(oldCompoundCNum) + 
				strlen(newCHeaderStr) + 
				strlen(newCompoundENum) + strlen(newCompoundCNum) +  + 1;
			alertMsg = (char *)malloc(msgLen);
			if (!alertMsg) 
			{
				warning(FailMemory);
				return false;
			}
			strcpy(alertMsg, preAlertMsgStr);
			strcat(alertMsg, thingStr[kind]);
			strcat(alertMsg, " ");
			strcat(alertMsg, oldNode->MyName(kind));
			strcat(alertMsg, "\n\n");
			strcat(alertMsg, oldCHeaderStr);
			strcat(alertMsg, numElementsStr);
			strcat(alertMsg, oldCompoundENum);
			strcat(alertMsg, numCompoundsStr);
			strcat(alertMsg, oldCompoundCNum);
			strcat(alertMsg, newCHeaderStr);
			strcat(alertMsg, numElementsStr);
			strcat(alertMsg, newCompoundENum);
			strcat(alertMsg, numCompoundsStr);
			strcat(alertMsg, newCompoundCNum);
		break;
		//debug add other kinds
		case MINE_TYPE:
			beep();
		break;
	}
	BAlert * alert = new BAlert(	NULL, 
									alertMsg, 
									useOldStr, 
									useNewStr, 
									NULL, 
									B_WIDTH_FROM_WIDEST, 
									B_EMPTY_ALERT);
	if (alert) 
	{
		int32 result = alert->Go();
		if (result) newNode->howMerged = MERGEDREPLACED;
		else newNode->howMerged = MERGEDCUT;
		return (bool)result;
	}
	warning(FailMemory);
	return false;
}//end