//fontPrefWindow.cpp

#include "DmenuMsg.h"
#include "DtinySnooze.h"
#include "windowGuts.h"
#include <memory>
#include <string>
#include "Xs2f.h"
#include "XlayoutMatrixItem.h"
#include "DlayoutMatrix.h"
#include "layoutMatrixItem.h"
#include "layoutMatrix.h"
#include "myButton.h"
#include "floatGadget.h"
#include "uInt32Gadget.h"
#include "textItem.h"
#include "myStringDrawer.h"
#include "myCheckBox.h"
#include "myPopUpMenu.h"
#include "myCheckBox.h"
#include "prefPanelWindow.h"
#include "fontPrefWindow.h"
#include "XfontPrefWindow.h"
#include "fontDisplayWindow.h"
#include "Xwarning.h"
#include "preferences.h"
#include "myroColour.h"
#include "myPreferences.h"
#include "myApp.h"
#include "titleWindow.h"
#include "Xverify.h"

//ctor
FontPrefWindow	::	FontPrefWindow(	BRect	paramBound,
									const char * paramWindowTitle,
									const char * paramScrollViewName,
									const char * paramNamePrefFrame)
				: 
				WindowGuts(	paramBound, 
							paramWindowTitle, 
							paramScrollViewName,
							paramNamePrefFrame),
				mpFontDisplayWindow(NULL)
{
	sem_id calc_sem;
	if ((calc_sem = create_sem(1, "calc_sem")) < B_NO_ERROR)
	{
		warning(FailCreateSemaphore);
		return;
	}
	acquire_sem(calc_sem);
	try 
	{
		LayoutMatrix *	pholdFontPrefWindowLayoutMatrix = new LayoutMatrix(BESTSIZE, 8, 1, this);//rows,columns
/////////////////////////////////////////////////////////////////////////////////////////////
		BFont * pHBFont = new BFont(myPrefs->GetPreferredFont());
		float fontSize = pHBFont->Size();
		fontSize *= 3;
		if (fontSize > 200)
		{
			fontSize = 200;
		}
		pHBFont->SetSize(fontSize);
		pHBFont->SetShear(122);
		//calc font height for offset of PUMs--you could use a seperate matrix and get it's bottom
		float pumOffset;
		{
			BView view(BRect(0, 0, 32, 32), NoShowView, B_FOLLOW_NONE, NULL);
			view.SetFont(pHBFont);
			font_height	fontHeight;
			view.GetFontHeight(&fontHeight);
			pumOffset = fontHeight.ascent + fontHeight.descent + fontHeight.leading;
			view.RemoveSelf();
		}
		MyStringDrawer * pMyStringDrawer = new MyStringDrawer(	"fontPrefMyStringDrawer", 
																FontPrefWindowHeading1, 
																B_FOLLOW_NONE, 
																B_WILL_DRAW,
																pHBFont,
																pholdFontPrefWindowLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apMyStringDrawerLayoutMatrixItem(new LayoutMatrixItem(	(void *)pMyStringDrawer, 
																							pholdFontPrefWindowLayoutMatrix->itemsList,
																							KIND_STRINGDRAWER));
////////////////////////////////////////////////////////////////////////////////
		MyButton * pholdBiggerFontMyButton = new MyButton(	"BiggerFontButton", 
															BiggerFontButtonLable, 
															BIGGER_FONT,
															B_FOLLOW_NONE, 
															B_WILL_DRAW,
															pholdFontPrefWindowLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apBiggerFontMyButtonLayoutMatrixItem(new LayoutMatrixItem(	(void *)pholdBiggerFontMyButton, 
																								pholdFontPrefWindowLayoutMatrix->itemsList,
																								KIND_MYBUTTON));
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		MyButton * pholdSmallerFontMyButton = new MyButton(	"SmallerFontButton", 
															SmallerFontButtonLable, 
															SMALLER_FONT,
															B_FOLLOW_NONE, 
															B_WILL_DRAW,
															pholdFontPrefWindowLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apSmallerFontMyButtonLayoutMatrixItem(new LayoutMatrixItem(	(void *)pholdSmallerFontMyButton, 
																									pholdFontPrefWindowLayoutMatrix->itemsList,
																									KIND_MYBUTTON));
//////////////////////////////////////////////////////////////////
		FloatGadget * pholdFloatGadget = new FloatGadget(	myPrefs->GetPreferredFont()->Size(),
															"FontSizeFloatGadget", 
															EnterFontSizeLable, 
															FONT_SIZE_STR,
															B_FOLLOW_NONE, 
															B_WILL_DRAW | B_NAVIGABLE,
															0,
															pholdFontPrefWindowLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apFontSizeLayoutMatrixItem(new LayoutMatrixItem(	(void *)pholdFloatGadget, 
																					pholdFontPrefWindowLayoutMatrix->itemsList,
																					KIND_FLOATGADG));
		mpSizeFloatGadget = pholdFloatGadget;
//////////////////////////////////////////////////////////////////
		mpDisplayFontCheckBox = new MyCheckBox(	"displayFont", 
												DisplayFontCheckBoxLable,
												myPrefs->bOpenFontDisplay,
												DISPLAY_FONT,
												B_FOLLOW_NONE, 
												B_WILL_DRAW,
												pholdFontPrefWindowLayoutMatrix);
		LayoutMatrixItem * displayFontLMI = new LayoutMatrixItem(	(void *)mpDisplayFontCheckBox, 
																	pholdFontPrefWindowLayoutMatrix->itemsList,
																	KIND_MYCHECKBOX);
/////////////////////////////////////////////
	BFont * currentFont = myPrefs->GetPreferredFont();
	currentFont->GetFamilyAndStyle(&mffFamilyName, &mfsStyleName);
	BList * PUMFontFamilyList = new BList();
	int32 numFamilies = count_font_families();
	for (	uint32 i = 0; 
			i < numFamilies;
			i++ ) 
	{ 
		font_family family; 
   		uint32 flags; 
   		if ( get_font_family(i, &family, &flags) == B_OK ) 
   		{
			PopUpMenuData  * PUMFontFamilyData = new PopUpMenuData(family, PUMFontFamilyList);
   		} 
	}
	TextItem * pFontFamilyPUMLabelText = new TextItem(	FontFamilyPUMLabel,
														pholdFontPrefWindowLayoutMatrix);
	mpFontFamilyPUM = new MyPopUpMenu(	"fontFamilyPUM", 
										mffFamilyName,
										PUMFontFamilyList, 
										true,
										pFontFamilyPUMLabelText,
										pholdFontPrefWindowLayoutMatrix);
	if (!mpFontFamilyPUM->Initialize()) 
	{
		warning(FailPUMInitFontWindow);
	}
	auto_ptr<LayoutMatrixItem> apPUMFontFamily(new LayoutMatrixItem(	(void *)mpFontFamilyPUM, 
																		pholdFontPrefWindowLayoutMatrix->itemsList,
																		KIND_MYPOPUPMENU));
///////////////////////////////////////////////////////////////////////////
	BList * PUMFontStyleList = new BList();
	uint32 numStyles = count_font_styles(mffFamilyName);
	for (	uint32 j = 0;
			j < numStyles;
			j++ ) 
	{ 
	    font_style style;
   		uint32 flags; 
	    if ( get_font_style(mffFamilyName, j, &style, &flags) == B_OK ) 
	    { 
	    	PopUpMenuData * PUMDataFontStyle = new PopUpMenuData(style, PUMFontStyleList);
	    } 
	}
	TextItem * pFontStylePUMLabelText = new TextItem(	FontStylePUMLabel,
														pholdFontPrefWindowLayoutMatrix);
	mpFontStylePUM = new MyPopUpMenu(	"fontStylePUM", 
										mfsStyleName,
										PUMFontStyleList, 
										true,
										pFontStylePUMLabelText,
										pholdFontPrefWindowLayoutMatrix);
	if (!mpFontStylePUM->Initialize()) 
	{
		warning(FailPUMInitFontWindow);
	}
	auto_ptr<LayoutMatrixItem> apPUMFontStyle(new LayoutMatrixItem(	(void *)mpFontStylePUM, 
																	pholdFontPrefWindowLayoutMatrix->itemsList,
																	KIND_MYPOPUPMENU));
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		mpAntiAliasFontCheckBox = new MyCheckBox(	"antialiasFont", 
													AntiAliasFont,
													myPrefs->bAntiAliasFont,
													ANTIALIAS_FONT,
													B_FOLLOW_NONE, 
													B_WILL_DRAW,
													pholdFontPrefWindowLayoutMatrix);
		LayoutMatrixItem * antialiasFontLMI = new LayoutMatrixItem(	(void *)mpAntiAliasFontCheckBox, 
																	pholdFontPrefWindowLayoutMatrix->itemsList,
																	KIND_MYCHECKBOX);
///////////////////////////////////////////////
		release_sem(calc_sem);
		pholdFontPrefWindowLayoutMatrix->Calc(MATRIXHORIZONTALOFFSET, MATRIXVERTICALOFFSET, calc_sem);
	}
	catch (...)
	{
		warning(CaughtFontPrefWindowCTOR);
		release_sem(calc_sem);
		throw;
	}
	try 
	{
		BMenuItem *	menuItem;
		BMenu * APPMenu = new BMenu(AppMenuLable);
		menuItem = new BMenuItem(	AboutMenuLable, 
									new BMessage(ABOUT_FONTPREFWINDOW));
		APPMenu->AddItem(menuItem);
		menuItem = new BMenuItem(	CloseWindow, 
									new BMessage(B_QUIT_REQUESTED));
		APPMenu->AddItem(menuItem);
		menuItem = new BMenuItem(	QuitMenuLable, 
									new BMessage(QUIT_APP));
		APPMenu->AddItem(menuItem);
		pMenuBar->AddItem(APPMenu);
		if (myPrefs->bOpenFontDisplay) OpenFontDisplayWindow();
	}
	catch(...) 
	{
		throw;
	}
}//end


//dtor
FontPrefWindow	::	~FontPrefWindow() 
{
	delete[] mpcFullLine;
	if (mpFontDisplayWindow)
	{
		mpFontDisplayWindow->PostMessage(B_QUIT_REQUESTED);
	}
	if (myPrefs->pPrefPanelWindow)//can get a race if not checked
	{
		myPrefs->pPrefPanelWindow->mpFontPrefWindow = NULL;
	}
	if (myPrefs->bPrefChangesMade)
	{
		if (myPrefs->pPrefPanelWindow)
		{
			myPrefs->pPrefPanelWindow->PostMessage(B_QUIT_REQUESTED);
		}
	}
}//end


void
FontPrefWindow	::	MessageReceived(	BMessage * pparamMessage) 
{
	switch(pparamMessage->what) 
	{
		case BIGGER_FONT:
		case SMALLER_FONT:
		{
	       	float oldSize = (myPrefs->GetPreferredFont())->Size();
			if (pparamMessage->what == BIGGER_FONT) 
			{
				oldSize++;
			}
			else
			{
				oldSize--;
			}
			ResetFontSize(oldSize);
		break;
		}
		case FONT_SIZE_STR:
		{
			ResetFontSize(s2f(mpSizeFloatGadget->Text()));
		break;
		}
		case DISPLAY_FONT:
			if (mpDisplayFontCheckBox->Value())
			{
				if (!mpFontDisplayWindow)
				{
					OpenFontDisplayWindow();
				}
			}
			else
			{
				mpFontDisplayWindow->PostMessage(B_QUIT_REQUESTED);
			}
		break;
		case ANTIALIAS_FONT:
			if (mpAntiAliasFontCheckBox->Value())
			{
				myPrefs->bAntiAliasFont = false;
			}
			else
			{
				myPrefs->bAntiAliasFont = true;
			}
			myPrefs->GetPreferredFont()->SetFlags(myPrefs->bAntiAliasFont);
			if (myPrefs->bOpenFontDisplay)
			{
				OpenFontDisplayWindow();
			}
		break;
		case ABOUT_FONTPREFWINDOW:	
		{
			string warn = AboutFontPrefWindowMsg1;
			warn += AboutFontPrefWindowMsg2;
			warn += AboutFontPrefWindowMsg3;
			warn += AboutFontPrefWindowMsg4;
			warn += AboutFontPrefWindowMsg5;
			warn += AboutFontPrefWindowMsg6;
			warning(warn.c_str());
		break;
		}
		case QUIT_APP:
			if (Verify(ReallyQuitApp))
			{
				myApp->PostMessage(B_QUIT_REQUESTED);
			}
		break;
		case BEGUIPUM:
		{
			BFont * currentFont = myPrefs->GetPreferredFont();
			const char * msgString;
			if (pparamMessage->FindString("menuName", &msgString) == B_OK) 
			{
				if (!strcmp(msgString, "fontFamilyPUM"))
				{
					if (pparamMessage->FindString("itemName", &msgString) == B_OK)
					{
						if (strcmp(mffFamilyName, msgString))
						{
							font_family oldFamily;
							font_style oldStyle;
							currentFont->GetFamilyAndStyle(&oldFamily, &oldStyle);
							currentFont->SetFamilyAndStyle(msgString, NULL);
							font_family newFamily;
							font_style newStyle;
							currentFont->GetFamilyAndStyle(&newFamily, &newStyle);
							myPrefs->bPrefChangesMade = true;
							BPopUpMenu * bpum = (BPopUpMenu *)mpFontStylePUM->ItemAt(0)->Submenu();
							int32 numItems = bpum->CountItems();
							for (	int32 j = (numItems - 1);
									j > -1;
									j--) 
							{
								BMenuItem * item = bpum->RemoveItem(j);
								delete item;
							}
							uint32 numStyles = count_font_styles(newFamily);
							bool reStyle = true;
							font_style styleOne;
							for (	uint32 j = 0;
									j < numStyles;
									j++ ) 
							{
								font_style style;
						   		uint32 flags; 
							    if ( get_font_style(newFamily, j, &style, &flags) == B_OK ) 
							    { 
							    	try
							    	{
								    	BMessage * msg = new BMessage(BEGUIPUM);
										msg->AddString("menuName", "fontStylePUM");
										msg->AddString("itemName", style);
										if (j == 0)
										{
											strcpy(styleOne, style);
										}
										if (!strcmp(style, oldStyle))
										{
											reStyle = false;
										}
								    	BMenuItem * item = new BMenuItem(style, msg);
								    	if (!bpum->AddItem(item))
								    	{
								    		warning(NoAdditem);
								    		throw;
								    	}
							    	}
							    	catch (...)
							    	{
							    		warning(failMenu);
							    		throw;
							    	}
							    } 
							}
							if (reStyle)
							{
								strcpy(mfsStyleName, styleOne);
								BPopUpMenu * bpum = (BPopUpMenu *)mpFontStylePUM->ItemAt(0)->Submenu();
								BMenuItem * bmi = bpum->ItemAt(0);
								bmi->SetMarked(true);
								currentFont->SetFamilyAndStyle(NULL, mfsStyleName);
							}
							strcpy(mffFamilyName, newFamily);
						}
					}
				}
				else if (!strcmp(msgString, "fontStylePUM"))
				{
					if (pparamMessage->FindString("itemName", &msgString) == B_OK)
					{
						if (strcmp(mfsStyleName, msgString))
						{
							currentFont->SetFamilyAndStyle(NULL, msgString);
							currentFont->GetFamilyAndStyle(&mffFamilyName, &mfsStyleName);
							myPrefs->bPrefChangesMade = true;
						}
					}
				}
			}
		break;
		}
		default:
			WindowGuts::MessageReceived(pparamMessage);
		break;
	}
	switch(pparamMessage->what) 
	{
		case BIGGER_FONT:
		case SMALLER_FONT:
		case FONT_SIZE_STR:
		case BEGUIPUM:
			if (mpDisplayFontCheckBox->Value())
			{
				OpenFontDisplayWindow();
			}
		break;
	}
}//end


bool
FontPrefWindow	::	QuitRequested(	void) 
{
	BRect frame = Frame();
	myPrefs->SetPreferredFontPrefWindowRect(frame);
	myPrefs->bOpenFontDisplay = mpDisplayFontCheckBox->Value();
	return(WindowGuts::QuitRequested());
}//end


void
FontPrefWindow	::	OpenFontDisplayWindow(	void)
{
	if (mpFontDisplayWindow) 
	{
		int timeOut = 0;
		while (mpFontDisplayWindow && (timeOut < 100)) 
		{
			if (mpFontDisplayWindow->PostMessage(B_QUIT_REQUESTED))
			{
				mpFontDisplayWindow = NULL;
			}
			else
			{
				snooze(TINYSNOOZE);
				timeOut++;
			}
		}
	}
	if (!mpFontDisplayWindow) 
	{
		BView view(BRect(0, 0, 32, 32), NoShowView, B_FOLLOW_NONE, NULL);
		view.SetFont(myPrefs->GetPreferredFont());
		font_height	fontHeight;
		view.GetFontHeight(&fontHeight);
		float heightPref = fontHeight.ascent + fontHeight.descent + fontHeight.leading;
		string sFullLine = "";
		uint32 asciiStart = 48;
		for (	uint32 i = 0;
				i < 10;
				i++)
		{
			sFullLine += (i + asciiStart);
		}
		asciiStart = 65;
		for (	uint32 i = 0;
				i < 26;
				i++)
		{
			sFullLine += (i + asciiStart);
		}
		asciiStart = 97;
		for (	uint32 i = 0;
				i < 26;
				i++)
		{
			sFullLine += (i + asciiStart);
		}
		try 
		{
			mpcFullLine = new char[strlen(sFullLine.c_str()) + 1];
			strcpy(mpcFullLine, sFullLine.c_str());
			BRect holdRect;
			myPrefs->GetPreferredFontDisplayWindowRect(&holdRect);
			mpFontDisplayWindow = new FontDisplayWindow(	holdRect,
															"FontDisplayWindow",
															FontDisplayWindowTitle,
															"FontDisplayWindowFrame",
															mpcFullLine);
			mpFontDisplayWindow->Initialize();
		}
		catch (...) 
		{
			warning(FailFontDisplayWindow);
			throw;
		}
	}
	else
	{
		warning(FontDisplayNotNull);
		myApp->PostMessage(B_QUIT_REQUESTED);
	}
}//end


void
FontPrefWindow	::	ResetFontSize(	float newSize)
{
	myPrefs->bPrefChangesMade = true;
	char fontSizeStr[16];
	if (newSize < 1)
	{
		warning(FailMinFontSize);
		sprintf(fontSizeStr, "%f", myPrefs->GetPreferredFont()->Size());
		mpSizeFloatGadget->SetText(fontSizeStr);
	}
	else if (newSize > 51000)
	{
		warning(FailMaxFontSize);
		sprintf(fontSizeStr, "%f", myPrefs->GetPreferredFont()->Size());
		mpSizeFloatGadget->SetText(fontSizeStr);
	}
	else
	{
		myPrefs->GetPreferredFont()->SetSize(newSize);
		sprintf(fontSizeStr, "%f", myPrefs->GetPreferredFont()->Size());
		mpSizeFloatGadget->SetText(fontSizeStr);
	}
	if (myPrefs->bOpenFontDisplay) 
	{
		if (mpFontDisplayWindow)
		{
			if (mpFontDisplayWindow->LockLooper())
			{
				if (mpFontDisplayWindow->IsHidden())
				{
					do
					{
						mpFontDisplayWindow->Show();
					} while (mpFontDisplayWindow->IsHidden());
				}
				mpFontDisplayWindow->UnlockLooper();
			}
			else
			{
				warning(FailLockLooper);
			}
		}
		else
		{
			OpenFontDisplayWindow();
		}
	}
	else
	{
		if (mpFontDisplayWindow)
		{
			mpFontDisplayWindow->PostMessage(B_QUIT_REQUESTED);
		}
	}
}//end
			
