//uInt32Gadget.cpp

#include "layoutMatrixItem.h"
#include "layoutMatrix.h"
#include "XuInt32Gadget.h"
#include "uInt32Gadget.h"
#include "preferences.h"
#include "myroColour.h"
#include "myPreferences.h"
#include "myApp.h"

UInt32Gadget	::	~UInt32Gadget() 
{
	//left blank
};//end


//ctor
UInt32Gadget	::	UInt32Gadget(	uint32 ui32paramInitValue,
						const char * paramName, 
						const char * paramLabel, 
						uint32 ui32paramMsg, 
						uint32 ui32paramMode, 
						uint32 ui32paramFlags,
						float fparamPixWidth,
						LayoutMatrix * lpparamLayoutMatrix,
						bool bparamMakeFocus) 
		: 	BTextControl(	BRect(0, 0, 32, 32), 
							paramName, 
							paramLabel, 
							NULL, 
							new BMessage(ui32paramMsg), 
							ui32paramMode, 
							ui32paramFlags),
			 bmMakeFocus(	bparamMakeFocus)
{
	lpparamLayoutMatrix->AddToChildren(this);
	SetFont(myPrefs->GetPreferredFont());
	char buf[16];
	sprintf(buf, "%u", ui32paramInitValue);
	SetText(buf);
	if (fparamPixWidth)
	{
		mfPixWidth = fparamPixWidth;
	}
	else
	{
		BView bv(BRect(0, 0, 32, 32), NoShowView, B_FOLLOW_NONE, NULL);
		bv.SetFont(myPrefs->GetPreferredFont());
		mfPixWidth = bv.StringWidth(paramLabel);
	}
}//end


void 
UInt32Gadget	::	AttachedToWindow(	void)
{
	SetDrawingMode(B_OP_ADD);
	BTextControl	::	AttachedToWindow();
	rgb_color tempRgbColor;
	myPrefs->GetPreferredUInt32GadgetHighColor(&tempRgbColor);
	SetHighColor(tempRgbColor);
	myPrefs->GetPreferredUInt32GadgetLowColor(&tempRgbColor);
	SetLowColor(tempRgbColor);
	myPrefs->GetPreferredUInt32GadgetViewColor(&tempRgbColor);
	SetViewColor(tempRgbColor);
	if (bmMakeFocus) 
	{
		MakeFocus();
	}
}//end
