//scrollView.cpp

#include "XscrollView.h"
#include "scrollView.h"
#include "textItem.h"
#include "myStringDrawer.h"
#include "layoutMatrix.h"
#include "preferences.h"
#include "myroColour.h"
#include "myPreferences.h"
#include "myApp.h"

ScrollView	::	ScrollView(	BRect area) 
			: 	BView(	area, 
						"target", 
						B_FOLLOW_ALL, 
						B_WILL_DRAW | B_FULL_UPDATE_ON_RESIZE),
				pmTextItemList(new BList()),
				pmStringViewList(new BList())
{
	//left blank
}//end


ScrollView	::	~ScrollView() 
{
	delete pmTextItemList;
	int32 numStringViewListItems = pmStringViewList->CountItems();
	for (	int32 i = 0;
			i < numStringViewListItems;
			i++)
	{
		MyStringDrawer * holpMyStringDrawer = (MyStringDrawer *)pmStringViewList->ItemAt(i);
		delete holpMyStringDrawer;
	}
	delete pmStringViewList;
}//end


void 
ScrollView	::	AttachedToWindow() 
{
	BView::AttachedToWindow();
	rgb_color tempRgbColor;
	myPrefs->GetPreferredHighColor(&tempRgbColor);
	SetHighColor(tempRgbColor);
	myPrefs->GetPreferredLowColor(&tempRgbColor);
	SetLowColor(tempRgbColor);
	myPrefs->GetPreferredViewColor(&tempRgbColor);
	SetViewColor(tempRgbColor);
}//end


void 
ScrollView	::	Draw(	BRect rect) 
{
	BView::Draw(rect);
	FillRect(Bounds());
	//need to learn how to DoForEach(), need to understand pointers to functions
	rgb_color originalHighColor(HighColor());
	rgb_color originalLowColor(LowColor());
	rgb_color originalViewColor(ViewColor());
	rgb_color newColor;
	myPrefs->GetPreferredMyStringDrawerHighColor(&newColor);
	SetHighColor(newColor);
	myPrefs->GetPreferredMyStringDrawerLowColor(&newColor);
	SetLowColor(newColor);
	myPrefs->GetPreferredMyStringDrawerViewColor(&newColor);
	SetViewColor(newColor);
	int32 numItems = pmTextItemList->CountItems();
	for (	uint32 i = 0;
			i < numItems;
			i++)
	{
		TextItem * textItem = (TextItem *)pmTextItemList->ItemAt(i);
		MovePenTo(textItem->left, textItem->top);
		DrawString(textItem->text);
	}
	numItems = pmStringViewList->CountItems();
	if (numItems)
	{
		for (	uint32 i = 0;
				i < numItems;
				i++)
		{
			MyStringDrawer * myStringDrawer = (MyStringDrawer *)pmStringViewList->ItemAt(i);
			TextItem * textItem = myStringDrawer->GetTextItem();
			SetFont(myStringDrawer->GetFont());
			MovePenTo(textItem->left, textItem->top);
			DrawString(textItem->text);
		}
	}
	SetHighColor(originalHighColor);
	SetLowColor(originalLowColor);
	SetViewColor(originalViewColor);
}//end