//myTextView.cpp

#include "layoutMatrixItem.h"
#include "layoutMatrix.h"
#include "preferences.h"
#include "myroColour.h"
#include "myPreferences.h"
#include "myApp.h"
#include "XmyTextView.h"
#include "myTextView.h"
#include "layoutMatrix.h"


MyTextView	::	~MyTextView() 
{
	//left blank
};//end


//ctor
MyTextView	::	MyTextView(	const char * paramName, 
							const char * paramText,
							float fparamMaxWidth,
							float fparamMaxHeight,
							LayoutMatrix * lpparamLayoutMatrix) 
				: 
					BTextView(	BRect(0,0,fparamMaxWidth,fparamMaxHeight), 
								paramName, 
								BRect(1,1,fparamMaxWidth + 1,fparamMaxWidth + 1), 
								B_FOLLOW_NONE, 
								B_WILL_DRAW),
					fmWidth(	fparamMaxWidth),
					fmHeight(	fparamMaxHeight)
{
	lpparamLayoutMatrix->AddToChildren((void *)this);
	SetText(paramText);
	MakeResizable(false);
	rgb_color tempRgbColor;
	myPrefs->GetPreferredMyTextViewHighColor(&tempRgbColor);
	SetFontAndColor(myPrefs->GetPreferredFont(), B_FONT_ALL, &tempRgbColor);
}//end


void 
MyTextView	::	AttachedToWindow() 
{
	BTextView::AttachedToWindow();
	rgb_color tempRgbColor;
	myPrefs->GetPreferredMyTextViewViewColor(&tempRgbColor);
	SetViewColor(tempRgbColor);
	myPrefs->GetPreferredMyTextViewHighColor(&tempRgbColor);
	SetHighColor(tempRgbColor);
	myPrefs->GetPreferredMyTextViewLowColor(&tempRgbColor);
	SetLowColor(tempRgbColor);
}//end


void
MyTextView	::	MyGetPreferredSize(	float * fpparamWidth,
									float * fpparamHeight)
{
	*fpparamHeight = fmHeight;
	*fpparamWidth = fmWidth;
}//end