//myPopUpMenu

#include <memory>
#include "layoutMatrixItem.h"
#include "layoutMatrix.h"
#include "XmyPopUpMenu.h"
#include "myPopUpMenu.h"
#include "Xwarning.h"
#include "preferences.h"
#include "myPreferences.h"
#include "myApp.h"
#include "textItem.h"

MyPopUpMenu	::	~MyPopUpMenu() 
{
	delete mpMenuName;
	//pmList deleted in Initialize()
};//end


//ctor
MyPopUpMenu	::	MyPopUpMenu(	const char * paramName, 
								const char * paramTitle,
								BList * pparamList,
								bool bparamIsRadioMode,
								TextItem * pparamLabelTextItem,
								LayoutMatrix * lpparamLayoutMatrix) 
			: 
				BMenuBar(	BRect(0, 0, 32, 32), 
							paramName, 
							B_FOLLOW_NONE,
							B_ITEMS_IN_COLUMN),
				pmList(pparamList),
				pmTitle(paramTitle),
				fmWidest(0),
				fmHeight(0),
				bmIsRadioMode(bparamIsRadioMode),
				mpLabelTextItem(pparamLabelTextItem)
{
	mpMenuName = (char *)malloc(strlen(paramName) + 1);
	if (mpMenuName) 
	{
		strcpy(mpMenuName, paramName);
		lpparamLayoutMatrix->AddToChildren((void *)this);
	}
	else
	{
		warning(FailMemory);
	}
}//end


//do all the real work of construction so we can Fail gracefully
bool 
MyPopUpMenu	::	Initialize(	void) 
{
	//sanity check:
	if (!pmList)
	{
		warning(FailPUMInit);
		return false;
	}
	int32 numItems = pmList->CountItems();
	if (!numItems) return true;
	try
	{
		BPopUpMenu * bpum = new BPopUpMenu(pmTitle);
		AddItem(bpum);
		bpum->SetRadioMode(bmIsRadioMode);
		BList * pMenuItemList = new BList(/*numItems*/);
		for (	uint32 i = 0;
				i < numItems;
				i++)
		{
			PopUpMenuData * pumd = (PopUpMenuData *)pmList->ItemAt(i);
			BMessage * msg = new BMessage(BEGUIPUM);
			status_t success = msg->AddString("menuName", mpMenuName);
			if (success != B_OK) 
			{
				warning(BMsgAddXfailPUMInit);//debug resource
				throw;
			}
			success = msg->AddString("itemName", pumd->mLabel);
			if (success != B_OK)
			{
				warning(BMsgAddXfailPUMInit);//debug resource
				throw;
			}
			BMenuItem * bmi = new BMenuItem(pumd->mLabel, msg);
			bmi->SetMarked(pumd->mbSetMark);
			bpum->AddItem(bmi);
			pMenuItemList->AddItem((void *)pumd->mLabel);
		}
		menu_info menuInfo;
		get_menu_info(&menuInfo);
		BView view(BRect(0, 0, 32, 32), NoShowView, B_FOLLOW_NONE, NULL);
		BFont font;
		font.SetFamilyAndStyle(menuInfo.f_family, menuInfo.f_style);
		font.SetSize(menuInfo.font_size);
		view.SetFont(&font);
		font_height	fontHeight;
		view.GetFontHeight(&fontHeight);
		float pad = 4;
		float width;
		fmWidest = view.StringWidth(pmTitle);
		fmHeight = fontHeight.ascent + fontHeight.descent + fontHeight.leading + pad;
		for (	uint32 i = 0;
				i < numItems;
				i++)
		{
			const char * text = (const char *)pMenuItemList->ItemAt(i);
			width = view.StringWidth(text);
			if (width > fmWidest) 
			{
				fmWidest = width;
			}
		}
		view.SetFont(myPrefs->GetPreferredFont());
		fmLabelWidth = view.StringWidth(GetTextItem()->text);
	}
	catch (...)
	{
		for (	uint32 i = 0;
				i < numItems;
				i++)
		{
			PopUpMenuData * pumd = (PopUpMenuData *)pmList->ItemAt(i);
			delete pumd;
		}
		delete pmList;
		warning(FailMemory);
		throw;
	}
	for (	uint32 i = 0;
			i < numItems;
			i++)
	{
		PopUpMenuData * pumd = (PopUpMenuData *)pmList->ItemAt(i);
		delete pumd;
	}
	delete pmList;
	return true;
}//end


void
MyPopUpMenu	::	MyGetPreferredSize(	float * fpparamWidth,
									float * fpparamHeight)
{
	*fpparamWidth = fmWidest;
	*fpparamHeight = fmHeight;
}//end


TextItem *
MyPopUpMenu	::	GetTextItem(void) const
{
	return mpLabelTextItem;
}//end


void
MyPopUpMenu	::	SetTop(	const float fparamTop)
{
	top = fparamTop;
}//end


float
MyPopUpMenu	::	GetTop(	void) const
{
	return top;
}//end


void
MyPopUpMenu	::	SetLeft(	const float fparamLeft)
{
	left = fparamLeft;
}//end


float
MyPopUpMenu	::	GetLeft(	void) const
{
	return left;
}//end


PopUpMenuData	::	PopUpMenuData(	const char * paramLabel,
									BList * lpparamList,
									bool bparamSetMark)
				:	mbSetMark(bparamSetMark)
{
	mLabel = (char *)malloc(strlen(paramLabel) + 1);
	if (mLabel) 
	{
		strcpy(mLabel, paramLabel);
		lpparamList->AddItem((void *)this);
	}
	else
	{
		warning(FailMemory);
	}
}//end


PopUpMenuData	::	~PopUpMenuData()
{
	delete mLabel;
}//end