//EditConstants function of OpeningWindow soi0.1

#include "windowGuts.h"
#include "warning.h"
#include "XfileStr.h"
#include "XwarnStr.h"
#include "error.h"
#include "s2uint32.h"
#include "things.h"
#include "aXGlobal.h"
#include "dataNode.h"
#include "intGadget.h"
#include "dataList.h"
#include "bottomLine.h"
#include "myButton.h"
#include "bottomButtons.h"
#include "stringGadget.h"
#include "unique.h"
#include "textItem.h"
#include "myStringDrawer.h"
#include "constants.h"
#include "universalConstants.h"
#include "editUniversalConstantsWindow.h"
#include "designButtons.h"
#include "editUniverseWindow.h"
#include <memory>
#include "def.h"

void EditUniverseWindow::EditConstants(void) {

int32 wrx = 4, wry = 22, wrw = 636, wrh = 350;

BRect editWindowRect(wrx, wry, wrw, wrh);
EditUniversalConstantsWindow * editUniversalConstantsWindow;
try {
	editUniversalConstantsWindow = new EditUniversalConstantsWindow(editWindowRect, editThe[UNIVERSALCONSTANTS_TYPE]);
}
catch (...) {
	warning(failEditWindow);
	return;
}
editUniversalConstantsWindow->Lock();

int32 top = 2;
int32 left = 2;
int32 width = 278;
int32 hgap = 128;//width for Horizontal spacing
int32 height = 18;
int32 vgap = 23;//height + Vertical spacing
int32 perStrStart = 410;
int32 perStrEnd = 660;
int32 perStrOffset = 2;
float divider = 184.0;

BRect enteredMinWidthRect(left, top, width, top + height);
char enteredMinWidthStr[UINTSTRLEN];
SPRTF(enteredMinWidthStr, "%u", universalConstants->enteredMinWidth);
try {
	auto_ptr<BMessage> msg(new BMessage(MINWIDTHUNIVERSE));
	editUniversalConstantsWindow->enteredMinWidthGadget = new IntGadget(enteredMinWidthRect, wGadgetStr, univWidthStr, enteredMinWidthStr, msg.get(), B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
	msg.release();
}
catch (...) {
	warning(failIntGadget);
	goto bad;
}
editUniversalConstantsWindow->enteredMinWidthGadget->SetAlignment(B_ALIGN_RIGHT, B_ALIGN_LEFT);
editUniversalConstantsWindow->enteredMinWidthGadget->SetDivider(divider);
editUniversalConstantsWindow->AddChild(editUniversalConstantsWindow->enteredMinWidthGadget);


BRect enteredMaxWidthRect(left + hgap, top, width + hgap, top + height);
char enteredMaxWidthStr[UINTSTRLEN];
SPRTF(enteredMaxWidthStr, "%u", universalConstants->enteredMaxWidth);
try {
	auto_ptr<BMessage> msg(new BMessage(MAXWIDTHUNIVERSE));
	editUniversalConstantsWindow->enteredMaxWidthGadget = new IntGadget(enteredMaxWidthRect, wGadgetStr, maxStr, enteredMaxWidthStr, msg.get(), B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
	msg.release();
}
catch (...) {
	warning(failIntGadget);
	goto bad;
}
editUniversalConstantsWindow->enteredMaxWidthGadget->SetAlignment(B_ALIGN_RIGHT, B_ALIGN_LEFT);
editUniversalConstantsWindow->enteredMaxWidthGadget->SetDivider(divider);
editUniversalConstantsWindow->AddChild(editUniversalConstantsWindow->enteredMaxWidthGadget);

top += vgap;

BRect enteredMinHeightRect(left, top, width, top + height);
char enteredMinHeightStr[UINTSTRLEN];
SPRTF(enteredMinHeightStr, "%u", universalConstants->enteredMinHeight);
try {
	auto_ptr<BMessage> msg(new BMessage(MINHEIGHTUNIVERSE));
	editUniversalConstantsWindow->enteredMinHeightGadget = new IntGadget(enteredMinHeightRect, hGadgetStr, univHeightStr, enteredMinHeightStr, msg.get(), B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
	msg.release();
}
catch (...) {
	warning(failIntGadget);
	goto bad;
}
editUniversalConstantsWindow->enteredMinHeightGadget->SetAlignment(B_ALIGN_RIGHT, B_ALIGN_LEFT);
editUniversalConstantsWindow->enteredMinHeightGadget->SetDivider(divider);
editUniversalConstantsWindow->AddChild(editUniversalConstantsWindow->enteredMinHeightGadget);

BRect enteredMaxHeightRect(left + hgap, top, width + hgap, top + height);
char enteredMaxHeightStr[UINTSTRLEN];
SPRTF(enteredMaxHeightStr, "%u", universalConstants->enteredMaxHeight);
try {
	auto_ptr<BMessage> msg(new BMessage(MAXHEIGHTUNIVERSE));
	editUniversalConstantsWindow->enteredMaxHeightGadget = new IntGadget(enteredMaxHeightRect, hGadgetStr, maxStr, enteredMaxHeightStr, msg.get(), B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
	msg.release();
}
catch (...) {
	warning(failIntGadget);
	goto bad;
}
editUniversalConstantsWindow->enteredMaxHeightGadget->SetAlignment(B_ALIGN_RIGHT, B_ALIGN_LEFT);
editUniversalConstantsWindow->enteredMaxHeightGadget->SetDivider(divider);
editUniversalConstantsWindow->AddChild(editUniversalConstantsWindow->enteredMaxHeightGadget);

top += vgap;

BRect enteredMinDepthRect(left, top, width, top + height);
char enteredMinDepthStr[UINTSTRLEN];
SPRTF(enteredMinDepthStr, "%u", universalConstants->enteredMaxDepth);
try {
	auto_ptr<BMessage> msg(new BMessage(MINDEPTHUNIVERSE));
	editUniversalConstantsWindow->enteredMinDepthGadget = new IntGadget(enteredMinDepthRect, dGadgetStr, univDepthStr, enteredMinDepthStr, msg.get(), B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
	msg.release();
}
catch (...) {
	warning(failIntGadget);
	goto bad;
}
editUniversalConstantsWindow->enteredMinDepthGadget->SetAlignment(B_ALIGN_RIGHT, B_ALIGN_LEFT);
editUniversalConstantsWindow->enteredMinDepthGadget->SetDivider(divider);
editUniversalConstantsWindow->AddChild(editUniversalConstantsWindow->enteredMinDepthGadget);

BRect enteredMaxDepthRect(left + hgap, top, width + hgap, top + height);
char enteredMaxDepthStr[UINTSTRLEN];
SPRTF(enteredMaxDepthStr, "%u", universalConstants->enteredMaxDepth);
try {
	auto_ptr<BMessage> msg(new BMessage(MAXDEPTHUNIVERSE));
	editUniversalConstantsWindow->enteredMaxDepthGadget = new IntGadget(enteredMaxDepthRect, dGadgetStr, maxStr, enteredMaxDepthStr, msg.get(), B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
	msg.release();
}
catch (...) {
	warning(failIntGadget);
	goto bad;
}
editUniversalConstantsWindow->enteredMaxDepthGadget->SetAlignment(B_ALIGN_RIGHT, B_ALIGN_LEFT);
editUniversalConstantsWindow->enteredMaxDepthGadget->SetDivider(divider);
editUniversalConstantsWindow->AddChild(editUniversalConstantsWindow->enteredMaxDepthGadget);

top += vgap;

BRect enteredMinSpeedOfLightRect(left, top, width, top + height);
char enteredMinSpeedOfLightStr[UINTSTRLEN];
SPRTF(enteredMinSpeedOfLightStr, "%u", universalConstants->enteredMinSpeedOfLight);
try {
	auto_ptr<BMessage> msg(new BMessage(MINSOLUNIVERSE));
	editUniversalConstantsWindow->enteredMinSpeedOfLightGadget = new IntGadget(enteredMinSpeedOfLightRect, solGadgetStr, univSolStr, enteredMinSpeedOfLightStr, msg.get(), B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
	msg.release();
}
catch (...) {
	warning(failIntGadget);
	goto bad;
}
editUniversalConstantsWindow->enteredMinSpeedOfLightGadget->SetAlignment(B_ALIGN_RIGHT, B_ALIGN_LEFT);
editUniversalConstantsWindow->enteredMinSpeedOfLightGadget->SetDivider(divider);
editUniversalConstantsWindow->AddChild(editUniversalConstantsWindow->enteredMinSpeedOfLightGadget);

BRect enteredMaxSpeedOfLightRect(left + hgap, top, width + hgap, top + height);
char enteredMaxSpeedOfLightStr[UINTSTRLEN];
SPRTF(enteredMaxSpeedOfLightStr, "%u", universalConstants->enteredMaxSpeedOfLight);
try {
	auto_ptr<BMessage> msg(new BMessage(MAXSOLUNIVERSE));
	editUniversalConstantsWindow->enteredMaxSpeedOfLightGadget = new IntGadget(enteredMaxSpeedOfLightRect, solGadgetStr, maxStr, enteredMaxSpeedOfLightStr, msg.get(), B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
	msg.release();
}
catch (...) {
	warning(failIntGadget);
	goto bad;
}
editUniversalConstantsWindow->enteredMaxSpeedOfLightGadget->SetAlignment(B_ALIGN_RIGHT, B_ALIGN_LEFT);
editUniversalConstantsWindow->enteredMaxSpeedOfLightGadget->SetDivider(divider);
editUniversalConstantsWindow->AddChild(editUniversalConstantsWindow->enteredMaxSpeedOfLightGadget);

top += vgap;

BRect enteredMinPropulsionFuelConsRect(left, top, width, top + height);
char enteredMinPropulsionFuelStr[UINTSTRLEN];
SPRTF(enteredMinPropulsionFuelStr, "%u", universalConstants->enteredMinPropulsionFuelCons);
try {
	auto_ptr<BMessage> msg(new BMessage(MINPFCUNIVERSE));
	editUniversalConstantsWindow->enteredMinPropulsionFuelConsGadget = new IntGadget(enteredMinPropulsionFuelConsRect, univPfcGadgetStr, propFUStr, enteredMinPropulsionFuelStr, msg.get(), B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
	msg.release();
}
catch (...) {
	warning(failIntGadget);
	goto bad;
}
editUniversalConstantsWindow->enteredMinPropulsionFuelConsGadget->SetAlignment(B_ALIGN_RIGHT, B_ALIGN_LEFT);
editUniversalConstantsWindow->enteredMinPropulsionFuelConsGadget->SetDivider(divider);
editUniversalConstantsWindow->AddChild(editUniversalConstantsWindow->enteredMinPropulsionFuelConsGadget);

try {
	editUniversalConstantsWindow->enteredMinPropulsionFuelStr = new MyStringDrawer(BRect(perStrStart, top - perStrOffset, perStrEnd, top + 20));
}
catch (...) {
	warning(failMyStringDrawer);
	goto bad;
}
if (!editUniversalConstantsWindow->enteredMinPropulsionFuelStr->SetText(fuelUsedPerStr)) goto bad;
editUniversalConstantsWindow->AddChild(editUniversalConstantsWindow->enteredMinPropulsionFuelStr);

BRect enteredMaxPropulsionFuelConsRect(left + hgap, top, width + hgap, top + height);
char enteredMaxPropulsionFuelStr[UINTSTRLEN];
SPRTF(enteredMaxPropulsionFuelStr, "%u", universalConstants->enteredMaxPropulsionFuelCons);
try {
	auto_ptr<BMessage> msg(new BMessage(MAXPFCUNIVERSE));
	editUniversalConstantsWindow->enteredMaxPropulsionFuelConsGadget = new IntGadget(enteredMaxPropulsionFuelConsRect, univPfcGadgetStr, maxStr, enteredMaxPropulsionFuelStr, msg.get(), B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
	msg.release();
}
catch (...) {
	warning(failIntGadget);
	goto bad;
}
editUniversalConstantsWindow->enteredMaxPropulsionFuelConsGadget->SetAlignment(B_ALIGN_RIGHT, B_ALIGN_LEFT);
editUniversalConstantsWindow->enteredMaxPropulsionFuelConsGadget->SetDivider(divider);
editUniversalConstantsWindow->AddChild(editUniversalConstantsWindow->enteredMaxPropulsionFuelConsGadget);

top += vgap;

BRect enteredMinPropulsionAccelRect(left, top, width, top + height);
char enteredMinPropulsionAccelStr[UINTSTRLEN];
SPRTF(enteredMinPropulsionAccelStr, "%u", universalConstants->enteredMinPropulsionAccel);
try {
	auto_ptr<BMessage> msg(new BMessage(MINPROPACCELUNIVERSALCONSTANTS));
	editUniversalConstantsWindow->enteredMinPropulsionAccelGadget = new IntGadget(enteredMinPropulsionAccelRect, univPfcaGadgetStr, propaFUStr, enteredMinPropulsionAccelStr, msg.get(), B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
	msg.release();
}
catch (...) {
	warning(failIntGadget);
	goto bad;
}
editUniversalConstantsWindow->enteredMinPropulsionAccelGadget->SetAlignment(B_ALIGN_RIGHT, B_ALIGN_LEFT);
editUniversalConstantsWindow->enteredMinPropulsionAccelGadget->SetDivider(divider);
editUniversalConstantsWindow->AddChild(editUniversalConstantsWindow->enteredMinPropulsionAccelGadget);

try {
	editUniversalConstantsWindow->enteredMinPropulsionAccelStr = new MyStringDrawer(BRect(perStrStart, top - perStrOffset, perStrEnd, top + 20));
}
catch (...) {
	warning(failMyStringDrawer);
	goto bad;
}
if (!editUniversalConstantsWindow->enteredMinPropulsionAccelStr->SetText(fuelAPerStr)) goto bad;
editUniversalConstantsWindow->AddChild(editUniversalConstantsWindow->enteredMinPropulsionAccelStr);

BRect enteredMaxPropulsionAccelRect(left + hgap, top, width + hgap, top + height);
char enteredMaxPropulsionAccelStr[UINTSTRLEN];
SPRTF(enteredMaxPropulsionAccelStr, "%u", universalConstants->enteredMaxPropulsionAccel);
try {
	auto_ptr<BMessage> msg(new BMessage(MAXPROPACCELUNIVERSALCONSTANTS));
	editUniversalConstantsWindow->enteredMaxPropulsionAccelGadget = new IntGadget(enteredMaxPropulsionAccelRect, univPfcaGadgetStr, maxStr, enteredMaxPropulsionAccelStr, msg.get(), B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
	msg.release();
}
catch (...) {
	warning(failIntGadget);
	goto bad;
}
editUniversalConstantsWindow->enteredMaxPropulsionAccelGadget->SetAlignment(B_ALIGN_RIGHT, B_ALIGN_LEFT);
editUniversalConstantsWindow->enteredMaxPropulsionAccelGadget->SetDivider(divider);
editUniversalConstantsWindow->AddChild(editUniversalConstantsWindow->enteredMaxPropulsionAccelGadget);

top += vgap;

BRect enteredMinFtlFuelConsRect(left, top, width, top + height);
char enteredMinFtlFuelStr[UINTSTRLEN];
SPRTF(enteredMinFtlFuelStr, "%u", universalConstants->enteredMinFtlFuelCons);
try {
	auto_ptr<BMessage> msg(new BMessage(MINFFCUNIVERSE));
	editUniversalConstantsWindow->enteredMinFtlFuelConsGadget = new IntGadget(enteredMinFtlFuelConsRect, univFfcGadgetStr, ftlFUStr, enteredMinFtlFuelStr, msg.get(), B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
	msg.release();
}
catch (...) {
	warning(failIntGadget);
	goto bad;
}
editUniversalConstantsWindow->enteredMinFtlFuelConsGadget->SetAlignment(B_ALIGN_RIGHT, B_ALIGN_LEFT);
editUniversalConstantsWindow->enteredMinFtlFuelConsGadget->SetDivider(divider);
editUniversalConstantsWindow->AddChild(editUniversalConstantsWindow->enteredMinFtlFuelConsGadget);

try {
	editUniversalConstantsWindow->enteredMinFtlFuelStr = new MyStringDrawer(BRect(perStrStart, top - perStrOffset, perStrEnd, top + 20));
}
catch (...) {
	warning(failMyStringDrawer);
	goto bad;
}
if (!editUniversalConstantsWindow->enteredMinFtlFuelStr->SetText(fuelUsedPerStr)) goto bad;
editUniversalConstantsWindow->AddChild(editUniversalConstantsWindow->enteredMinFtlFuelStr);

BRect enteredMaxFtlFuelConsRect(left + hgap, top, width + hgap, top + height);
char enteredMaxFtlFuelStr[UINTSTRLEN];
SPRTF(enteredMaxFtlFuelStr, "%u", universalConstants->enteredMaxFtlFuelCons);
try {
	auto_ptr<BMessage> msg(new BMessage(MAXFFCUNIVERSE));
	editUniversalConstantsWindow->enteredMaxFtlFuelConsGadget = new IntGadget(enteredMaxFtlFuelConsRect, univFfcGadgetStr, maxStr, enteredMaxFtlFuelStr, msg.get(), B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
	msg.release();
}
catch (...) {
	warning(failIntGadget);
	goto bad;
}
editUniversalConstantsWindow->enteredMaxFtlFuelConsGadget->SetAlignment(B_ALIGN_RIGHT, B_ALIGN_LEFT);
editUniversalConstantsWindow->enteredMaxFtlFuelConsGadget->SetDivider(divider);
editUniversalConstantsWindow->AddChild(editUniversalConstantsWindow->enteredMaxFtlFuelConsGadget);

top += vgap;

BRect enteredMinFtlAccelRect(left, top, width, top + height);
char enteredMinFtlAccelStr[UINTSTRLEN];
SPRTF(enteredMinFtlAccelStr, "%u", universalConstants->enteredMinFtlAccel);
try {
	auto_ptr<BMessage> msg(new BMessage());
	editUniversalConstantsWindow->enteredMinFtlAccelGadget = new IntGadget(enteredMinFtlAccelRect, univFfcaGadgetStr, ftlaFUStr, enteredMinFtlAccelStr, msg.get(), B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
	msg.release();
}
catch (...) {
	warning(failIntGadget);
	goto bad;
}
editUniversalConstantsWindow->enteredMinFtlAccelGadget->SetAlignment(B_ALIGN_RIGHT, B_ALIGN_LEFT);
editUniversalConstantsWindow->enteredMinFtlAccelGadget->SetDivider(divider);
editUniversalConstantsWindow->AddChild(editUniversalConstantsWindow->enteredMinFtlAccelGadget);

try {
	editUniversalConstantsWindow->enteredMinFtlAccelStr = new MyStringDrawer(BRect(perStrStart, top - perStrOffset, perStrEnd, top + 20));
}
catch (...) {
	warning(failMyStringDrawer);
	goto bad;
}
if (!editUniversalConstantsWindow->enteredMinFtlAccelStr->SetText(ftlAStr)) goto bad;
editUniversalConstantsWindow->AddChild(editUniversalConstantsWindow->enteredMinFtlAccelStr);

BRect enteredMaxFtlAccelRect(left + hgap, top, width + hgap, top + height);
char enteredMaxFtlAccelStr[UINTSTRLEN];
SPRTF(enteredMaxFtlAccelStr, "%u", universalConstants->enteredMaxFtlAccel);
try {
	auto_ptr<BMessage> msg(new BMessage(MAXFTLACCELUNIVERSALCONSTANTS));
	editUniversalConstantsWindow->enteredMaxFtlAccelGadget = new IntGadget(enteredMaxFtlAccelRect, univFfcaGadgetStr, maxStr, enteredMaxFtlAccelStr, msg.get(), B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
	msg.release();
}
catch (...) {
	warning(failIntGadget);
	goto bad;
}
editUniversalConstantsWindow->enteredMaxFtlAccelGadget->SetAlignment(B_ALIGN_RIGHT, B_ALIGN_LEFT);
editUniversalConstantsWindow->enteredMaxFtlAccelGadget->SetDivider(divider);
editUniversalConstantsWindow->AddChild(editUniversalConstantsWindow->enteredMaxFtlAccelGadget);

top += vgap;

BRect enteredMinInstantaneousFuelConsRect(left, top, width, top + height);
char enteredMinInstantaneousFuelStr[UINTSTRLEN];
SPRTF(enteredMinInstantaneousFuelStr, "%u", universalConstants->enteredMinInstantaneousFuelCons);
try {
	auto_ptr<BMessage> msg(new BMessage(MINIFCUNIVERSE));
	editUniversalConstantsWindow->enteredMinInstantaneousFuelConsGadget = new IntGadget(enteredMinInstantaneousFuelConsRect, univIftGadgetStr, instFUStr, enteredMinInstantaneousFuelStr, msg.get(), B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
	msg.release();
}
catch (...) {
	warning(failIntGadget);
	goto bad;
}
editUniversalConstantsWindow->enteredMinInstantaneousFuelConsGadget->SetAlignment(B_ALIGN_RIGHT, B_ALIGN_LEFT);
editUniversalConstantsWindow->enteredMinInstantaneousFuelConsGadget->SetDivider(divider);
editUniversalConstantsWindow->AddChild(editUniversalConstantsWindow->enteredMinInstantaneousFuelConsGadget);

try {
	editUniversalConstantsWindow->enteredMinInstantaneousFuelStr = new MyStringDrawer(BRect(perStrStart, top - perStrOffset, perStrEnd, top + 20));
}
catch (...) {
	warning(failMyStringDrawer);
	goto bad;
}
if (!editUniversalConstantsWindow->enteredMinInstantaneousFuelStr->SetText(fuelUsedPerStr)) goto bad;
editUniversalConstantsWindow->AddChild(editUniversalConstantsWindow->enteredMinInstantaneousFuelStr);

BRect enteredMaxInstantaneousFuelConsRect(left + hgap, top, width + hgap, top + height);
char enteredMaxInstantaneousFuelStr[UINTSTRLEN];
SPRTF(enteredMaxInstantaneousFuelStr, "%u", universalConstants->enteredMaxInstantaneousFuelCons);
try {
	auto_ptr<BMessage> msg(new BMessage(MAXIFCUNIVERSE));
	editUniversalConstantsWindow->enteredMaxInstantaneousFuelConsGadget = new IntGadget(enteredMaxInstantaneousFuelConsRect, univIftGadgetStr, maxStr, enteredMaxInstantaneousFuelStr, msg.get(), B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
	msg.release();
}
catch (...) {
	warning(failIntGadget);
	goto bad;
}
editUniversalConstantsWindow->enteredMaxInstantaneousFuelConsGadget->SetAlignment(B_ALIGN_RIGHT, B_ALIGN_LEFT);
editUniversalConstantsWindow->enteredMaxInstantaneousFuelConsGadget->SetDivider(divider);
editUniversalConstantsWindow->AddChild(editUniversalConstantsWindow->enteredMaxInstantaneousFuelConsGadget);

top += vgap;

BRect enteredMinElectronMassRect(left, top, width, top + height);
char enteredMinElectronMassStr[UINTSTRLEN];
SPRTF(enteredMinElectronMassStr, "%u", universalConstants->enteredMinElectronMass);
try {
	auto_ptr<BMessage> msg(new BMessage(MINEUNIVERSE));
	editUniversalConstantsWindow->enteredMinElectronMassGadget = new IntGadget(enteredMinElectronMassRect, eGadgetStr, electronMassStr, enteredMinElectronMassStr, msg.get(), B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
	msg.release();
}
catch (...) {
	warning(failIntGadget);
	goto bad;
}
editUniversalConstantsWindow->enteredMinElectronMassGadget->SetAlignment(B_ALIGN_RIGHT, B_ALIGN_LEFT);
editUniversalConstantsWindow->enteredMinElectronMassGadget->SetDivider(divider);
editUniversalConstantsWindow->AddChild(editUniversalConstantsWindow->enteredMinElectronMassGadget);

BRect enteredMaxElectronMassRect(left + hgap, top, width + hgap, top + height);
char enteredMaxElectronMassStr[UINTSTRLEN];
SPRTF(enteredMaxElectronMassStr, "%u", universalConstants->enteredMaxElectronMass);
try {
	auto_ptr<BMessage> msg(new BMessage(MAXEUNIVERSE));
	editUniversalConstantsWindow->enteredMaxElectronMassGadget = new IntGadget(enteredMaxElectronMassRect, eGadgetStr, maxStr, enteredMaxElectronMassStr, msg.get(), B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
	msg.release();
}
catch (...) {
	warning(failIntGadget);
	goto bad;
}
editUniversalConstantsWindow->enteredMaxElectronMassGadget->SetAlignment(B_ALIGN_RIGHT, B_ALIGN_LEFT);
editUniversalConstantsWindow->enteredMaxElectronMassGadget->SetDivider(divider);
editUniversalConstantsWindow->AddChild(editUniversalConstantsWindow->enteredMaxElectronMassGadget);

top += vgap;

BRect enteredMinNeutronMassRect(left, top, width, top + height);
char enteredMinNeutronMassStr[UINTSTRLEN];
SPRTF(enteredMinNeutronMassStr, "%u", universalConstants->enteredMinNeutronMass);
try {
	auto_ptr<BMessage> msg(new BMessage(MINNUNIVERSE));
	editUniversalConstantsWindow->enteredMinNeutronMassGadget = new IntGadget(enteredMinNeutronMassRect, nGadgetStr, neutronMassStr, enteredMinNeutronMassStr, msg.get(), B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
	msg.release();
}
catch (...) {
	warning(failIntGadget);
	goto bad;
}
editUniversalConstantsWindow->enteredMinNeutronMassGadget->SetAlignment(B_ALIGN_RIGHT, B_ALIGN_LEFT);
editUniversalConstantsWindow->enteredMinNeutronMassGadget->SetDivider(divider);
editUniversalConstantsWindow->AddChild(editUniversalConstantsWindow->enteredMinNeutronMassGadget);

BRect enteredMaxNeutronMassRect(left + hgap, top, width + hgap, top + height);
char enteredMaxNeutronMassStr[UINTSTRLEN];
SPRTF(enteredMaxNeutronMassStr, "%u", universalConstants->enteredMaxNeutronMass);
try {
	auto_ptr<BMessage> msg(new BMessage(MAXNUNIVERSE));
	editUniversalConstantsWindow->enteredMaxNeutronMassGadget = new IntGadget(enteredMaxNeutronMassRect, nGadgetStr, maxStr, enteredMaxNeutronMassStr, msg.get(), B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
	msg.release();
}
catch (...) {
	warning(failIntGadget);
	goto bad;
}
editUniversalConstantsWindow->enteredMaxNeutronMassGadget->SetAlignment(B_ALIGN_RIGHT, B_ALIGN_LEFT);
editUniversalConstantsWindow->enteredMaxNeutronMassGadget->SetDivider(divider);
editUniversalConstantsWindow->AddChild(editUniversalConstantsWindow->enteredMaxNeutronMassGadget);

top += vgap;

BRect enteredMinProtonMassRect(left, top, width, top + height);
char enteredMinProtonMassStr[UINTSTRLEN];
SPRTF(enteredMinProtonMassStr, "%u", universalConstants->enteredMinNeutronMass);
try {
	auto_ptr<BMessage> msg(new BMessage(MINPRUNIVERSE));
	editUniversalConstantsWindow->enteredMinProtonMassGadget = new IntGadget(enteredMinProtonMassRect, cePMassStr, protonMassStr, enteredMinProtonMassStr, msg.get(), B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
	msg.release();
}
catch (...) {
	warning(failIntGadget);
	goto bad;
}
editUniversalConstantsWindow->enteredMinProtonMassGadget->SetAlignment(B_ALIGN_RIGHT, B_ALIGN_LEFT);
editUniversalConstantsWindow->enteredMinProtonMassGadget->SetDivider(divider);
editUniversalConstantsWindow->AddChild(editUniversalConstantsWindow->enteredMinProtonMassGadget);

BRect enteredMaxProtonMassRect(left + hgap, top, width + hgap, top + height);
char enteredMaxProtonMassStr[UINTSTRLEN];
SPRTF(enteredMaxProtonMassStr, "%u", universalConstants->enteredMaxProtonMass);
try {
	auto_ptr<BMessage> msg(new BMessage(MAXPRUNIVERSE));
	editUniversalConstantsWindow->enteredMaxProtonMassGadget = new IntGadget(enteredMaxProtonMassRect, cePMassStr, maxStr, enteredMaxProtonMassStr, msg.get(), B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
	msg.release();
}
catch (...) {
	warning(failIntGadget);
	goto bad;
}
editUniversalConstantsWindow->enteredMaxProtonMassGadget->SetAlignment(B_ALIGN_RIGHT, B_ALIGN_LEFT);
editUniversalConstantsWindow->enteredMaxProtonMassGadget->SetDivider(divider);
editUniversalConstantsWindow->AddChild(editUniversalConstantsWindow->enteredMaxProtonMassGadget);

top += vgap;

BRect enteredMinNumGalaxiesRect(left, top, width, top + height);
char enteredMinNumGalaxiesStr[UINTSTRLEN];
SPRTF(enteredMinNumGalaxiesStr, "%u", universalConstants->enteredMinNumGalaxies);
try {
	auto_ptr<BMessage> msg(new BMessage(MINNGUNIVERSE));
	editUniversalConstantsWindow->enteredMinNumGalaxiesGadget = new IntGadget(enteredMinNumGalaxiesRect, ceNGStr, numGalaxiesStr, enteredMinNumGalaxiesStr, msg.get(), B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
	msg.release();
}
catch (...) {
	warning(failIntGadget);
	goto bad;
}
editUniversalConstantsWindow->enteredMinNumGalaxiesGadget->SetAlignment(B_ALIGN_RIGHT, B_ALIGN_LEFT);
editUniversalConstantsWindow->enteredMinNumGalaxiesGadget->SetDivider(divider);
editUniversalConstantsWindow->AddChild(editUniversalConstantsWindow->enteredMinNumGalaxiesGadget);

BRect enteredMaxNumGalaxiesRect(left + hgap, top, width + hgap, top + height);
char enteredMaxNumGalaxiesStr[UINTSTRLEN];
SPRTF(enteredMaxNumGalaxiesStr, "%u", universalConstants->enteredMaxNumGalaxies);
try {
	auto_ptr<BMessage> msg(new BMessage(MAXNGUNIVERSE));
	editUniversalConstantsWindow->enteredMaxNumGalaxiesGadget = new IntGadget(enteredMaxNumGalaxiesRect, ceNGStr, maxStr, enteredMaxNumGalaxiesStr, msg.get(), B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
	msg.release();
}
catch (...) {
	warning(failIntGadget);
	goto bad;
}
editUniversalConstantsWindow->enteredMaxNumGalaxiesGadget->SetAlignment(B_ALIGN_RIGHT, B_ALIGN_LEFT);
editUniversalConstantsWindow->enteredMaxNumGalaxiesGadget->SetDivider(divider);
editUniversalConstantsWindow->AddChild(editUniversalConstantsWindow->enteredMaxNumGalaxiesGadget);

//BottomLine(UNIVERSALCONSTANTS_TYPE, (EditUniverseWindow * )editUniversalConstantsWindow, editUniversalConstantsWindow->bottom, editUniversalConstantsWindow->bb, BLADD, true);

bad:
editUniversalConstantsWindow->Unlock();
editUniversalConstantsWindow->Show();
}//end