//functions of EditStarWindow soi0.1

#include "windowGuts.h"
#include "editStarWindow.h"
#include "getFromList.h"
#include "saveLoadUniverse.h"
#include "titleWindow.h"
#include "designButtons.h"

void EditStarWindow::SaveRequested(const char * fileName) 
{

SaveStars(fileName);
}//end


EditStarWindow::EditStarWindow(BRect area, const char *title) : BWindow(area, title, B_TITLED_WINDOW, B_NOT_RESIZABLE|B_NOT_ZOOMABLE) 
{

editStarWindow = this;
classMenuBar = NULL;
classPopUpMenu = NULL;
for (int32 i = 0; i < 21; i++) classMenuItems[i] = NULL;

bb = new BottomButtons;
if (bb) 
{
	if (editUniverseWindow) 
	{
		editUniverseWindow->Lock();
		editUniverseWindow->buttons[DSN_STAR]->SetEnabled(false);
		editUniverseWindow->Unlock();
	}
}
else err = CREATEDNOTADDED;
if (!starCurrent) if (dataListGlobal[STAR_TYPE]->list->CountItems()) starCurrent = (Star *)((DataNode *)dataListGlobal[STAR_TYPE]->list->ItemAt(0))->data;
}//end


EditStarWindow::~EditStarWindow() 
{

if (bb) 
{
	if (editUniverseWindow) 
	{
		editUniverseWindow->Lock();
		editUniverseWindow->buttons[DSN_STAR]->SetEnabled(true);
		editUniverseWindow->Unlock();
	}
	delete bb;
}
editStarWindow = NULL;
}//end


void EditStarWindow::AddStar(void) 
{

Star * g = new Star(star, nameStrGadget->Text(), dataListGlobal[STAR_TYPE]);
if (g) 
{
	if (err != CREATED) 
	{
		delete g;
		return;
	}
}
else err = NO_STAR;
}//end


void EditStarWindow::MessageReceived(BMessage *message) 
{

bool validate = true;
if (!strcmp(nameStrGadget->Text(), "")) validate = false;

switch (message->what) 
{
	case SOI_NAME:
	
	break;
	case SOI_STARCLASSMENU:
	case (SOI_STARCLASSMENU + 1):
	case (SOI_STARCLASSMENU + 2):
	case (SOI_STARCLASSMENU + 3):
	case (SOI_STARCLASSMENU + 4):
	case (SOI_STARCLASSMENU + 5):
	case (SOI_STARCLASSMENU + 6):
	case (SOI_STARCLASSMENU + 7):
	case (SOI_STARCLASSMENU + 8):
	case (SOI_STARCLASSMENU + 9):
	case (SOI_STARCLASSMENU + 10):
	case (SOI_STARCLASSMENU + 11):
	case (SOI_STARCLASSMENU + 12):
	case (SOI_STARCLASSMENU + 13):
	case (SOI_STARCLASSMENU + 14):
	case (SOI_STARCLASSMENU + 15):
	case (SOI_STARCLASSMENU + 16):
	case (SOI_STARCLASSMENU + 17):
	case (SOI_STARCLASSMENU + 18):
	case (SOI_STARCLASSMENU + 19):
	case (SOI_STARCLASSMENU + 20):
		if (star->starClass) 
		{
			star->starClass->number = message->what;
		}
		else {
			star->starClass = new StarClass(message->what);
			if (!star->starClass) warning(failStarClass);
		}
	break;
	case SOI_BLREMOVE:
		dataListGlobal[STAR_TYPE]->Remove();
		Quit();
	break;
	case SOI_BLLIST:
		GetFromList((void *)editStarWindow, dataListGlobal[STAR_TYPE], nameStrGadget->Text());
	break;
	case SOI_BLLISTGOT:
		if (validate) ValidateStar();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateStar();
			starCurrent = starNewCurrent;
			nameStrGadget->SetText(starCurrent->name);
			thisDNPtr = dataListGlobal[STAR_TYPE]->NextPrevItems((void *)starCurrent, &nextDNPtr, &prevDNPtr, bb);
			if (!bb->gnu) 
			{
				BRect gnuRect(154,bottom, 189,34);
				bb->gnu = new BButton(gnuRect, "", newStr, new BMessage(SOI_BLGNU));
				if (!bb->gnu) 
				{
					warning(failMemory);
					return;
				}
				AddChild(bb->gnu);
				bb->gnu->SetTarget(this);
				bb->add->SetLabel(removeStr);
				bb->add->SetMessage(new BMessage(SOI_BLREMOVE));
			}
		}
	break;
	case SOI_BLPREV:
		Star * prevStar = (Star *)((DataNode *)prevDNPtr)->data;
		if (validate) ValidateStar();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateStar();
			starCurrent = prevStar;
			nameStrGadget->SetText(starCurrent->name);
			thisDNPtr = dataListGlobal[STAR_TYPE]->NextPrevItems((void *)starCurrent, &nextDNPtr, &prevDNPtr, bb);
		}
	break;
	case SOI_BLDONE:
		if (!validate) 
		{
			Quit();
		}
		if (!strcmp(removeStr, bb->add->Label())) 
		{
			ValidateStar();
			if (err == NO_ERR) 
			{
				UpdateStar();
			}
		}
		if (err == NO_ERR) 
		{
			Quit();
		}
	break;
	case SOI_BLGNU:
		if (validate) ValidateStar();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateStar();
			starCurrent = NULL;
			RemoveChild(bb->gnu);
			delete bb->gnu;
			bb->gnu = NULL;
			bb->add->SetLabel(addStr);
			bb->add->SetMessage(new BMessage(SOI_BLADD));
			nameStrGadget->SetText("");
			nameStrGadget->MakeFocus();
		}
	break;
	case SOI_BLADD:
		if (validate) ValidateStar();
		else {
			err = NO_NAME;
			warning(everythingNamed);
		}//for add don't update
		if (err == NO_ERR) 
		{
			AddStar();
			if (err) 
			{
				if (err != CREATEDNOTADDED) 
				{
					Quit();
				}
			}
			else {
				if (editUniverseWindow) 
				{
					editUniverseWindow->Lock();
					editUniverseWindow->buttons[DSN_STAR]->SetLabel(editThe[STAR_TYPE]);
					editUniverseWindow->bb->save->SetEnabled(true);
					editUniverseWindow->Unlock();
				}
				nameStrGadget->SetText("");
				nameStrGadget->MakeFocus();
				bb->save->SetEnabled(true);
				if (openingWindow) 
				{
					openingWindow->Lock();
					openingWindow->universeButton->SetLabel(editThe[UNIVERSE_TYPE]);
					openingWindow->createUniverseButton->SetEnabled(true);
					openingWindow->realUniverseButton->SetEnabled(true);
					openingWindow->Unlock();
				}
			}
		}
	break;
	case SOI_BLSAVE:
		if (validate) ValidateStar();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateStar();
			//RunSavePanel("universe", saveThe[UNIVERSE_TYPE], saveStr, cancelStr);
		}
	break;
	case SOI_BLPIC:
	
	break;
	case SOI_LOADUNIVERSEFROMPANEL:
		LoadStars("universe");//debug
		Quit();
	break;
	case SOI_BLLOAD:
		BMessage * bm = new BMessage(SOI_LOADUNIVERSEFROMPANEL);
		if (bm) break;//debug break;//debug be_app->RunFilePanel(loadThe[UNIVERSE_TYPE], loadStr, cancelStr, false, bm);
		else warning(failMemory);
	break;
	case SOI_BLNEXT:
		Star * nextStar = (Star *)((DataNode *)nextDNPtr)->data;
		if (validate) ValidateStar();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateStar();
			starCurrent = nextStar;
			nameStrGadget->SetText(starCurrent->name);
			thisDNPtr = dataListGlobal[STAR_TYPE]->NextPrevItems((void *)starCurrent, &nextDNPtr, &prevDNPtr, bb);
		}
	break;
	default:
		BWindow::MessageReceived(message);
	break;
}
}//end


bool EditStarWindow::QuitRequested(void) 
{

if (strcmp(nameStrGadget->Text(), "")) 
{
	if (starCurrent) 
	{
		ValidateStar();
		if (err == NO_ERR) 
		{
			UpdateStar();
			if (err == NO_ERR) 
			{
				Quit();
				return(BWindow::QuitRequested());
			}
			else return false;
		}
		else return false;
	}
}
Quit();
return(BWindow::QuitRequested());
}//end


void EditStarWindow::ValidateStar(void) 
{

UniqueName(dataListGlobal[STAR_TYPE], nameStrGadget->Text());
if (NO_UNIQUE == err) 
{
	warning(failNameUnique[STAR_TYPE]);
	return;
}
if (star->name) 
{
	if (strcmp(star->name, nameStrGadget->Text())) 
	{
		free(star->name);
		star->name = (char *)malloc(strlen(nameStrGadget->Text()) + 1);
		if (star->name) strcpy(star->name, nameStrGadget->Text());
		else {
			err = NO_NAME;
			warning(failName);
		}
	}
}
//debug must do object as well
}//end


void EditStarWindow::UpdateStar(void) 
{

err = NO_ERR;
if (starCurrent) 
{
	if (strcmp(starCurrent->name, nameStrGadget->Text())) 
	{
		if (starCurrent->name) free(starCurrent->name);
		starCurrent->name = (char *)malloc(strlen(nameStrGadget->Text()) + 1);
		if (starCurrent->name) strcpy(starCurrent->name, nameStrGadget->Text());
		else {
			err = NO_NAME;
			warning(failName);
		}
	}
	//debug must do object as well like below maybe
	if (star->starClass && starCurrent->starClass) starCurrent->starClass->number = star->starClass->number;
}
}//end


void EditStarWindow::SaveStars(const char * fileName) 
{

SaveUniverse(fileName);
}//end


void EditStarWindow::LoadStars(const char * fileName) 
{

LoadUniverse(fileName);
}//end
