//functions of EditShipShieldWindow soi0.1

#include "windowGuts.h"
#include "editShipShieldWindow.h"
#include "def.h"
#include "s2f.h"
#include "showSomeThings.h"
#include "getSomeThings.h"
#include "getFromList.h"
#include "saveLoadUniverse.h"
#include "titleWindow.h"
#include "designButtons.h"

void EditShipShieldWindow::SaveRequested(const char * fileName) 
{

SaveShipShields(fileName);
}//end


EditShipShieldWindow::EditShipShieldWindow(BRect area, const char *title) : BWindow(area, title, B_TITLED_WINDOW, B_NOT_RESIZABLE|B_NOT_ZOOMABLE) 
{

err = NO_ERR;
orderButton = NULL;
kindButton = NULL;
defaultStrengthGadget = NULL;
bb = new BottomButtons;
if (bb) 
{
	if (editUniverseWindow) 
	{
		editUniverseWindow->Lock();
		editUniverseWindow->buttons[DSN_SSHIELD]->SetEnabled(false);
		editUniverseWindow->Unlock();
	}
	db = new DoableButtons();
	if (db) 
	{
		maint = new DoableButtons();
		if (maint) 
		{
			scg = new SmallConstantsGadgets();
			if (scg) 
			{
				bld = new DoableButtons();
				if (!bld) err = CREATEDNOTADDED;
			}
			else err = CREATEDNOTADDED;
		}
		else err = CREATEDNOTADDED;
	}
	else err = CREATEDNOTADDED;
}
else err = CREATEDNOTADDED;
editShipShieldWindow = this;
if (!shipShieldCurrent) if (dataListGlobal[SSHIELD_TYPE]->list->CountItems()) shipShieldCurrent = (ShipShield *)((DataNode *)dataListGlobal[SSHIELD_TYPE]->list->ItemAt(0))->data;
}//end


EditShipShieldWindow::~EditShipShieldWindow() 
{

if (bb) 
{
	if (editUniverseWindow) 
	{
		editUniverseWindow->Lock();
		editUniverseWindow->buttons[DSN_SSHIELD]->SetEnabled(true);
		editUniverseWindow->Unlock();
	}
	delete bb;
}
if (defaultStrengthGadget) 
{
	defaultStrengthGadget->RemoveSelf();
	delete defaultStrengthGadget;
}
if (bld) delete bld;
if (db) delete db;
if (maint) delete maint;
if (scg) delete scg;
if (orderButton) 
{
	orderButton->RemoveSelf();
	delete orderButton;
}
if (kindButton) 
{
	kindButton->RemoveSelf();
	delete kindButton;
}
editShipShieldWindow = NULL;
}//end


void EditShipShieldWindow::AddShipShield(void) 
{

ShipShield * item = new ShipShield(shipShield, scg->nameStrGadget->Text(), dataListGlobal[SSHIELD_TYPE]);
if (item) 
{
	if (err != CREATED) 
	{
		delete item;
		return;
	}
}
else err = NO_SSHIELD;
}//end


void EditShipShieldWindow::MessageReceived(BMessage *message) 
{

bool validate = true;
int32 shipShieldSize = sizeof shipShieldCurrent;
if (!strcmp(scg->nameStrGadget->Text(), "")) validate = false;

switch (message->what) 
{
	case SOI_NAME:
	case SOI_VOLUME:
	case SOI_VPER:
	
	break;
	case SOI_MAINTAINABLEBUTTONLABEL:
		if (maint->showing) 
		{
			maint->label->SetLabel(selectMaintValue);
			maint->showing = false;
		}
		else {
			maint->label->SetLabel(showMaintValue);
			maint->showing = true;
		}
		maint->ResetMsg(message->what);
	break;
	case SOI_BUILDABLEBUTTONLABEL:
		if (bld->showing) 
		{
			bld->label->SetLabel(selectProdValue);
			bld->showing = false;
		}
		else {
			bld->label->SetLabel(showProdValue);
			bld->showing = true;
		}
		bld->ResetMsg(message->what);
	break;
	case SOI_DOABLEBUTTONLABEL:
		if (db->showing) 
		{
			db->label->SetLabel(selectConsumeValue);
			db->showing = false;
		}
		else {
			db->label->SetLabel(showConsumeValue);
			db->showing = true;
		}
		db->ResetMsg(message->what);
	break;
	case SOI_GETPOSSORDERS:
	
	break;
	case SOI_BUILDABLEBUTTONPRIMALELEMENTS:
		GetSomeThings(shipShield->buildable->elementPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], SSHIELD_TYPE);
	break;
	case SOI_BUILDABLEBUTTONPRIMALCOMPOUNDS:
		GetSomeThings(shipShield->buildable->compoundPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], SSHIELD_TYPE);
	break;
	case SOI_BUILDABLEBUTTONELEMENTS:
		GetSomeThings(shipShield->buildable->elementManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], SSHIELD_TYPE);
	break;
	case SOI_BUILDABLEBUTTONCOMPOUNDS:
		GetSomeThings(shipShield->buildable->compoundManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], SSHIELD_TYPE);
	break;
	case SOI_BUILDABLEBUTTONMINES:
		GetSomeThings(shipShield->buildable->mineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[MINE_TYPE], SSHIELD_TYPE);
	break;
	case SOI_BUILDABLEBUTTONFACTORYS:
		GetSomeThings(shipShield->buildable->factoryManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[FACTORY_TYPE], SSHIELD_TYPE);
	break;
	case SOI_BUILDABLEBUTTONENGINES:
		GetSomeThings(shipShield->buildable->engineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ENGINE_TYPE], SSHIELD_TYPE);
	break;
	case SOI_BUILDABLEBUTTONSHIPS:
		GetSomeThings(shipShield->buildable->shipManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIP_TYPE], SSHIELD_TYPE);
	break;
	case SOI_BUILDABLEBUTTONSSHIELDS:
		GetSomeThings(shipShield->buildable->shipShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SSHIELD_TYPE], SSHIELD_TYPE);
	break;
	case SOI_BUILDABLEBUTTONSHIPWEAPONS:
		GetSomeThings(shipShield->buildable->shipWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIPWEAPON_TYPE], SSHIELD_TYPE);
	break;
	case SOI_BUILDABLEBUTTONPLANETSHIELDS:
		GetSomeThings(shipShield->buildable->planetShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETSHIELD_TYPE], SSHIELD_TYPE);
	break;
	case SOI_BUILDABLEBUTTONPLANETWEAPONS:
		GetSomeThings(shipShield->buildable->planetWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETWEAPON_TYPE], SSHIELD_TYPE);
	break;
	case SOI_DOABLEBUTTONPRIMALELEMENTS:
		GetSomeThings(shipShield->doable->elementPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], SSHIELD_TYPE);
	break;
	case SOI_DOABLEBUTTONPRIMALCOMPOUNDS:
		GetSomeThings(shipShield->doable->compoundPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], SSHIELD_TYPE);
	break;
	case SOI_DOABLEBUTTONELEMENTS:
		GetSomeThings(shipShield->doable->elementManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], SSHIELD_TYPE);
	break;
	case SOI_DOABLEBUTTONCOMPOUNDS:
		GetSomeThings(shipShield->doable->compoundManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], SSHIELD_TYPE);
	break;
	case SOI_DOABLEBUTTONMINES:
		GetSomeThings(shipShield->doable->mineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[MINE_TYPE], SSHIELD_TYPE);
	break;
	case SOI_DOABLEBUTTONFACTORYS:
		GetSomeThings(shipShield->doable->factoryManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[FACTORY_TYPE], SSHIELD_TYPE);
	break;
	case SOI_DOABLEBUTTONENGINES:
		GetSomeThings(shipShield->doable->engineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ENGINE_TYPE], SSHIELD_TYPE);
	break;
	case SOI_DOABLEBUTTONSHIPS:
		GetSomeThings(shipShield->doable->shipManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIP_TYPE], SSHIELD_TYPE);
	break;
	case SOI_DOABLEBUTTONSSHIELDS:
		GetSomeThings(shipShield->doable->shipShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SSHIELD_TYPE], SSHIELD_TYPE);
	break;
	case SOI_DOABLEBUTTONSHIPWEAPONS:
		GetSomeThings(shipShield->doable->shipWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIPWEAPON_TYPE], SSHIELD_TYPE);
	break;
	case SOI_DOABLEBUTTONPLANETSHIELDS:
		GetSomeThings(shipShield->doable->planetShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETSHIELD_TYPE], SSHIELD_TYPE);
	break;
	case SOI_DOABLEBUTTONPLANETWEAPONS:
		GetSomeThings(shipShield->doable->planetWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETWEAPON_TYPE], SSHIELD_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONPRIMALELEMENTS:
		GetSomeThings(shipShield->maintainable->elementPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], SSHIELD_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONPRIMALCOMPOUNDS:
		GetSomeThings(shipShield->maintainable->compoundPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], SSHIELD_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONELEMENTS:
		GetSomeThings(shipShield->maintainable->elementManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], SSHIELD_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONCOMPOUNDS:
		GetSomeThings(shipShield->maintainable->compoundManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], SSHIELD_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONMINES:
		GetSomeThings(shipShield->maintainable->mineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[MINE_TYPE], SSHIELD_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONFACTORYS:
		GetSomeThings(shipShield->maintainable->factoryManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[FACTORY_TYPE], SSHIELD_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONENGINES:
		GetSomeThings(shipShield->maintainable->engineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ENGINE_TYPE], SSHIELD_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONSHIPS:
		GetSomeThings(shipShield->maintainable->shipManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIP_TYPE], SSHIELD_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONSSHIELDS:
		GetSomeThings(shipShield->maintainable->shipShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SSHIELD_TYPE], SSHIELD_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONSHIPWEAPONS:
		GetSomeThings(shipShield->maintainable->shipWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIPWEAPON_TYPE], SSHIELD_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONPLANETSHIELDS:
		GetSomeThings(shipShield->maintainable->planetShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETSHIELD_TYPE], SSHIELD_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONPLANETWEAPONS:
		GetSomeThings(shipShield->maintainable->planetWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETWEAPON_TYPE], SSHIELD_TYPE);
	break;
	case SOI_SHOWBUILDPRIMALELEMENTS:
		ShowSomeThings((const void *)&shipShield, shipShieldSize, shipShieldCurrent->name, SSHIELD_TYPE, shipShield->buildable->elementPrimal, scg->nameStrGadget->Text(), editShipShieldWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWBUILDPRIMALCOMPOUNDS:
		ShowSomeThings((const void *)&shipShield, shipShieldSize, shipShieldCurrent->name, SSHIELD_TYPE, shipShield->buildable->compoundPrimal, scg->nameStrGadget->Text(), editShipShieldWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWBUILDELEMENTS:
		ShowSomeThings((const void *)&shipShield, shipShieldSize, shipShieldCurrent->name, SSHIELD_TYPE, shipShield->buildable->elementManufactured, scg->nameStrGadget->Text(), editShipShieldWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWBUILDCOMPOUNDS:
		ShowSomeThings((const void *)&shipShield, shipShieldSize, shipShieldCurrent->name, SSHIELD_TYPE, shipShield->buildable->compoundManufactured, scg->nameStrGadget->Text(), editShipShieldWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWBUILDMINES:
		ShowSomeThings((const void *)&shipShield, shipShieldSize, shipShieldCurrent->name, SSHIELD_TYPE, shipShield->buildable->mineManufactured, scg->nameStrGadget->Text(), editShipShieldWindow, dataListGlobal[MINE_TYPE]);
	break;
	case SOI_SHOWBUILDFACTORYS:
		ShowSomeThings((const void *)&shipShield, shipShieldSize, shipShieldCurrent->name, SSHIELD_TYPE, shipShield->buildable->factoryManufactured, scg->nameStrGadget->Text(), editShipShieldWindow, dataListGlobal[FACTORY_TYPE]);
	break;
	case SOI_SHOWBUILDENGINES:
		ShowSomeThings((const void *)&shipShield, shipShieldSize, shipShieldCurrent->name, SSHIELD_TYPE, shipShield->buildable->engineManufactured, scg->nameStrGadget->Text(), editShipShieldWindow, dataListGlobal[ENGINE_TYPE]);
	break;
	case SOI_SHOWBUILDSHIPS:
		ShowSomeThings((const void *)&shipShield, shipShieldSize, shipShieldCurrent->name, SSHIELD_TYPE, shipShield->buildable->shipManufactured, scg->nameStrGadget->Text(), editShipShieldWindow, dataListGlobal[SHIP_TYPE]);
	break;
	case SOI_SHOWBUILDSSHIELDS:
		ShowSomeThings((const void *)&shipShield, shipShieldSize, shipShieldCurrent->name, SSHIELD_TYPE, shipShield->buildable->shipShieldManufactured, scg->nameStrGadget->Text(), editShipShieldWindow, dataListGlobal[SSHIELD_TYPE]);
	break;
	case SOI_SHOWBUILDSHIPWEAPONS:
		ShowSomeThings((const void *)&shipShield, shipShieldSize, shipShieldCurrent->name, SSHIELD_TYPE, shipShield->buildable->shipWeaponManufactured, scg->nameStrGadget->Text(), editShipShieldWindow, dataListGlobal[SHIPWEAPON_TYPE]);
	break;
	case SOI_SHOWBUILDPLANETSHIELDS:
		ShowSomeThings((const void *)&shipShield, shipShieldSize, shipShieldCurrent->name, SSHIELD_TYPE, shipShield->buildable->planetShieldManufactured, scg->nameStrGadget->Text(), editShipShieldWindow, dataListGlobal[PLANETSHIELD_TYPE]);
	break;
	case SOI_SHOWBUILDPLANETWEAPONS:
		ShowSomeThings((const void *)&shipShield, shipShieldSize, shipShieldCurrent->name, SSHIELD_TYPE, shipShield->buildable->planetWeaponManufactured, scg->nameStrGadget->Text(), editShipShieldWindow, dataListGlobal[PLANETWEAPON_TYPE]);
	break;
	case SOI_SHOWDOPRIMALELEMENTS:
		ShowSomeThings((const void *)&shipShield, shipShieldSize, shipShieldCurrent->name, SSHIELD_TYPE, shipShield->doable->elementPrimal, scg->nameStrGadget->Text(), editShipShieldWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWDOPRIMALCOMPOUNDS:
		ShowSomeThings((const void *)&shipShield, shipShieldSize, shipShieldCurrent->name, SSHIELD_TYPE, shipShield->doable->compoundPrimal, scg->nameStrGadget->Text(), editShipShieldWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWDOELEMENTS:
		ShowSomeThings((const void *)&shipShield, shipShieldSize, shipShieldCurrent->name, SSHIELD_TYPE, shipShield->doable->elementManufactured, scg->nameStrGadget->Text(), editShipShieldWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWDOCOMPOUNDS:
		ShowSomeThings((const void *)&shipShield, shipShieldSize, shipShieldCurrent->name, SSHIELD_TYPE, shipShield->doable->compoundManufactured, scg->nameStrGadget->Text(), editShipShieldWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWDOMINES:
		ShowSomeThings((const void *)&shipShield, shipShieldSize, shipShieldCurrent->name, SSHIELD_TYPE, shipShield->doable->mineManufactured, scg->nameStrGadget->Text(), editShipShieldWindow, dataListGlobal[MINE_TYPE]);
	break;
	case SOI_SHOWDOFACTORYS:
		ShowSomeThings((const void *)&shipShield, shipShieldSize, shipShieldCurrent->name, SSHIELD_TYPE, shipShield->doable->factoryManufactured, scg->nameStrGadget->Text(), editShipShieldWindow, dataListGlobal[FACTORY_TYPE]);
	break;
	case SOI_SHOWDOENGINES:
		ShowSomeThings((const void *)&shipShield, shipShieldSize, shipShieldCurrent->name, SSHIELD_TYPE, shipShield->doable->engineManufactured, scg->nameStrGadget->Text(), editShipShieldWindow, dataListGlobal[ENGINE_TYPE]);
	break;
	case SOI_SHOWDOSHIPS:
		ShowSomeThings((const void *)&shipShield, shipShieldSize, shipShieldCurrent->name, SSHIELD_TYPE, shipShield->doable->shipManufactured, scg->nameStrGadget->Text(), editShipShieldWindow, dataListGlobal[SHIP_TYPE]);
	break;
	case SOI_SHOWDOSSHIELDS:
		ShowSomeThings((const void *)&shipShield, shipShieldSize, shipShieldCurrent->name, SSHIELD_TYPE, shipShield->doable->shipShieldManufactured, scg->nameStrGadget->Text(), editShipShieldWindow, dataListGlobal[SSHIELD_TYPE]);
	break;
	case SOI_SHOWDOSHIPWEAPONS:
		ShowSomeThings((const void *)&shipShield, shipShieldSize, shipShieldCurrent->name, SSHIELD_TYPE, shipShield->doable->shipWeaponManufactured, scg->nameStrGadget->Text(), editShipShieldWindow, dataListGlobal[SHIPWEAPON_TYPE]);
	break;
	case SOI_SHOWDOPLANETSHIELDS:
		ShowSomeThings((const void *)&shipShield, shipShieldSize, shipShieldCurrent->name, SSHIELD_TYPE, shipShield->doable->planetShieldManufactured, scg->nameStrGadget->Text(), editShipShieldWindow, dataListGlobal[PLANETSHIELD_TYPE]);
	break;
	case SOI_SHOWDOPLANETWEAPONS:
		ShowSomeThings((const void *)&shipShield, shipShieldSize, shipShieldCurrent->name, SSHIELD_TYPE, shipShield->doable->planetWeaponManufactured, scg->nameStrGadget->Text(), editShipShieldWindow, dataListGlobal[PLANETWEAPON_TYPE]);
	break;
	case SOI_SHOWMAINTPRIMALELEMENTS:
		ShowSomeThings((const void *)&shipShield, shipShieldSize, shipShieldCurrent->name, SSHIELD_TYPE, shipShield->maintainable->elementPrimal, scg->nameStrGadget->Text(), editShipShieldWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWMAINTPRIMALCOMPOUNDS:
		ShowSomeThings((const void *)&shipShield, shipShieldSize, shipShieldCurrent->name, SSHIELD_TYPE, shipShield->maintainable->compoundPrimal, scg->nameStrGadget->Text(), editShipShieldWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWMAINTELEMENTS:
		ShowSomeThings((const void *)&shipShield, shipShieldSize, shipShieldCurrent->name, SSHIELD_TYPE, shipShield->maintainable->elementManufactured, scg->nameStrGadget->Text(), editShipShieldWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWMAINTCOMPOUNDS:
		ShowSomeThings((const void *)&shipShield, shipShieldSize, shipShieldCurrent->name, SSHIELD_TYPE, shipShield->maintainable->compoundManufactured, scg->nameStrGadget->Text(), editShipShieldWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWMAINTMINES:
		ShowSomeThings((const void *)&shipShield, shipShieldSize, shipShieldCurrent->name, SSHIELD_TYPE, shipShield->maintainable->mineManufactured, scg->nameStrGadget->Text(), editShipShieldWindow, dataListGlobal[MINE_TYPE]);
	break;
	case SOI_SHOWMAINTFACTORYS:
		ShowSomeThings((const void *)&shipShield, shipShieldSize, shipShieldCurrent->name, SSHIELD_TYPE, shipShield->maintainable->factoryManufactured, scg->nameStrGadget->Text(), editShipShieldWindow, dataListGlobal[FACTORY_TYPE]);
	break;
	case SOI_SHOWMAINTENGINES:
		ShowSomeThings((const void *)&shipShield, shipShieldSize, shipShieldCurrent->name, SSHIELD_TYPE, shipShield->maintainable->engineManufactured, scg->nameStrGadget->Text(), editShipShieldWindow, dataListGlobal[ENGINE_TYPE]);
	break;
	case SOI_SHOWMAINTSHIPS:
		ShowSomeThings((const void *)&shipShield, shipShieldSize, shipShieldCurrent->name, SSHIELD_TYPE, shipShield->maintainable->shipManufactured, scg->nameStrGadget->Text(), editShipShieldWindow, dataListGlobal[SHIP_TYPE]);
	break;
	case SOI_SHOWMAINTSSHIELDS:
		ShowSomeThings((const void *)&shipShield, shipShieldSize, shipShieldCurrent->name, SSHIELD_TYPE, shipShield->maintainable->shipShieldManufactured, scg->nameStrGadget->Text(), editShipShieldWindow, dataListGlobal[SSHIELD_TYPE]);
	break;
	case SOI_SHOWMAINTSHIPWEAPONS:
		ShowSomeThings((const void *)&shipShield, shipShieldSize, shipShieldCurrent->name, SSHIELD_TYPE, shipShield->maintainable->shipWeaponManufactured, scg->nameStrGadget->Text(), editShipShieldWindow, dataListGlobal[SHIPWEAPON_TYPE]);
	break;
	case SOI_SHOWMAINTPLANETSHIELDS:
		ShowSomeThings((const void *)&shipShield, shipShieldSize, shipShieldCurrent->name, SSHIELD_TYPE, shipShield->maintainable->planetShieldManufactured, scg->nameStrGadget->Text(), editShipShieldWindow, dataListGlobal[PLANETSHIELD_TYPE]);
	break;
	case SOI_SHOWMAINTPLANETWEAPONS:
		ShowSomeThings((const void *)&shipShield, shipShieldSize, shipShieldCurrent->name, SSHIELD_TYPE, shipShield->maintainable->planetWeaponManufactured, scg->nameStrGadget->Text(), editShipShieldWindow, dataListGlobal[PLANETWEAPON_TYPE]);
	break;
	case SOI_BLREMOVE:
		dataListGlobal[SSHIELD_TYPE]->Remove();
		Quit();
	break;
	case SOI_BLLIST:
		GetFromList((void *)editShipShieldWindow, dataListGlobal[SSHIELD_TYPE], scg->nameStrGadget->Text());
	break;
	case SOI_BLLISTGOT:
		if (validate) ValidateShipShield();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateShipShield();
			shipShieldCurrent = shipShieldNewCurrent;
			shipShield->Copy(shipShieldCurrent);
			scg->nameStrGadget->SetText(shipShieldCurrent->name);
			thisDNPtr = dataListGlobal[SSHIELD_TYPE]->NextPrevItems((void *)shipShieldCurrent, &nextDNPtr, &prevDNPtr, bb);
			if (!bb->gnu) 
			{
				BRect gnuRect(154,bottom, 189,34);
				bb->gnu = new BButton(gnuRect, "", newStr, new BMessage(SOI_BLGNU));
				AddChild(bb->gnu);
				bb->gnu->SetTarget(this);
				bb->add->SetLabel(removeStr);
				bb->add->SetMessage(new BMessage(SOI_BLREMOVE));
			}
		}
	break;
	case SOI_BLPREV:
		ShipShield * prevShipShield = (ShipShield *)((DataNode *)prevDNPtr)->data;
		if (validate) ValidateShipShield();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateShipShield();
			shipShieldCurrent = prevShipShield;
			shipShield->Copy(shipShieldCurrent);
			scg->nameStrGadget->SetText(shipShieldCurrent->name);
			thisDNPtr = dataListGlobal[SSHIELD_TYPE]->NextPrevItems((void *)shipShieldCurrent, &nextDNPtr, &prevDNPtr, bb);
		}
	break;
	case SOI_BLDONE:
		if (!validate) 
		{
			Quit();
		}
		if (!strcmp(removeStr, bb->add->Label())) 
		{
			ValidateShipShield();
			if (err == NO_ERR) 
			{
				UpdateShipShield();
			}
		}
		if (err == NO_ERR) 
		{
			Quit();
		}
	break;
	case SOI_BLGNU:
		if (validate) ValidateShipShield();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateShipShield();
			shipShieldCurrent = NULL;
			RemoveChild(bb->gnu);
			delete bb->gnu;
			bb->gnu = NULL;
			bb->add->SetLabel(addStr);
			bb->add->SetMessage(new BMessage(SOI_BLADD));
			scg->nameStrGadget->SetText("");
			scg->nameStrGadget->MakeFocus();
		}
	break;
	case SOI_BLADD:
		if (validate) ValidateShipShield();
		else {
			err = NO_NAME;
			warning(everythingNamed);
		}//for add don't update
		if (err == NO_ERR) 
		{
			AddShipShield();
			if (err) 
			{
				if (err != CREATEDNOTADDED) 
				{
					Quit();
				}
			}
			else {
				if (editUniverseWindow) 
				{
					editUniverseWindow->Lock();
					editUniverseWindow->buttons[DSN_SSHIELD]->SetLabel(editThe[SSHIELD_TYPE]);
					editUniverseWindow->bb->save->SetEnabled(true);
					editUniverseWindow->Unlock();
				}
				scg->nameStrGadget->SetText("");
				scg->nameStrGadget->MakeFocus();
				bb->save->SetEnabled(true);
				if (openingWindow) 
				{
					openingWindow->Lock();
					openingWindow->universeButton->SetLabel(editThe[UNIVERSE_TYPE]);
					openingWindow->createUniverseButton->SetEnabled(true);
					openingWindow->realUniverseButton->SetEnabled(true);
					openingWindow->Unlock();
				}
				shipShield->maintainable->EmptyList();
				shipShield->buildable->EmptyList();
				shipShield->doable->EmptyList();
			}
		}
	break;
	case SOI_BLSAVE:
		if (validate) ValidateShipShield();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateShipShield();
			//RunSavePanel("universe", saveThe[UNIVERSE_TYPE], saveStr, cancelStr);
		}
	break;
	case SOI_BLPIC:
	
	break;
	case SOI_LOADUNIVERSEFROMPANEL:
		LoadShipShields("universe");//debug
		Quit();
	break;
	case SOI_BLLOAD:
		BMessage * bm = new BMessage(SOI_LOADUNIVERSEFROMPANEL);
		if (bm) break;//debug break;//debug be_app->RunFilePanel(loadThe[UNIVERSE_TYPE], loadStr, cancelStr, false, bm);
		else warning(failMemory);
	break;
	case SOI_BLNEXT:
		ShipShield * nextShipShield = (ShipShield *)((DataNode *)nextDNPtr)->data;
		if (validate) ValidateShipShield();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateShipShield();
			shipShieldCurrent = nextShipShield;
			shipShield->Copy(shipShieldCurrent);
			scg->nameStrGadget->SetText(shipShieldCurrent->name);
			thisDNPtr = dataListGlobal[SSHIELD_TYPE]->NextPrevItems((void *)shipShieldCurrent, &nextDNPtr, &prevDNPtr, bb);
		}
	break;
	default:
		BWindow::MessageReceived(message);
	break;
}
}//end

bool EditShipShieldWindow::QuitRequested(void) 
{

if (strcmp(scg->nameStrGadget->Text(), "")) 
{
	if (shipShieldCurrent) 
	{
		ValidateShipShield();
		if (err == NO_ERR) 
		{
			UpdateShipShield();
			if (err == NO_ERR) 
			{
				Quit();
				return(BWindow::QuitRequested());
			}
			else return false;
		}
		else return false;
	}
}
Quit();
return(BWindow::QuitRequested());
}//end


void EditShipShieldWindow::ValidateShipShield(void) 
{

UniqueName(dataListGlobal[SSHIELD_TYPE], scg->nameStrGadget->Text());
if (NO_UNIQUE == err) 
{
	warning(failNameUnique[SSHIELD_TYPE]);
	return;
}
uint32 v, vp;
float ds;

v = s2uint32(scg->vIntGadget->Text());
if (S2UIERR == err) 
{
	warning(SCGVolumeErr);
	return;
}
vp = s2uint32(scg->vperIntGadget->Text());
if (S2UIERR == err) 
{
	warning(SCGVolumePerErr);
	return;
}
ds = s2f(defaultStrengthGadget->Text());
if (S2FERR == err) 
{
	warning(defaultStrengthErr);
	return;
}
shipShield->defaultStrength = ds;
shipShield->volume = v;
shipShield->vper = vp;
}//end


void EditShipShieldWindow::UpdateShipShield(void) 
{

err = NO_ERR;
shipShield->mass = 0;
UIntPtrNode * node;
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)shipShield->buildable->elementPrimal->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	shipShield->mass += ((Element *)(node->data))->mass;
	shipShield->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)shipShield->buildable->compoundPrimal->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	shipShield->mass += ((Compound *)(node->data))->mass;
	shipShield->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)shipShield->buildable->elementManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	shipShield->mass += ((Element *)(node->data))->mass;
	shipShield->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)shipShield->buildable->compoundManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	shipShield->mass += ((Compound *)(node->data))->mass;
	shipShield->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)shipShield->buildable->shipShieldManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	shipShield->mass += ((ShipShield *)(node->data))->mass;
	shipShield->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)shipShield->buildable->factoryManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	shipShield->mass += ((Factory *)(node->data))->mass;
	shipShield->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)shipShield->buildable->engineManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	shipShield->mass += ((Engine *)(node->data))->mass;
	shipShield->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)shipShield->buildable->shipManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	shipShield->mass += ((Ship *)(node->data))->mass;
	shipShield->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)shipShield->buildable->shipShieldManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	shipShield->mass += ((ShipShield *)(node->data))->mass;
	shipShield->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)shipShield->buildable->shipWeaponManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	shipShield->mass += ((ShipWeapon *)(node->data))->mass;
	shipShield->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)shipShield->buildable->planetShieldManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	shipShield->mass += ((PlanetShield *)(node->data))->mass;
	shipShield->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)shipShield->buildable->planetWeaponManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	shipShield->mass += ((PlanetWeapon *)(node->data))->mass;
	shipShield->mass *= node->number;
}
if (shipShieldCurrent) shipShieldCurrent->Copy(shipShield);
}//end


void EditShipShieldWindow::SaveShipShields(const char * fileName) 
{

SaveUniverse(fileName);
}//end


void EditShipShieldWindow::LoadShipShields(
const char * fileName) 
{

LoadUniverse(fileName);
}//end
