//functions of EditPlanetWeaponWindow soi0.1

#include "windowGuts.h"
#include "editPlanetWeaponWindow.h"
#include "def.h"
#include "s2f.h"
#include "showSomeThings.h"
#include "getSomeThings.h"
#include "getFromList.h"
#include "saveLoadUniverse.h"
#include "titleWindow.h"
#include "designButtons.h"

void EditPlanetWeaponWindow::SaveRequested(const char * fileName) 
{

SavePlanetWeapons(fileName);
}//end


EditPlanetWeaponWindow::EditPlanetWeaponWindow(BRect area, const char *title) : BWindow(area, title, B_TITLED_WINDOW, B_NOT_RESIZABLE|B_NOT_ZOOMABLE) 
{

err = NO_ERR;
orderButton = NULL;
kindButton = NULL;
defaultStrengthGadget = NULL;
bb = new BottomButtons;
if (bb) 
{
	if (editUniverseWindow) 
	{
		editUniverseWindow->Lock();
		editUniverseWindow->buttons[DSN_PLANETWEAPON]->SetEnabled(false);
		editUniverseWindow->Unlock();
	}
	db = new DoableButtons();
	if (db) 
	{
		maint = new DoableButtons();
		if (maint) 
		{
			scg = new SmallConstantsGadgets();
			if (scg) 
			{
				bld = new DoableButtons();
				if (!bld) err = CREATEDNOTADDED;
			}
			else err = CREATEDNOTADDED;
		}
		else err = CREATEDNOTADDED;
	}
	else err = CREATEDNOTADDED;
}
else err = CREATEDNOTADDED;
editPlanetWeaponWindow = this;
if (!planetWeaponCurrent) if (dataListGlobal[PLANETWEAPON_TYPE]->list->CountItems()) planetWeaponCurrent = (PlanetWeapon *)((DataNode *)dataListGlobal[PLANETWEAPON_TYPE]->list->ItemAt(0))->data;
}//end


EditPlanetWeaponWindow::~EditPlanetWeaponWindow() 
{

if (bb) 
{
	if (editUniverseWindow) 
	{
		editUniverseWindow->Lock();
		editUniverseWindow->buttons[DSN_PLANETWEAPON]->SetEnabled(true);
		editUniverseWindow->Unlock();
	}
	delete bb;
}
if (defaultStrengthGadget) 
{
	defaultStrengthGadget->RemoveSelf();
	delete defaultStrengthGadget;
}
if (bld) delete bld;
if (db) delete db;
if (maint) delete maint;
if (scg) delete scg;
if (orderButton) 
{
	orderButton->RemoveSelf();
	delete orderButton;
}
if (kindButton) 
{
	kindButton->RemoveSelf();
	delete kindButton;
}
editPlanetWeaponWindow = NULL;
}//end


void EditPlanetWeaponWindow::AddPlanetWeapon(void) 
{

PlanetWeapon * item = new PlanetWeapon(planetWeapon, scg->nameStrGadget->Text(), dataListGlobal[PLANETWEAPON_TYPE]);
if (item) 
{
	if (err != CREATED) 
	{
		delete item;
		return;
	}
}
else err = NO_PLANETWEAPON;
}//end


void EditPlanetWeaponWindow::MessageReceived(BMessage *message) 
{

bool validate = true;
int32 planetWeaponSize = sizeof planetWeaponCurrent;
if (!strcmp(scg->nameStrGadget->Text(), "")) validate = false;

switch (message->what) 
{
	case SOI_NAME:
	case SOI_VOLUME:
	case SOI_VPER:
	
	break;
	case SOI_MAINTAINABLEBUTTONLABEL:
		if (maint->showing) 
		{
			maint->label->SetLabel(selectMaintValue);
			maint->showing = false;
		}
		else {
			maint->label->SetLabel(showMaintValue);
			maint->showing = true;
		}
		maint->ResetMsg(message->what);
	break;
	case SOI_BUILDABLEBUTTONLABEL:
		if (bld->showing) 
		{
			bld->label->SetLabel(selectProdValue);
			bld->showing = false;
		}
		else {
			bld->label->SetLabel(showProdValue);
			bld->showing = true;
		}
		bld->ResetMsg(message->what);
	break;
	case SOI_DOABLEBUTTONLABEL:
		if (db->showing) 
		{
			db->label->SetLabel(selectConsumeValue);
			db->showing = false;
		}
		else {
			db->label->SetLabel(showConsumeValue);
			db->showing = true;
		}
		db->ResetMsg(message->what);
	break;
	case SOI_GETPOSSORDERS:
	
	break;
	case SOI_BUILDABLEBUTTONPRIMALELEMENTS:
		GetSomeThings(planetWeapon->buildable->elementPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], PLANETWEAPON_TYPE);
	break;
	case SOI_BUILDABLEBUTTONPRIMALCOMPOUNDS:
		GetSomeThings(planetWeapon->buildable->compoundPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], PLANETWEAPON_TYPE);
	break;
	case SOI_BUILDABLEBUTTONELEMENTS:
		GetSomeThings(planetWeapon->buildable->elementManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], PLANETWEAPON_TYPE);
	break;
	case SOI_BUILDABLEBUTTONCOMPOUNDS:
		GetSomeThings(planetWeapon->buildable->compoundManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], PLANETWEAPON_TYPE);
	break;
	case SOI_BUILDABLEBUTTONMINES:
		GetSomeThings(planetWeapon->buildable->mineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[MINE_TYPE], PLANETWEAPON_TYPE);
	break;
	case SOI_BUILDABLEBUTTONFACTORYS:
		GetSomeThings(planetWeapon->buildable->factoryManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[FACTORY_TYPE], PLANETWEAPON_TYPE);
	break;
	case SOI_BUILDABLEBUTTONENGINES:
		GetSomeThings(planetWeapon->buildable->engineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ENGINE_TYPE], PLANETWEAPON_TYPE);
	break;
	case SOI_BUILDABLEBUTTONSHIPS:
		GetSomeThings(planetWeapon->buildable->shipManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIP_TYPE], PLANETWEAPON_TYPE);
	break;
	case SOI_BUILDABLEBUTTONSSHIELDS:
		GetSomeThings(planetWeapon->buildable->shipShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SSHIELD_TYPE], PLANETWEAPON_TYPE);
	break;
	case SOI_BUILDABLEBUTTONSHIPWEAPONS:
		GetSomeThings(planetWeapon->buildable->shipWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIPWEAPON_TYPE], PLANETWEAPON_TYPE);
	break;
	case SOI_BUILDABLEBUTTONPLANETSHIELDS:
		GetSomeThings(planetWeapon->buildable->planetShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETSHIELD_TYPE], PLANETWEAPON_TYPE);
	break;
	case SOI_BUILDABLEBUTTONPLANETWEAPONS:
		GetSomeThings(planetWeapon->buildable->planetWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETWEAPON_TYPE], PLANETWEAPON_TYPE);
	break;
	case SOI_DOABLEBUTTONPRIMALELEMENTS:
		GetSomeThings(planetWeapon->doable->elementPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], PLANETWEAPON_TYPE);
	break;
	case SOI_DOABLEBUTTONPRIMALCOMPOUNDS:
		GetSomeThings(planetWeapon->doable->compoundPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], PLANETWEAPON_TYPE);
	break;
	case SOI_DOABLEBUTTONELEMENTS:
		GetSomeThings(planetWeapon->doable->elementManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], PLANETWEAPON_TYPE);
	break;
	case SOI_DOABLEBUTTONCOMPOUNDS:
		GetSomeThings(planetWeapon->doable->compoundManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], PLANETWEAPON_TYPE);
	break;
	case SOI_DOABLEBUTTONMINES:
		GetSomeThings(planetWeapon->doable->mineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[MINE_TYPE], PLANETWEAPON_TYPE);
	break;
	case SOI_DOABLEBUTTONFACTORYS:
		GetSomeThings(planetWeapon->doable->factoryManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[FACTORY_TYPE], PLANETWEAPON_TYPE);
	break;
	case SOI_DOABLEBUTTONENGINES:
		GetSomeThings(planetWeapon->doable->engineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ENGINE_TYPE], PLANETWEAPON_TYPE);
	break;
	case SOI_DOABLEBUTTONSHIPS:
		GetSomeThings(planetWeapon->doable->shipManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIP_TYPE], PLANETWEAPON_TYPE);
	break;
	case SOI_DOABLEBUTTONSSHIELDS:
		GetSomeThings(planetWeapon->doable->shipShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SSHIELD_TYPE], PLANETWEAPON_TYPE);
	break;
	case SOI_DOABLEBUTTONSHIPWEAPONS:
		GetSomeThings(planetWeapon->doable->shipWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIPWEAPON_TYPE], PLANETWEAPON_TYPE);
	break;
	case SOI_DOABLEBUTTONPLANETSHIELDS:
		GetSomeThings(planetWeapon->doable->planetShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETSHIELD_TYPE], PLANETWEAPON_TYPE);
	break;
	case SOI_DOABLEBUTTONPLANETWEAPONS:
		GetSomeThings(planetWeapon->doable->planetWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETWEAPON_TYPE], PLANETWEAPON_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONPRIMALELEMENTS:
		GetSomeThings(planetWeapon->maintainable->elementPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], PLANETWEAPON_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONPRIMALCOMPOUNDS:
		GetSomeThings(planetWeapon->maintainable->compoundPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], PLANETWEAPON_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONELEMENTS:
		GetSomeThings(planetWeapon->maintainable->elementManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], PLANETWEAPON_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONCOMPOUNDS:
		GetSomeThings(planetWeapon->maintainable->compoundManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], PLANETWEAPON_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONMINES:
		GetSomeThings(planetWeapon->maintainable->mineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[MINE_TYPE], PLANETWEAPON_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONFACTORYS:
		GetSomeThings(planetWeapon->maintainable->factoryManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[FACTORY_TYPE], PLANETWEAPON_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONENGINES:
		GetSomeThings(planetWeapon->maintainable->engineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ENGINE_TYPE], PLANETWEAPON_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONSHIPS:
		GetSomeThings(planetWeapon->maintainable->shipManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIP_TYPE], PLANETWEAPON_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONSSHIELDS:
		GetSomeThings(planetWeapon->maintainable->shipShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SSHIELD_TYPE], PLANETWEAPON_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONSHIPWEAPONS:
		GetSomeThings(planetWeapon->maintainable->shipWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIPWEAPON_TYPE], PLANETWEAPON_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONPLANETSHIELDS:
		GetSomeThings(planetWeapon->maintainable->planetShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETSHIELD_TYPE], PLANETWEAPON_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONPLANETWEAPONS:
		GetSomeThings(planetWeapon->maintainable->planetWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETWEAPON_TYPE], PLANETWEAPON_TYPE);
	break;
	case SOI_SHOWBUILDPRIMALELEMENTS:
		ShowSomeThings((const void *)&planetWeapon, planetWeaponSize, planetWeaponCurrent->name, PLANETWEAPON_TYPE, planetWeapon->buildable->elementPrimal, scg->nameStrGadget->Text(), editPlanetWeaponWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWBUILDPRIMALCOMPOUNDS:
		ShowSomeThings((const void *)&planetWeapon, planetWeaponSize, planetWeaponCurrent->name, PLANETWEAPON_TYPE, planetWeapon->buildable->compoundPrimal, scg->nameStrGadget->Text(), editPlanetWeaponWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWBUILDELEMENTS:
		ShowSomeThings((const void *)&planetWeapon, planetWeaponSize, planetWeaponCurrent->name, PLANETWEAPON_TYPE, planetWeapon->buildable->elementManufactured, scg->nameStrGadget->Text(), editPlanetWeaponWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWBUILDCOMPOUNDS:
		ShowSomeThings((const void *)&planetWeapon, planetWeaponSize, planetWeaponCurrent->name, PLANETWEAPON_TYPE, planetWeapon->buildable->compoundManufactured, scg->nameStrGadget->Text(), editPlanetWeaponWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWBUILDMINES:
		ShowSomeThings((const void *)&planetWeapon, planetWeaponSize, planetWeaponCurrent->name, PLANETWEAPON_TYPE, planetWeapon->buildable->mineManufactured, scg->nameStrGadget->Text(), editPlanetWeaponWindow, dataListGlobal[MINE_TYPE]);
	break;
	case SOI_SHOWBUILDFACTORYS:
		ShowSomeThings((const void *)&planetWeapon, planetWeaponSize, planetWeaponCurrent->name, PLANETWEAPON_TYPE, planetWeapon->buildable->factoryManufactured, scg->nameStrGadget->Text(), editPlanetWeaponWindow, dataListGlobal[FACTORY_TYPE]);
	break;
	case SOI_SHOWBUILDENGINES:
		ShowSomeThings((const void *)&planetWeapon, planetWeaponSize, planetWeaponCurrent->name, PLANETWEAPON_TYPE, planetWeapon->buildable->engineManufactured, scg->nameStrGadget->Text(), editPlanetWeaponWindow, dataListGlobal[ENGINE_TYPE]);
	break;
	case SOI_SHOWBUILDSHIPS:
		ShowSomeThings((const void *)&planetWeapon, planetWeaponSize, planetWeaponCurrent->name, PLANETWEAPON_TYPE, planetWeapon->buildable->shipManufactured, scg->nameStrGadget->Text(), editPlanetWeaponWindow, dataListGlobal[SHIP_TYPE]);
	break;
	case SOI_SHOWBUILDSSHIELDS:
		ShowSomeThings((const void *)&planetWeapon, planetWeaponSize, planetWeaponCurrent->name, PLANETWEAPON_TYPE, planetWeapon->buildable->shipShieldManufactured, scg->nameStrGadget->Text(), editPlanetWeaponWindow, dataListGlobal[SSHIELD_TYPE]);
	break;
	case SOI_SHOWBUILDSHIPWEAPONS:
		ShowSomeThings((const void *)&planetWeapon, planetWeaponSize, planetWeaponCurrent->name, PLANETWEAPON_TYPE, planetWeapon->buildable->shipWeaponManufactured, scg->nameStrGadget->Text(), editPlanetWeaponWindow, dataListGlobal[SHIPWEAPON_TYPE]);
	break;
	case SOI_SHOWBUILDPLANETSHIELDS:
		ShowSomeThings((const void *)&planetWeapon, planetWeaponSize, planetWeaponCurrent->name, PLANETWEAPON_TYPE, planetWeapon->buildable->planetShieldManufactured, scg->nameStrGadget->Text(), editPlanetWeaponWindow, dataListGlobal[PLANETSHIELD_TYPE]);
	break;
	case SOI_SHOWBUILDPLANETWEAPONS:
		ShowSomeThings((const void *)&planetWeapon, planetWeaponSize, planetWeaponCurrent->name, PLANETWEAPON_TYPE, planetWeapon->buildable->planetWeaponManufactured, scg->nameStrGadget->Text(), editPlanetWeaponWindow, dataListGlobal[PLANETWEAPON_TYPE]);
	break;
	case SOI_SHOWDOPRIMALELEMENTS:
		ShowSomeThings((const void *)&planetWeapon, planetWeaponSize, planetWeaponCurrent->name, PLANETWEAPON_TYPE, planetWeapon->doable->elementPrimal, scg->nameStrGadget->Text(), editPlanetWeaponWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWDOPRIMALCOMPOUNDS:
		ShowSomeThings((const void *)&planetWeapon, planetWeaponSize, planetWeaponCurrent->name, PLANETWEAPON_TYPE, planetWeapon->doable->compoundPrimal, scg->nameStrGadget->Text(), editPlanetWeaponWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWDOELEMENTS:
		ShowSomeThings((const void *)&planetWeapon, planetWeaponSize, planetWeaponCurrent->name, PLANETWEAPON_TYPE, planetWeapon->doable->elementManufactured, scg->nameStrGadget->Text(), editPlanetWeaponWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWDOCOMPOUNDS:
		ShowSomeThings((const void *)&planetWeapon, planetWeaponSize, planetWeaponCurrent->name, PLANETWEAPON_TYPE, planetWeapon->doable->compoundManufactured, scg->nameStrGadget->Text(), editPlanetWeaponWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWDOMINES:
		ShowSomeThings((const void *)&planetWeapon, planetWeaponSize, planetWeaponCurrent->name, PLANETWEAPON_TYPE, planetWeapon->doable->mineManufactured, scg->nameStrGadget->Text(), editPlanetWeaponWindow, dataListGlobal[MINE_TYPE]);
	break;
	case SOI_SHOWDOFACTORYS:
		ShowSomeThings((const void *)&planetWeapon, planetWeaponSize, planetWeaponCurrent->name, PLANETWEAPON_TYPE, planetWeapon->doable->factoryManufactured, scg->nameStrGadget->Text(), editPlanetWeaponWindow, dataListGlobal[FACTORY_TYPE]);
	break;
	case SOI_SHOWDOENGINES:
		ShowSomeThings((const void *)&planetWeapon, planetWeaponSize, planetWeaponCurrent->name, PLANETWEAPON_TYPE, planetWeapon->doable->engineManufactured, scg->nameStrGadget->Text(), editPlanetWeaponWindow, dataListGlobal[ENGINE_TYPE]);
	break;
	case SOI_SHOWDOSHIPS:
		ShowSomeThings((const void *)&planetWeapon, planetWeaponSize, planetWeaponCurrent->name, PLANETWEAPON_TYPE, planetWeapon->doable->shipManufactured, scg->nameStrGadget->Text(), editPlanetWeaponWindow, dataListGlobal[SHIP_TYPE]);
	break;
	case SOI_SHOWDOSSHIELDS:
		ShowSomeThings((const void *)&planetWeapon, planetWeaponSize, planetWeaponCurrent->name, PLANETWEAPON_TYPE, planetWeapon->doable->shipShieldManufactured, scg->nameStrGadget->Text(), editPlanetWeaponWindow, dataListGlobal[SSHIELD_TYPE]);
	break;
	case SOI_SHOWDOSHIPWEAPONS:
		ShowSomeThings((const void *)&planetWeapon, planetWeaponSize, planetWeaponCurrent->name, PLANETWEAPON_TYPE, planetWeapon->doable->shipWeaponManufactured, scg->nameStrGadget->Text(), editPlanetWeaponWindow, dataListGlobal[SHIPWEAPON_TYPE]);
	break;
	case SOI_SHOWDOPLANETSHIELDS:
		ShowSomeThings((const void *)&planetWeapon, planetWeaponSize, planetWeaponCurrent->name, PLANETWEAPON_TYPE, planetWeapon->doable->planetShieldManufactured, scg->nameStrGadget->Text(), editPlanetWeaponWindow, dataListGlobal[PLANETSHIELD_TYPE]);
	break;
	case SOI_SHOWDOPLANETWEAPONS:
		ShowSomeThings((const void *)&planetWeapon, planetWeaponSize, planetWeaponCurrent->name, PLANETWEAPON_TYPE, planetWeapon->doable->planetWeaponManufactured, scg->nameStrGadget->Text(), editPlanetWeaponWindow, dataListGlobal[PLANETWEAPON_TYPE]);
	break;
	case SOI_SHOWMAINTPRIMALELEMENTS:
		ShowSomeThings((const void *)&planetWeapon, planetWeaponSize, planetWeaponCurrent->name, PLANETWEAPON_TYPE, planetWeapon->maintainable->elementPrimal, scg->nameStrGadget->Text(), editPlanetWeaponWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWMAINTPRIMALCOMPOUNDS:
		ShowSomeThings((const void *)&planetWeapon, planetWeaponSize, planetWeaponCurrent->name, PLANETWEAPON_TYPE, planetWeapon->maintainable->compoundPrimal, scg->nameStrGadget->Text(), editPlanetWeaponWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWMAINTELEMENTS:
		ShowSomeThings((const void *)&planetWeapon, planetWeaponSize, planetWeaponCurrent->name, PLANETWEAPON_TYPE, planetWeapon->maintainable->elementManufactured, scg->nameStrGadget->Text(), editPlanetWeaponWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWMAINTCOMPOUNDS:
		ShowSomeThings((const void *)&planetWeapon, planetWeaponSize, planetWeaponCurrent->name, PLANETWEAPON_TYPE, planetWeapon->maintainable->compoundManufactured, scg->nameStrGadget->Text(), editPlanetWeaponWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWMAINTMINES:
		ShowSomeThings((const void *)&planetWeapon, planetWeaponSize, planetWeaponCurrent->name, PLANETWEAPON_TYPE, planetWeapon->maintainable->mineManufactured, scg->nameStrGadget->Text(), editPlanetWeaponWindow, dataListGlobal[MINE_TYPE]);
	break;
	case SOI_SHOWMAINTFACTORYS:
		ShowSomeThings((const void *)&planetWeapon, planetWeaponSize, planetWeaponCurrent->name, PLANETWEAPON_TYPE, planetWeapon->maintainable->factoryManufactured, scg->nameStrGadget->Text(), editPlanetWeaponWindow, dataListGlobal[FACTORY_TYPE]);
	break;
	case SOI_SHOWMAINTENGINES:
		ShowSomeThings((const void *)&planetWeapon, planetWeaponSize, planetWeaponCurrent->name, PLANETWEAPON_TYPE, planetWeapon->maintainable->engineManufactured, scg->nameStrGadget->Text(), editPlanetWeaponWindow, dataListGlobal[ENGINE_TYPE]);
	break;
	case SOI_SHOWMAINTSHIPS:
		ShowSomeThings((const void *)&planetWeapon, planetWeaponSize, planetWeaponCurrent->name, PLANETWEAPON_TYPE, planetWeapon->maintainable->shipManufactured, scg->nameStrGadget->Text(), editPlanetWeaponWindow, dataListGlobal[SHIP_TYPE]);
	break;
	case SOI_SHOWMAINTSSHIELDS:
		ShowSomeThings((const void *)&planetWeapon, planetWeaponSize, planetWeaponCurrent->name, PLANETWEAPON_TYPE, planetWeapon->maintainable->shipShieldManufactured, scg->nameStrGadget->Text(), editPlanetWeaponWindow, dataListGlobal[SSHIELD_TYPE]);
	break;
	case SOI_SHOWMAINTSHIPWEAPONS:
		ShowSomeThings((const void *)&planetWeapon, planetWeaponSize, planetWeaponCurrent->name, PLANETWEAPON_TYPE, planetWeapon->maintainable->shipWeaponManufactured, scg->nameStrGadget->Text(), editPlanetWeaponWindow, dataListGlobal[SHIPWEAPON_TYPE]);
	break;
	case SOI_SHOWMAINTPLANETSHIELDS:
		ShowSomeThings((const void *)&planetWeapon, planetWeaponSize, planetWeaponCurrent->name, PLANETWEAPON_TYPE, planetWeapon->maintainable->planetShieldManufactured, scg->nameStrGadget->Text(), editPlanetWeaponWindow, dataListGlobal[PLANETSHIELD_TYPE]);
	break;
	case SOI_SHOWMAINTPLANETWEAPONS:
		ShowSomeThings((const void *)&planetWeapon, planetWeaponSize, planetWeaponCurrent->name, PLANETWEAPON_TYPE, planetWeapon->maintainable->planetWeaponManufactured, scg->nameStrGadget->Text(), editPlanetWeaponWindow, dataListGlobal[PLANETWEAPON_TYPE]);
	break;
	case SOI_BLREMOVE:
		dataListGlobal[PLANETWEAPON_TYPE]->Remove();
		Quit();
	break;
	case SOI_BLLIST:
		GetFromList((void *)editPlanetWeaponWindow, dataListGlobal[PLANETWEAPON_TYPE], scg->nameStrGadget->Text());
	break;
	case SOI_BLLISTGOT:
		if (validate) ValidatePlanetWeapon();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdatePlanetWeapon();
			planetWeaponCurrent = planetWeaponNewCurrent;
			planetWeapon->Copy(planetWeaponCurrent);
			scg->nameStrGadget->SetText(planetWeaponCurrent->name);
			thisDNPtr = dataListGlobal[PLANETWEAPON_TYPE]->NextPrevItems((void *)planetWeaponCurrent, &nextDNPtr, &prevDNPtr, bb);
			if (!bb->gnu) 
			{
				BRect gnuRect(154,bottom, 189,34);
				bb->gnu = new BButton(gnuRect, "", newStr, new BMessage(SOI_BLGNU));
				AddChild(bb->gnu);
				bb->gnu->SetTarget(this);
				bb->add->SetLabel(removeStr);
				bb->add->SetMessage(new BMessage(SOI_BLREMOVE));
			}
		}
	break;
	case SOI_BLPREV:
		PlanetWeapon * prevPlanetWeapon = (PlanetWeapon *)((DataNode *)prevDNPtr)->data;
		if (validate) ValidatePlanetWeapon();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdatePlanetWeapon();
			planetWeaponCurrent = prevPlanetWeapon;
			planetWeapon->Copy(planetWeaponCurrent);
			scg->nameStrGadget->SetText(planetWeaponCurrent->name);
			thisDNPtr = dataListGlobal[PLANETWEAPON_TYPE]->NextPrevItems((void *)planetWeaponCurrent, &nextDNPtr, &prevDNPtr, bb);
		}
	break;
	case SOI_BLDONE:
		if (!validate) 
		{
			Quit();
		}
		if (!strcmp(removeStr, bb->add->Label())) 
		{
			ValidatePlanetWeapon();
			if (err == NO_ERR) 
			{
				UpdatePlanetWeapon();
			}
		}
		if (err == NO_ERR) 
		{
			Quit();
		}
	break;
	case SOI_BLGNU:
		if (validate) ValidatePlanetWeapon();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdatePlanetWeapon();
			planetWeaponCurrent = NULL;
			RemoveChild(bb->gnu);
			delete bb->gnu;
			bb->gnu = NULL;
			bb->add->SetLabel(addStr);
			bb->add->SetMessage(new BMessage(SOI_BLADD));
			scg->nameStrGadget->SetText("");
			scg->nameStrGadget->MakeFocus();
		}
	break;
	case SOI_BLADD:
		if (validate) ValidatePlanetWeapon();
		else {
			err = NO_NAME;
			warning(everythingNamed);
		}//for add don't update
		if (err == NO_ERR) 
		{
			AddPlanetWeapon();
			if (err) 
			{
				if (err != CREATEDNOTADDED) 
				{
					Quit();
				}
			}
			else {
				if (editUniverseWindow) 
				{
					editUniverseWindow->Lock();
					editUniverseWindow->buttons[DSN_PLANETWEAPON]->SetLabel(editThe[PLANETWEAPON_TYPE]);
					editUniverseWindow->bb->save->SetEnabled(true);
					editUniverseWindow->Unlock();
				}
				scg->nameStrGadget->SetText("");
				scg->nameStrGadget->MakeFocus();
				bb->save->SetEnabled(true);
				if (openingWindow) 
				{
					openingWindow->Lock();
					openingWindow->universeButton->SetLabel(editThe[UNIVERSE_TYPE]);
					openingWindow->createUniverseButton->SetEnabled(true);
					openingWindow->realUniverseButton->SetEnabled(true);
					openingWindow->Unlock();
				}
				planetWeapon->maintainable->EmptyList();
				planetWeapon->buildable->EmptyList();
				planetWeapon->doable->EmptyList();
			}
		}
	break;
	case SOI_BLSAVE:
		if (validate) ValidatePlanetWeapon();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdatePlanetWeapon();
			//RunSavePanel("universe", saveThe[UNIVERSE_TYPE], saveStr, cancelStr);
		}
	break;
	case SOI_BLPIC:
	
	break;
	case SOI_LOADUNIVERSEFROMPANEL:
		LoadPlanetWeapons("universe");//debug
		Quit();
	break;
	case SOI_BLLOAD:
		BMessage * bm = new BMessage(SOI_LOADUNIVERSEFROMPANEL);
		if (bm) break;//debug break;//debug be_app->RunFilePanel(loadThe[UNIVERSE_TYPE], loadStr, cancelStr, false, bm);
		else warning(failMemory);
	break;
	case SOI_BLNEXT:
		PlanetWeapon * nextPlanetWeapon = (PlanetWeapon *)((DataNode *)nextDNPtr)->data;
		if (validate) ValidatePlanetWeapon();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdatePlanetWeapon();
			planetWeaponCurrent = nextPlanetWeapon;
			planetWeapon->Copy(planetWeaponCurrent);
			scg->nameStrGadget->SetText(planetWeaponCurrent->name);
			thisDNPtr = dataListGlobal[PLANETWEAPON_TYPE]->NextPrevItems((void *)planetWeaponCurrent, &nextDNPtr, &prevDNPtr, bb);
		}
	break;
	default:
		BWindow::MessageReceived(message);
	break;
}
}//end

bool EditPlanetWeaponWindow::QuitRequested(void) 
{

if (strcmp(scg->nameStrGadget->Text(), "")) 
{
	if (planetWeaponCurrent) 
	{
		ValidatePlanetWeapon();
		if (err == NO_ERR) 
		{
			UpdatePlanetWeapon();
			if (err == NO_ERR) 
			{
				Quit();
				return(BWindow::QuitRequested());
			}
			else return false;
		}
		else return false;
	}
}
Quit();
return(BWindow::QuitRequested());
}//end


void EditPlanetWeaponWindow::ValidatePlanetWeapon(void) 
{

UniqueName(dataListGlobal[PLANETWEAPON_TYPE], scg->nameStrGadget->Text());
if (NO_UNIQUE == err) 
{
	warning(failNameUnique[PLANETWEAPON_TYPE]);
	return;
}
uint32 v, vp;

v = s2uint32(scg->vIntGadget->Text());
if (S2UIERR == err) 
{
	warning(SCGVolumeErr);
	return;
}
vp = s2uint32(scg->vperIntGadget->Text());
if (S2UIERR == err) 
{
	warning(SCGVolumePerErr);
	return;
}
planetWeapon->volume = v;
planetWeapon->vper = vp;
}//end


void EditPlanetWeaponWindow::UpdatePlanetWeapon(void) 
{

err = NO_ERR;
planetWeapon->mass = 0;
UIntPtrNode * node;
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)planetWeapon->buildable->elementPrimal->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	planetWeapon->mass += ((Element *)(node->data))->mass;
	planetWeapon->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)planetWeapon->buildable->compoundPrimal->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	planetWeapon->mass += ((Compound *)(node->data))->mass;
	planetWeapon->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)planetWeapon->buildable->elementManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	planetWeapon->mass += ((Element *)(node->data))->mass;
	planetWeapon->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)planetWeapon->buildable->compoundManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	planetWeapon->mass += ((Compound *)(node->data))->mass;
	planetWeapon->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)planetWeapon->buildable->planetWeaponManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	planetWeapon->mass += ((PlanetWeapon *)(node->data))->mass;
	planetWeapon->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)planetWeapon->buildable->factoryManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	planetWeapon->mass += ((Factory *)(node->data))->mass;
	planetWeapon->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)planetWeapon->buildable->engineManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	planetWeapon->mass += ((Engine *)(node->data))->mass;
	planetWeapon->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)planetWeapon->buildable->shipManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	planetWeapon->mass += ((Ship *)(node->data))->mass;
	planetWeapon->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)planetWeapon->buildable->shipShieldManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	planetWeapon->mass += ((ShipShield *)(node->data))->mass;
	planetWeapon->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)planetWeapon->buildable->shipWeaponManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	planetWeapon->mass += ((ShipWeapon *)(node->data))->mass;
	planetWeapon->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)planetWeapon->buildable->planetShieldManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	planetWeapon->mass += ((PlanetShield *)(node->data))->mass;
	planetWeapon->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)planetWeapon->buildable->planetWeaponManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	planetWeapon->mass += ((PlanetWeapon *)(node->data))->mass;
	planetWeapon->mass *= node->number;
}
if (planetWeaponCurrent) planetWeaponCurrent->Copy(planetWeapon);
}//end


void EditPlanetWeaponWindow::SavePlanetWeapons(const char * fileName) 
{

SaveUniverse(fileName);
}//end


void EditPlanetWeaponWindow::LoadPlanetWeapons(const char * fileName) 
{

LoadUniverse(fileName);
}//end
