//functions of EditGalaxyWindow soi0.1

#include "windowGuts.h"
#include "editGalaxyWindow.h"
#include "getFromList.h"
#include "saveLoadUniverse.h"
#include "titleWindow.h"
#include "designButtons.h"

void EditGalaxyWindow::SaveRequested(const char * fileName) 
{

SaveGalaxys(fileName);
}//end


EditGalaxyWindow::EditGalaxyWindow(BRect area, const char *title) : BWindow(area, title, B_TITLED_WINDOW, B_NOT_RESIZABLE|B_NOT_ZOOMABLE) 
{

editGalaxyWindow = this;
bb = new BottomButtons;
if (bb) 
{
	if (editUniverseWindow) 
	{
		editUniverseWindow->Lock();
		editUniverseWindow->buttons[DSN_GALAXY]->SetEnabled(false);
		editUniverseWindow->Unlock();
	}
}
else err = CREATEDNOTADDED;
if (!galaxyCurrent) if (dataListGlobal[GALAXY_TYPE]->list->CountItems()) galaxyCurrent = (Galaxy *)((DataNode *)dataListGlobal[GALAXY_TYPE]->list->ItemAt(0))->data;
}//end


EditGalaxyWindow::~EditGalaxyWindow() 
{

if (wIntGadget) 
{
	wIntGadget->RemoveSelf();
	delete wIntGadget;
}
if (hIntGadget) 
{
	hIntGadget->RemoveSelf();
	delete hIntGadget;
}
if (dIntGadget) 
{
	dIntGadget->RemoveSelf();
	delete dIntGadget;
}
if (bb) 
{
	if (editUniverseWindow) 
	{
		editUniverseWindow->Lock();
		editUniverseWindow->buttons[DSN_GALAXY]->SetEnabled(true);
		editUniverseWindow->Unlock();
	}
	delete bb;
}
editGalaxyWindow = NULL;
}//end


void EditGalaxyWindow::AddGalaxy(void) 
{

Galaxy * g = new Galaxy(galaxy, nameStrGadget->Text(), dataListGlobal[GALAXY_TYPE]);
if (g) 
{
	if (err != CREATED) 
	{
		delete g;
		return;
	}
}
else err = NO_GALAXY;
}//end


void EditGalaxyWindow::MessageReceived(BMessage *message) 
{

char prelimW[UINTSTRLEN];
char prelimH[UINTSTRLEN];
char prelimD[UINTSTRLEN];
bool validate = true;
if (!strcmp(nameStrGadget->Text(), "")) validate = false;

switch (message->what) 
{
	case SOI_NAME:
	case SOI_WGALAXY:
	case SOI_HGALAXY:
	case SOI_DGALAXY:
	
	break;
	case SOI_BLREMOVE:
		dataListGlobal[GALAXY_TYPE]->Remove();
		Quit();
	break;
	case SOI_BLLIST:
		GetFromList((void *)editGalaxyWindow, dataListGlobal[GALAXY_TYPE], nameStrGadget->Text());
	break;
	case SOI_BLLISTGOT:
		if (validate) ValidateGalaxy();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateGalaxy();
			galaxyCurrent = galaxyNewCurrent;
			SPRTF(prelimW, "%u", galaxyCurrent->width);
			SPRTF(prelimH, "%u", galaxyCurrent->height);
			SPRTF(prelimD, "%u", galaxyCurrent->depth);
			nameStrGadget->SetText(galaxyCurrent->name);
			wIntGadget->SetText(prelimW);
			hIntGadget->SetText(prelimH);
			dIntGadget->SetText(prelimD);
			thisDNPtr = dataListGlobal[GALAXY_TYPE]->NextPrevItems((void *)galaxyCurrent, &nextDNPtr, &prevDNPtr, bb);
			if (!bb->gnu) 
			{
				BRect gnuRect(154,bottom, 189,34);
				bb->gnu = new BButton(gnuRect, "", newStr, new BMessage(SOI_BLGNU));
				if (!bb->gnu) 
				{
					warning(failMemory);
					return;
				}
				AddChild(bb->gnu);
				bb->gnu->SetTarget(this);
				bb->add->SetLabel(removeStr);
				bb->add->SetMessage(new BMessage(SOI_BLREMOVE));
			}
		}
	break;
	case SOI_BLPREV:
		Galaxy * prevGalaxy = (Galaxy *)((DataNode *)prevDNPtr)->data;
		if (validate) ValidateGalaxy();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateGalaxy();
			galaxyCurrent = prevGalaxy;
			SPRTF(prelimW, "%u", galaxyCurrent->width);
			SPRTF(prelimH, "%u", galaxyCurrent->height);
			SPRTF(prelimD, "%u", galaxyCurrent->depth);
			nameStrGadget->SetText(galaxyCurrent->name);
			wIntGadget->SetText(prelimW);
			hIntGadget->SetText(prelimH);
			dIntGadget->SetText(prelimD);
			thisDNPtr = dataListGlobal[GALAXY_TYPE]->NextPrevItems((void *)galaxyCurrent, &nextDNPtr, &prevDNPtr, bb);
		}
	break;
	case SOI_BLDONE:
		if (!validate) 
		{
			Quit();
		}
		if (!strcmp(removeStr, bb->add->Label())) 
		{
			ValidateGalaxy();
			if (err == NO_ERR) 
			{
				UpdateGalaxy();
			}
		}
		if (err == NO_ERR) 
		{
			Quit();
		}
	break;
	case SOI_BLGNU:
		if (validate) ValidateGalaxy();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateGalaxy();
			galaxyCurrent = NULL;
			RemoveChild(bb->gnu);
			delete bb->gnu;
			bb->gnu = NULL;
			bb->add->SetLabel(addStr);
			bb->add->SetMessage(new BMessage(SOI_BLADD));
			nameStrGadget->SetText("");
			nameStrGadget->MakeFocus();
			wIntGadget->SetText("");
			hIntGadget->SetText("");
			dIntGadget->SetText("");
		}
	break;
	case SOI_BLADD:
		if (validate) ValidateGalaxy();
		else {
			err = NO_NAME;
			warning(everythingNamed);
		}//for add don't update
		if (err == NO_ERR) 
		{
			AddGalaxy();
			if (err) 
			{
				if (err != CREATEDNOTADDED) 
				{
					Quit();
				}
			}
			else {
				if (editUniverseWindow) 
				{
					editUniverseWindow->Lock();
					editUniverseWindow->buttons[DSN_GALAXY]->SetLabel(editThe[GALAXY_TYPE]);
					editUniverseWindow->bb->save->SetEnabled(true);
					editUniverseWindow->Unlock();
				}
				nameStrGadget->SetText("");
				nameStrGadget->MakeFocus();
				bb->save->SetEnabled(true);
				if (openingWindow) 
				{
					openingWindow->Lock();
					openingWindow->universeButton->SetLabel(editThe[UNIVERSE_TYPE]);
					openingWindow->createUniverseButton->SetEnabled(true);
					openingWindow->realUniverseButton->SetEnabled(true);
					openingWindow->Unlock();
				}
			}
		}
	break;
	case SOI_BLSAVE:
		if (validate) ValidateGalaxy();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateGalaxy();
			//RunSavePanel("universe", saveThe[UNIVERSE_TYPE], saveStr, cancelStr);
		}
	break;
	case SOI_BLPIC:
	
	break;
	case SOI_LOADUNIVERSEFROMPANEL:
		LoadGalaxys("universe");//debug
		Quit();
	break;
	case SOI_BLLOAD:
		BMessage * bm = new BMessage(SOI_LOADUNIVERSEFROMPANEL);
		if (bm) break;//debug break;//debug be_app->RunFilePanel(loadThe[UNIVERSE_TYPE], loadStr, cancelStr, false, bm);
		else warning(failMemory);
	break;
	case SOI_BLNEXT:
		Galaxy * nextGalaxy = (Galaxy *)((DataNode *)nextDNPtr)->data;
		if (validate) ValidateGalaxy();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateGalaxy();
			galaxyCurrent = nextGalaxy;
			SPRTF(prelimW, "%u", galaxyCurrent->width);
			SPRTF(prelimH, "%u", galaxyCurrent->height);
			SPRTF(prelimD, "%u", galaxyCurrent->depth);
			nameStrGadget->SetText(galaxyCurrent->name);
			wIntGadget->SetText(prelimW);
			hIntGadget->SetText(prelimH);
			dIntGadget->SetText(prelimD);
			thisDNPtr = dataListGlobal[GALAXY_TYPE]->NextPrevItems((void *)galaxyCurrent, &nextDNPtr, &prevDNPtr, bb);
		}
	break;
	default:
		BWindow::MessageReceived(message);
	break;
}
}//end


bool EditGalaxyWindow::QuitRequested(void) 
{

if (strcmp(nameStrGadget->Text(), "")) 
{
	if (galaxyCurrent) 
	{
		ValidateGalaxy();
		if (err == NO_ERR) 
		{
			UpdateGalaxy();
			if (err == NO_ERR) 
			{
				Quit();
				return(BWindow::QuitRequested());
			}
			else return false;
		}
		else return false;
	}
}
Quit();
return(BWindow::QuitRequested());
}//end


void EditGalaxyWindow::ValidateGalaxy(void) 
{

UniqueName(dataListGlobal[GALAXY_TYPE], nameStrGadget->Text());
if (NO_UNIQUE == err) 
{
	warning(failNameUnique[GALAXY_TYPE]);
	return;
}
uint32 w, h, d;
w = s2uint32(wIntGadget->Text());
if (S2UIERR == err) 
{
	warning(galaxyWErr);
	return;
}
h = s2uint32(hIntGadget->Text());
if (S2UIERR == err) 
{
	warning(galaxyHErr);
	return;
}
d = s2uint32(dIntGadget->Text());
if (S2UIERR == err) 
{
	warning(galaxyDErr);
	return;
}
galaxy->width = w;
galaxy->height = h;
galaxy->depth = d;
if (galaxy->name) 
{
	if (strcmp(galaxy->name, nameStrGadget->Text())) 
	{
		free(galaxy->name);
		galaxy->name = (char *)malloc(strlen(nameStrGadget->Text()) + 1);
		if (galaxy->name) strcpy(galaxy->name, nameStrGadget->Text());
		else {
			err = NO_NAME;
			warning(failName);
		}
	}
}
//debug must do object as well
}//end


void EditGalaxyWindow::UpdateGalaxy(void) 
{

err = NO_ERR;
if (galaxyCurrent) 
{
	if (strcmp(galaxyCurrent->name, nameStrGadget->Text())) 
	{
		if (galaxyCurrent->name) free(galaxyCurrent->name);
		galaxyCurrent->name = (char *)malloc(strlen(nameStrGadget->Text()) + 1);
		if (galaxyCurrent->name) strcpy(galaxyCurrent->name, nameStrGadget->Text());
		else {
			err = NO_NAME;
			warning(failName);
		}
	}
	//debug must do object as well
	galaxyCurrent->width = galaxy->width;
	galaxyCurrent->height = galaxy->height;
	galaxyCurrent->depth = galaxy->depth;
}
}//end


void EditGalaxyWindow::SaveGalaxys(const char * fileName) 
{

SaveUniverse(fileName);
}//end


void EditGalaxyWindow::LoadGalaxys(const char * fileName) 
{

LoadUniverse(fileName);
}//end
