//functions of EditFactoryWindow soi0.1

#include "windowGuts.h"
#include "editFactoryWindow.h"
#include "def.h"
#include "showSomeThings.h"
#include "getSomeThings.h"
#include "getFromList.h"
#include "saveLoadUniverse.h"
#include "titleWindow.h"
#include "designButtons.h"

void EditFactoryWindow::SaveRequested(const char * fileName) 
{

SaveFactorys(fileName);
}//end


EditFactoryWindow::EditFactoryWindow(BRect area, const char *title) : BWindow(area, title, B_TITLED_WINDOW, B_NOT_RESIZABLE|B_NOT_ZOOMABLE) 
{

err = NO_ERR;
orderButton = NULL;
bb = new BottomButtons;
if (bb) 
{
	if (editUniverseWindow) 
	{
		editUniverseWindow->Lock();
		editUniverseWindow->buttons[DSN_FACTORY]->SetEnabled(false);
		editUniverseWindow->Unlock();
	}
	db = new DoableButtons();
	if (db) 
	{
		maint = new DoableButtons();
		if (maint) 
		{
			scg = new SmallConstantsGadgets();
			if (scg) 
			{
				bld = new DoableButtons();
				if (!bld) err = CREATEDNOTADDED;
			}
			else err = CREATEDNOTADDED;
		}
		else err = CREATEDNOTADDED;
	}
	else err = CREATEDNOTADDED;
}
else err = CREATEDNOTADDED;
editFactoryWindow = this;
if (!factoryCurrent) if (dataListGlobal[FACTORY_TYPE]->list->CountItems()) factoryCurrent = (Factory *)((DataNode *)dataListGlobal[FACTORY_TYPE]->list->ItemAt(0))->data;
}//end


EditFactoryWindow::~EditFactoryWindow() 
{

if (bb) 
{
	if (editUniverseWindow) 
	{
		editUniverseWindow->Lock();
		editUniverseWindow->buttons[DSN_FACTORY]->SetEnabled(true);
		editUniverseWindow->Unlock();
	}
	delete bb;
}
if (bld) delete bld;
if (db) delete db;
if (maint) delete maint;
if (scg) delete scg;
if (orderButton) 
{
	orderButton->RemoveSelf();
	delete orderButton;
}
//if (kindButton) 
//{
//	kindButton->RemoveSelf();
//	delete kindButton;
//}
editFactoryWindow = NULL;
}//end


void EditFactoryWindow::AddFactory(void) 
{

Factory * item = new Factory(factory, scg->nameStrGadget->Text(), dataListGlobal[FACTORY_TYPE]);
if (item) 
{
	if (err != CREATED) 
	{
		delete item;
		return;
	}
}
else err = NO_FACTORY;
}//end


void EditFactoryWindow::MessageReceived(BMessage *message) 
{

bool validate = true;
int32 factorySize = sizeof factory;
if (!strcmp(scg->nameStrGadget->Text(), "")) validate = false;

switch (message->what) 
{
	case SOI_NAME:
	case SOI_VOLUME:
	case SOI_VPER:
	
	break;
	case SOI_MAINTAINABLEBUTTONLABEL:
		if (maint->showing) 
		{
			maint->label->SetLabel(selectMaintValue);
			maint->showing = false;
		}
		else {
			maint->label->SetLabel(showMaintValue);
			maint->showing = true;
		}
		maint->ResetMsg(message->what);
	break;
	case SOI_BUILDABLEBUTTONLABEL:
		if (bld->showing) 
		{
			bld->label->SetLabel(selectProdValue);
			bld->showing = false;
		}
		else {
			bld->label->SetLabel(showProdValue);
			bld->showing = true;
		}
		bld->ResetMsg(message->what);
	break;
	case SOI_DOABLEBUTTONLABEL:
		if (db->showing) 
		{
			db->label->SetLabel(selectConsumeValue);
			db->showing = false;
		}
		else {
			db->label->SetLabel(showConsumeValue);
			db->showing = true;
		}
		db->ResetMsg(message->what);
	break;
	case SOI_GETPOSSORDERS:
	
	break;
	case SOI_BUILDABLEBUTTONPRIMALELEMENTS:
		GetSomeThings(factory->buildable->elementPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], FACTORY_TYPE);
	break;
	case SOI_BUILDABLEBUTTONPRIMALCOMPOUNDS:
		GetSomeThings(factory->buildable->compoundPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], FACTORY_TYPE);
	break;
	case SOI_BUILDABLEBUTTONELEMENTS:
		GetSomeThings(factory->buildable->elementManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], FACTORY_TYPE);
	break;
	case SOI_BUILDABLEBUTTONCOMPOUNDS:
		GetSomeThings(factory->buildable->compoundManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], FACTORY_TYPE);
	break;
	case SOI_BUILDABLEBUTTONMINES:
		GetSomeThings(factory->buildable->mineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[MINE_TYPE], FACTORY_TYPE);
	break;
	case SOI_BUILDABLEBUTTONFACTORYS:
		GetSomeThings(factory->buildable->factoryManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[FACTORY_TYPE], FACTORY_TYPE);
	break;
	case SOI_BUILDABLEBUTTONENGINES:
		GetSomeThings(factory->buildable->engineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ENGINE_TYPE], FACTORY_TYPE);
	break;
	case SOI_BUILDABLEBUTTONSHIPS:
		GetSomeThings(factory->buildable->shipManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIP_TYPE], FACTORY_TYPE);
	break;
	case SOI_BUILDABLEBUTTONSSHIELDS:
		GetSomeThings(factory->buildable->shipShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SSHIELD_TYPE], FACTORY_TYPE);
	break;
	case SOI_BUILDABLEBUTTONSHIPWEAPONS:
		GetSomeThings(factory->buildable->shipWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIPWEAPON_TYPE], FACTORY_TYPE);
	break;
	case SOI_BUILDABLEBUTTONPLANETSHIELDS:
		GetSomeThings(factory->buildable->planetShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETSHIELD_TYPE], FACTORY_TYPE);
	break;
	case SOI_BUILDABLEBUTTONPLANETWEAPONS:
		GetSomeThings(factory->buildable->planetWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETWEAPON_TYPE], FACTORY_TYPE);
	break;
	case SOI_DOABLEBUTTONPRIMALELEMENTS:
		GetSomeThings(factory->doable->elementPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], FACTORY_TYPE);
	break;
	case SOI_DOABLEBUTTONPRIMALCOMPOUNDS:
		GetSomeThings(factory->doable->compoundPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], FACTORY_TYPE);
	break;
	case SOI_DOABLEBUTTONELEMENTS:
		GetSomeThings(factory->doable->elementManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], FACTORY_TYPE);
	break;
	case SOI_DOABLEBUTTONCOMPOUNDS:
		GetSomeThings(factory->doable->compoundManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], FACTORY_TYPE);
	break;
	case SOI_DOABLEBUTTONMINES:
		GetSomeThings(factory->doable->mineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[MINE_TYPE], FACTORY_TYPE);
	break;
	case SOI_DOABLEBUTTONFACTORYS:
		GetSomeThings(factory->doable->factoryManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[FACTORY_TYPE], FACTORY_TYPE);
	break;
	case SOI_DOABLEBUTTONENGINES:
		GetSomeThings(factory->doable->engineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ENGINE_TYPE], FACTORY_TYPE);
	break;
	case SOI_DOABLEBUTTONSHIPS:
		GetSomeThings(factory->doable->shipManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIP_TYPE], FACTORY_TYPE);
	break;
	case SOI_DOABLEBUTTONSSHIELDS:
		GetSomeThings(factory->doable->shipShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SSHIELD_TYPE], FACTORY_TYPE);
	break;
	case SOI_DOABLEBUTTONSHIPWEAPONS:
		GetSomeThings(factory->doable->shipWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIPWEAPON_TYPE], FACTORY_TYPE);
	break;
	case SOI_DOABLEBUTTONPLANETSHIELDS:
		GetSomeThings(factory->doable->planetShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETSHIELD_TYPE], FACTORY_TYPE);
	break;
	case SOI_DOABLEBUTTONPLANETWEAPONS:
		GetSomeThings(factory->doable->planetWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETWEAPON_TYPE], FACTORY_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONPRIMALELEMENTS:
		GetSomeThings(factory->maintainable->elementPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], FACTORY_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONPRIMALCOMPOUNDS:
		GetSomeThings(factory->maintainable->compoundPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], FACTORY_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONELEMENTS:
		GetSomeThings(factory->maintainable->elementManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], FACTORY_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONCOMPOUNDS:
		GetSomeThings(factory->maintainable->compoundManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], FACTORY_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONMINES:
		GetSomeThings(factory->maintainable->mineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[MINE_TYPE], FACTORY_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONFACTORYS:
		GetSomeThings(factory->maintainable->factoryManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[FACTORY_TYPE], FACTORY_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONENGINES:
		GetSomeThings(factory->maintainable->engineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ENGINE_TYPE], FACTORY_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONSHIPS:
		GetSomeThings(factory->maintainable->shipManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIP_TYPE], FACTORY_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONSSHIELDS:
		GetSomeThings(factory->maintainable->shipShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SSHIELD_TYPE], FACTORY_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONSHIPWEAPONS:
		GetSomeThings(factory->maintainable->shipWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIPWEAPON_TYPE], FACTORY_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONPLANETSHIELDS:
		GetSomeThings(factory->maintainable->planetShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETSHIELD_TYPE], FACTORY_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONPLANETWEAPONS:
		GetSomeThings(factory->maintainable->planetWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETWEAPON_TYPE], FACTORY_TYPE);
	break;
	case SOI_SHOWBUILDPRIMALELEMENTS:
		ShowSomeThings((const void *)&factory, factorySize, factoryCurrent->name, FACTORY_TYPE, factory->buildable->elementPrimal, scg->nameStrGadget->Text(), editFactoryWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWBUILDPRIMALCOMPOUNDS:
		ShowSomeThings((const void *)&factory, factorySize, factoryCurrent->name, FACTORY_TYPE, factory->buildable->compoundPrimal, scg->nameStrGadget->Text(), editFactoryWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWBUILDELEMENTS:
		ShowSomeThings((const void *)&factory, factorySize, factoryCurrent->name, FACTORY_TYPE, factory->buildable->elementManufactured, scg->nameStrGadget->Text(), editFactoryWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWBUILDCOMPOUNDS:
		ShowSomeThings((const void *)&factory, factorySize, factoryCurrent->name, FACTORY_TYPE, factory->buildable->compoundManufactured, scg->nameStrGadget->Text(), editFactoryWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWBUILDMINES:
		ShowSomeThings((const void *)&factory, factorySize, factoryCurrent->name, FACTORY_TYPE, factory->buildable->mineManufactured, scg->nameStrGadget->Text(), editFactoryWindow, dataListGlobal[MINE_TYPE]);
	break;
	case SOI_SHOWBUILDFACTORYS:
		ShowSomeThings((const void *)&factory, factorySize, factoryCurrent->name, FACTORY_TYPE, factory->buildable->factoryManufactured, scg->nameStrGadget->Text(), editFactoryWindow, dataListGlobal[FACTORY_TYPE]);
	break;
	case SOI_SHOWBUILDENGINES:
		ShowSomeThings((const void *)&factory, factorySize, factoryCurrent->name, FACTORY_TYPE, factory->buildable->engineManufactured, scg->nameStrGadget->Text(), editFactoryWindow, dataListGlobal[ENGINE_TYPE]);
	break;
	case SOI_SHOWBUILDSHIPS:
		ShowSomeThings((const void *)&factory, factorySize, factoryCurrent->name, FACTORY_TYPE, factory->buildable->shipManufactured, scg->nameStrGadget->Text(), editFactoryWindow, dataListGlobal[SHIP_TYPE]);
	break;
	case SOI_SHOWBUILDSSHIELDS:
		ShowSomeThings((const void *)&factory, factorySize, factoryCurrent->name, FACTORY_TYPE, factory->buildable->shipShieldManufactured, scg->nameStrGadget->Text(), editFactoryWindow, dataListGlobal[SSHIELD_TYPE]);
	break;
	case SOI_SHOWBUILDSHIPWEAPONS:
		ShowSomeThings((const void *)&factory, factorySize, factoryCurrent->name, FACTORY_TYPE, factory->buildable->shipWeaponManufactured, scg->nameStrGadget->Text(), editFactoryWindow, dataListGlobal[SHIPWEAPON_TYPE]);
	break;
	case SOI_SHOWBUILDPLANETSHIELDS:
		ShowSomeThings((const void *)&factory, factorySize, factoryCurrent->name, FACTORY_TYPE, factory->buildable->planetShieldManufactured, scg->nameStrGadget->Text(), editFactoryWindow, dataListGlobal[PLANETSHIELD_TYPE]);
	break;
	case SOI_SHOWBUILDPLANETWEAPONS:
		ShowSomeThings((const void *)&factory, factorySize, factoryCurrent->name, FACTORY_TYPE, factory->buildable->planetWeaponManufactured, scg->nameStrGadget->Text(), editFactoryWindow, dataListGlobal[PLANETWEAPON_TYPE]);
	break;
	case SOI_SHOWDOPRIMALELEMENTS:
		ShowSomeThings((const void *)&factory, factorySize, factoryCurrent->name, FACTORY_TYPE, factory->doable->elementPrimal, scg->nameStrGadget->Text(), editFactoryWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWDOPRIMALCOMPOUNDS:
		ShowSomeThings((const void *)&factory, factorySize, factoryCurrent->name, FACTORY_TYPE, factory->doable->compoundPrimal, scg->nameStrGadget->Text(), editFactoryWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWDOELEMENTS:
		ShowSomeThings((const void *)&factory, factorySize, factoryCurrent->name, FACTORY_TYPE, factory->doable->elementManufactured, scg->nameStrGadget->Text(), editFactoryWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWDOCOMPOUNDS:
		ShowSomeThings((const void *)&factory, factorySize, factoryCurrent->name, FACTORY_TYPE, factory->doable->compoundManufactured, scg->nameStrGadget->Text(), editFactoryWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWDOMINES:
		ShowSomeThings((const void *)&factory, factorySize, factoryCurrent->name, FACTORY_TYPE, factory->doable->mineManufactured, scg->nameStrGadget->Text(), editFactoryWindow, dataListGlobal[MINE_TYPE]);
	break;
	case SOI_SHOWDOFACTORYS:
		ShowSomeThings((const void *)&factory, factorySize, factoryCurrent->name, FACTORY_TYPE, factory->doable->factoryManufactured, scg->nameStrGadget->Text(), editFactoryWindow, dataListGlobal[FACTORY_TYPE]);
	break;
	case SOI_SHOWDOENGINES:
		ShowSomeThings((const void *)&factory, factorySize, factoryCurrent->name, FACTORY_TYPE, factory->doable->engineManufactured, scg->nameStrGadget->Text(), editFactoryWindow, dataListGlobal[ENGINE_TYPE]);
	break;
	case SOI_SHOWDOSHIPS:
		ShowSomeThings((const void *)&factory, factorySize, factoryCurrent->name, FACTORY_TYPE, factory->doable->shipManufactured, scg->nameStrGadget->Text(), editFactoryWindow, dataListGlobal[SHIP_TYPE]);
	break;
	case SOI_SHOWDOSSHIELDS:
		ShowSomeThings((const void *)&factory, factorySize, factoryCurrent->name, FACTORY_TYPE, factory->doable->shipShieldManufactured, scg->nameStrGadget->Text(), editFactoryWindow, dataListGlobal[SSHIELD_TYPE]);
	break;
	case SOI_SHOWDOSHIPWEAPONS:
		ShowSomeThings((const void *)&factory, factorySize, factoryCurrent->name, FACTORY_TYPE, factory->doable->shipWeaponManufactured, scg->nameStrGadget->Text(), editFactoryWindow, dataListGlobal[SHIPWEAPON_TYPE]);
	break;
	case SOI_SHOWDOPLANETSHIELDS:
		ShowSomeThings((const void *)&factory, factorySize, factoryCurrent->name, FACTORY_TYPE, factory->doable->planetShieldManufactured, scg->nameStrGadget->Text(), editFactoryWindow, dataListGlobal[PLANETSHIELD_TYPE]);
	break;
	case SOI_SHOWDOPLANETWEAPONS:
		ShowSomeThings((const void *)&factory, factorySize, factoryCurrent->name, FACTORY_TYPE, factory->doable->planetWeaponManufactured, scg->nameStrGadget->Text(), editFactoryWindow, dataListGlobal[PLANETWEAPON_TYPE]);
	break;
	case SOI_SHOWMAINTPRIMALELEMENTS:
		ShowSomeThings((const void *)&factory, factorySize, factoryCurrent->name, FACTORY_TYPE, factory->maintainable->elementPrimal, scg->nameStrGadget->Text(), editFactoryWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWMAINTPRIMALCOMPOUNDS:
		ShowSomeThings((const void *)&factory, factorySize, factoryCurrent->name, FACTORY_TYPE, factory->maintainable->compoundPrimal, scg->nameStrGadget->Text(), editFactoryWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWMAINTELEMENTS:
		ShowSomeThings((const void *)&factory, factorySize, factoryCurrent->name, FACTORY_TYPE, factory->maintainable->elementManufactured, scg->nameStrGadget->Text(), editFactoryWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWMAINTCOMPOUNDS:
		ShowSomeThings((const void *)&factory, factorySize, factoryCurrent->name, FACTORY_TYPE, factory->maintainable->compoundManufactured, scg->nameStrGadget->Text(), editFactoryWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWMAINTMINES:
		ShowSomeThings((const void *)&factory, factorySize, factoryCurrent->name, FACTORY_TYPE, factory->maintainable->mineManufactured, scg->nameStrGadget->Text(), editFactoryWindow, dataListGlobal[MINE_TYPE]);
	break;
	case SOI_SHOWMAINTFACTORYS:
		ShowSomeThings((const void *)&factory, factorySize, factoryCurrent->name, FACTORY_TYPE, factory->maintainable->factoryManufactured, scg->nameStrGadget->Text(), editFactoryWindow, dataListGlobal[FACTORY_TYPE]);
	break;
	case SOI_SHOWMAINTENGINES:
		ShowSomeThings((const void *)&factory, factorySize, factoryCurrent->name, FACTORY_TYPE, factory->maintainable->engineManufactured, scg->nameStrGadget->Text(), editFactoryWindow, dataListGlobal[ENGINE_TYPE]);
	break;
	case SOI_SHOWMAINTSHIPS:
		ShowSomeThings((const void *)&factory, factorySize, factoryCurrent->name, FACTORY_TYPE, factory->maintainable->shipManufactured, scg->nameStrGadget->Text(), editFactoryWindow, dataListGlobal[SHIP_TYPE]);
	break;
	case SOI_SHOWMAINTSSHIELDS:
		ShowSomeThings((const void *)&factory, factorySize, factoryCurrent->name, FACTORY_TYPE, factory->maintainable->shipShieldManufactured, scg->nameStrGadget->Text(), editFactoryWindow, dataListGlobal[SSHIELD_TYPE]);
	break;
	case SOI_SHOWMAINTSHIPWEAPONS:
		ShowSomeThings((const void *)&factory, factorySize, factoryCurrent->name, FACTORY_TYPE, factory->maintainable->shipWeaponManufactured, scg->nameStrGadget->Text(), editFactoryWindow, dataListGlobal[SHIPWEAPON_TYPE]);
	break;
	case SOI_SHOWMAINTPLANETSHIELDS:
		ShowSomeThings((const void *)&factory, factorySize, factoryCurrent->name, FACTORY_TYPE, factory->maintainable->planetShieldManufactured, scg->nameStrGadget->Text(), editFactoryWindow, dataListGlobal[PLANETSHIELD_TYPE]);
	break;
	case SOI_SHOWMAINTPLANETWEAPONS:
		ShowSomeThings((const void *)&factory, factorySize, factoryCurrent->name, FACTORY_TYPE, factory->maintainable->planetWeaponManufactured, scg->nameStrGadget->Text(), editFactoryWindow, dataListGlobal[PLANETWEAPON_TYPE]);
	break;
	case SOI_BLREMOVE:
		dataListGlobal[FACTORY_TYPE]->Remove();
		Quit();
	break;
	case SOI_BLLIST:
		GetFromList((void *)editFactoryWindow, dataListGlobal[FACTORY_TYPE], scg->nameStrGadget->Text());
	break;
	case SOI_BLLISTGOT:
		if (validate) ValidateFactory();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateFactory();
			factoryCurrent = factoryNewCurrent;
			factory->Copy(factoryCurrent);
			scg->nameStrGadget->SetText(factoryCurrent->name);
			thisDNPtr = dataListGlobal[FACTORY_TYPE]->NextPrevItems((void *)factoryCurrent, &nextDNPtr, &prevDNPtr, bb);
			if (!bb->gnu) 
			{
				BRect gnuRect(154,bottom, 189,34);
				bb->gnu = new BButton(gnuRect, "", newStr, new BMessage(SOI_BLGNU));
				AddChild(bb->gnu);
				bb->gnu->SetTarget(this);
				bb->add->SetLabel(removeStr);
				bb->add->SetMessage(new BMessage(SOI_BLREMOVE));
			}
		}
	break;
	case SOI_BLPREV:
		Factory * prevFactory = (Factory *)((DataNode *)prevDNPtr)->data;
		if (validate) ValidateFactory();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateFactory();
			factoryCurrent = prevFactory;
			factory->Copy(factoryCurrent);
			scg->nameStrGadget->SetText(factoryCurrent->name);
			thisDNPtr = dataListGlobal[FACTORY_TYPE]->NextPrevItems((void *)factoryCurrent, &nextDNPtr, &prevDNPtr, bb);
		}
	break;
	case SOI_BLDONE:
		if (!validate) 
		{
			Quit();
		}
		if (!strcmp(removeStr, bb->add->Label())) 
		{
			ValidateFactory();
			if (err == NO_ERR) 
			{
				UpdateFactory();
			}
		}
		if (err == NO_ERR) 
		{
			Quit();
		}
	break;
	case SOI_BLGNU:
		if (validate) ValidateFactory();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateFactory();
			factoryCurrent = NULL;
			RemoveChild(bb->gnu);
			delete bb->gnu;
			bb->gnu = NULL;
			bb->add->SetLabel(addStr);
			bb->add->SetMessage(new BMessage(SOI_BLADD));
			scg->nameStrGadget->SetText("");
			scg->nameStrGadget->MakeFocus();
		}
	break;
	case SOI_BLADD:
		if (validate) ValidateFactory();
		else {
			err = NO_NAME;
			warning(everythingNamed);
		}//for add don't update
		if (err == NO_ERR) 
		{
			AddFactory();
			if (err) 
			{
				if (err != CREATEDNOTADDED) 
				{
					Quit();
				}
			}
			else {
				if (editUniverseWindow) 
				{
					editUniverseWindow->Lock();
					editUniverseWindow->buttons[DSN_FACTORY]->SetLabel(editThe[FACTORY_TYPE]);
					editUniverseWindow->bb->save->SetEnabled(true);
					editUniverseWindow->Unlock();
				}
				scg->nameStrGadget->SetText("");
				scg->nameStrGadget->MakeFocus();
				bb->save->SetEnabled(true);
				if (openingWindow) 
				{
					openingWindow->Lock();
					openingWindow->universeButton->SetLabel(editThe[UNIVERSE_TYPE]);
					openingWindow->createUniverseButton->SetEnabled(true);
					openingWindow->realUniverseButton->SetEnabled(true);
					openingWindow->Unlock();
				}
				factory->maintainable->EmptyList();
				factory->buildable->EmptyList();
				factory->doable->EmptyList();
			}
		}
	break;
	case SOI_BLSAVE:
		if (validate) ValidateFactory();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateFactory();
			//RunSavePanel("universe", saveThe[UNIVERSE_TYPE], saveStr, cancelStr);
		}
	break;
	case SOI_BLPIC:
	
	break;
	case SOI_LOADUNIVERSEFROMPANEL:
		LoadFactorys("universe");//debug
		Quit();
	break;
	case SOI_BLLOAD:
		BMessage * bm = new BMessage(SOI_LOADUNIVERSEFROMPANEL);
		if (bm) break;//debug break;//debug be_app->RunFilePanel(loadThe[UNIVERSE_TYPE], loadStr, cancelStr, false, bm);
		else warning(failMemory);
	break;
	case SOI_BLNEXT:
		Factory * nextFactory = (Factory *)((DataNode *)nextDNPtr)->data;
		if (validate) ValidateFactory();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateFactory();
			factoryCurrent = nextFactory;
			factory->Copy(factoryCurrent);
			scg->nameStrGadget->SetText(factoryCurrent->name);
			thisDNPtr = dataListGlobal[FACTORY_TYPE]->NextPrevItems((void *)factoryCurrent, &nextDNPtr, &prevDNPtr, bb);
		}
	break;
	default:
		BWindow::MessageReceived(message);
	break;
}
}//end

bool EditFactoryWindow::QuitRequested(void) 
{

if (strcmp(scg->nameStrGadget->Text(), "")) 
{
	if (factoryCurrent) 
	{
		ValidateFactory();
		if (err == NO_ERR) 
		{
			UpdateFactory();
			if (err == NO_ERR) 
			{
				Quit();
				return(BWindow::QuitRequested());
			}
			else return false;
		}
		else return false;
	}
}
Quit();
return(BWindow::QuitRequested());
}//end


void EditFactoryWindow::ValidateFactory(void) 
{

UniqueName(dataListGlobal[FACTORY_TYPE], scg->nameStrGadget->Text());
if (NO_UNIQUE == err) 
{
	warning(failNameUnique[FACTORY_TYPE]);
	return;
}
uint32 v, vp;

v = s2uint32(scg->vIntGadget->Text());
if (S2UIERR == err) 
{
	warning(SCGVolumeErr);
	return;
}
vp = s2uint32(scg->vperIntGadget->Text());
if (S2UIERR == err) 
{
	warning(SCGVolumePerErr);
	return;
}
factory->volume = v;
factory->vper = vp;
}//end


void EditFactoryWindow::UpdateFactory(void) 
{

err = NO_ERR;
factory->mass = 0;
UIntPtrNode * node;
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)factory->buildable->elementPrimal->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	factory->mass += ((Element *)(node->data))->mass;
	factory->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)factory->buildable->compoundPrimal->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	factory->mass += ((Compound *)(node->data))->mass;
	factory->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)factory->buildable->elementManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	factory->mass += ((Element *)(node->data))->mass;
	factory->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)factory->buildable->compoundManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	factory->mass += ((Compound *)(node->data))->mass;
	factory->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)factory->buildable->factoryManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	factory->mass += ((Factory *)(node->data))->mass;
	factory->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)factory->buildable->factoryManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	factory->mass += ((Factory *)(node->data))->mass;
	factory->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)factory->buildable->engineManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	factory->mass += ((Engine *)(node->data))->mass;
	factory->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)factory->buildable->shipManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	factory->mass += ((Ship *)(node->data))->mass;
	factory->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)factory->buildable->shipShieldManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	factory->mass += ((ShipShield *)(node->data))->mass;
	factory->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)factory->buildable->shipWeaponManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	factory->mass += ((ShipWeapon *)(node->data))->mass;
	factory->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)factory->buildable->planetShieldManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	factory->mass += ((PlanetShield *)(node->data))->mass;
	factory->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)factory->buildable->planetWeaponManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	factory->mass += ((PlanetWeapon *)(node->data))->mass;
	factory->mass *= node->number;
}
if (factoryCurrent) factoryCurrent->Copy(factory);
}//end


void EditFactoryWindow::SaveFactorys(const char * fileName) 
{

SaveUniverse(fileName);
}//end


void EditFactoryWindow::LoadFactorys(const char * fileName) 
{

LoadUniverse(fileName);
}//end
