//functions of EditEngineWindow soi0.1

#include "windowGuts.h"
#include "editEngineWindow.h"
#include "def.h"
#include "s2f.h"
#include "getFromList.h"
#include "showSomeThings.h"
#include "getSomeThings.h"
#include "saveLoadUniverse.h"
#include "titleWindow.h"
#include "designButtons.h"

void EditEngineWindow::SaveRequested(const char * fileName) 
{

SaveEngines(fileName);
}//end


EditEngineWindow::EditEngineWindow(BRect area, const char *title) : BWindow(area, title, B_TITLED_WINDOW, B_NOT_RESIZABLE|B_NOT_ZOOMABLE) 
{

err = NO_ERR;
orderButton = NULL;
kindButton = NULL;
bb = new BottomButtons;
if (bb) 
{
	if (editUniverseWindow) 
	{
		editUniverseWindow->Lock();
		editUniverseWindow->buttons[DSN_ENGINE]->SetEnabled(false);
		editUniverseWindow->Unlock();
	}
	db = new DoableButtons();
	if (db) 
	{
		maint = new DoableButtons();
		if (maint) 
		{
			scg = new SmallConstantsGadgets();
			if (scg) 
			{
				bld = new DoableButtons();
				if (!bld) err = CREATEDNOTADDED;
			}
			else err = CREATEDNOTADDED;
		}
		else err = CREATEDNOTADDED;
	}
	else err = CREATEDNOTADDED;
}
else err = CREATEDNOTADDED;
editEngineWindow = this;
if (!engineCurrent) if (dataListGlobal[ENGINE_TYPE]->list->CountItems()) engineCurrent = (Engine *)((DataNode *)dataListGlobal[ENGINE_TYPE]->list->ItemAt(0))->data;
}//end


EditEngineWindow::~EditEngineWindow() 
{

if (bb) 
{
	if (editUniverseWindow) 
	{
		editUniverseWindow->Lock();
		editUniverseWindow->buttons[DSN_ENGINE]->SetEnabled(true);
		editUniverseWindow->Unlock();
	}
	delete bb;
}
if (bld) delete bld;
if (db) delete db;
if (maint) delete maint;
if (scg) delete scg;
if (orderButton) 
{
	orderButton->RemoveSelf();
	delete orderButton;
}
if (kindButton) 
{
	kindButton->RemoveSelf();
	delete kindButton;
}
editEngineWindow = NULL;
}//end


void EditEngineWindow::AddEngine(void) 
{

Engine * item = new Engine(engine, scg->nameStrGadget->Text(), dataListGlobal[ENGINE_TYPE]);
if (item) 
{
	if (err != CREATED) 
	{
		delete item;
		return;
	}
}
else err = NO_ENGINE;
}//end


void EditEngineWindow::MessageReceived(BMessage *message) 
{

bool validate = true;
int32 engineSize = sizeof engineCurrent;
if (!strcmp(scg->nameStrGadget->Text(), "")) validate = false;

switch (message->what) 
{
	case SOI_NAME:
	case SOI_VOLUME:
	case SOI_VPER:
	
	break;
	case SOI_MAINTAINABLEBUTTONLABEL:
		if (maint->showing) 
		{
			maint->label->SetLabel(selectMaintValue);
			maint->showing = false;
		}
		else {
			maint->label->SetLabel(showMaintValue);
			maint->showing = true;
		}
		maint->ResetMsg(message->what);
	break;
	case SOI_BUILDABLEBUTTONLABEL:
		if (bld->showing) 
		{
			bld->label->SetLabel(selectProdValue);
			bld->showing = false;
		}
		else {
			bld->label->SetLabel(showProdValue);
			bld->showing = true;
		}
		bld->ResetMsg(message->what);
	break;
	case SOI_DOABLEBUTTONLABEL:
		if (db->showing) 
		{
			db->label->SetLabel(selectConsumeValue);
			db->showing = false;
		}
		else {
			db->label->SetLabel(showConsumeValue);
			db->showing = true;
		}
		db->ResetMsg(message->what);
	break;
	case SOI_GETPOSSORDERS:
	
	break;
	case SOI_BUILDABLEBUTTONPRIMALELEMENTS:
		GetSomeThings(engine->buildable->elementPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], ENGINE_TYPE);
	break;
	case SOI_BUILDABLEBUTTONPRIMALCOMPOUNDS:
		GetSomeThings(engine->buildable->compoundPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], ENGINE_TYPE);
	break;
	case SOI_BUILDABLEBUTTONELEMENTS:
		GetSomeThings(engine->buildable->elementManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], ENGINE_TYPE);
	break;
	case SOI_BUILDABLEBUTTONCOMPOUNDS:
		GetSomeThings(engine->buildable->compoundManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], ENGINE_TYPE);
	break;
	case SOI_BUILDABLEBUTTONMINES:
		GetSomeThings(engine->buildable->mineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[MINE_TYPE], ENGINE_TYPE);
	break;
	case SOI_BUILDABLEBUTTONFACTORYS:
		GetSomeThings(engine->buildable->factoryManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[FACTORY_TYPE], ENGINE_TYPE);
	break;
	case SOI_BUILDABLEBUTTONENGINES:
		GetSomeThings(engine->buildable->engineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ENGINE_TYPE], ENGINE_TYPE);
	break;
	case SOI_BUILDABLEBUTTONSHIPS:
		GetSomeThings(engine->buildable->shipManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIP_TYPE], ENGINE_TYPE);
	break;
	case SOI_BUILDABLEBUTTONSSHIELDS:
		GetSomeThings(engine->buildable->shipShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SSHIELD_TYPE], ENGINE_TYPE);
	break;
	case SOI_BUILDABLEBUTTONSHIPWEAPONS:
		GetSomeThings(engine->buildable->shipWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIPWEAPON_TYPE], ENGINE_TYPE);
	break;
	case SOI_BUILDABLEBUTTONPLANETSHIELDS:
		GetSomeThings(engine->buildable->planetShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETSHIELD_TYPE], ENGINE_TYPE);
	break;
	case SOI_BUILDABLEBUTTONPLANETWEAPONS:
		GetSomeThings(engine->buildable->planetWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETWEAPON_TYPE], ENGINE_TYPE);
	break;
	case SOI_DOABLEBUTTONPRIMALELEMENTS:
		GetSomeThings(engine->doable->elementPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], ENGINE_TYPE);
	break;
	case SOI_DOABLEBUTTONPRIMALCOMPOUNDS:
		GetSomeThings(engine->doable->compoundPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], ENGINE_TYPE);
	break;
	case SOI_DOABLEBUTTONELEMENTS:
		GetSomeThings(engine->doable->elementManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], ENGINE_TYPE);
	break;
	case SOI_DOABLEBUTTONCOMPOUNDS:
		GetSomeThings(engine->doable->compoundManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], ENGINE_TYPE);
	break;
	case SOI_DOABLEBUTTONMINES:
		GetSomeThings(engine->doable->mineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[MINE_TYPE], ENGINE_TYPE);
	break;
	case SOI_DOABLEBUTTONFACTORYS:
		GetSomeThings(engine->doable->factoryManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[FACTORY_TYPE], ENGINE_TYPE);
	break;
	case SOI_DOABLEBUTTONENGINES:
		GetSomeThings(engine->doable->engineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ENGINE_TYPE], ENGINE_TYPE);
	break;
	case SOI_DOABLEBUTTONSHIPS:
		GetSomeThings(engine->doable->shipManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIP_TYPE], ENGINE_TYPE);
	break;
	case SOI_DOABLEBUTTONSSHIELDS:
		GetSomeThings(engine->doable->shipShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SSHIELD_TYPE], ENGINE_TYPE);
	break;
	case SOI_DOABLEBUTTONSHIPWEAPONS:
		GetSomeThings(engine->doable->shipWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIPWEAPON_TYPE], ENGINE_TYPE);
	break;
	case SOI_DOABLEBUTTONPLANETSHIELDS:
		GetSomeThings(engine->doable->planetShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETSHIELD_TYPE], ENGINE_TYPE);
	break;
	case SOI_DOABLEBUTTONPLANETWEAPONS:
		GetSomeThings(engine->doable->planetWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETWEAPON_TYPE], ENGINE_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONPRIMALELEMENTS:
		GetSomeThings(engine->maintainable->elementPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], ENGINE_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONPRIMALCOMPOUNDS:
		GetSomeThings(engine->maintainable->compoundPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], ENGINE_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONELEMENTS:
		GetSomeThings(engine->maintainable->elementManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], ENGINE_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONCOMPOUNDS:
		GetSomeThings(engine->maintainable->compoundManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], ENGINE_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONMINES:
		GetSomeThings(engine->maintainable->mineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[MINE_TYPE], ENGINE_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONFACTORYS:
		GetSomeThings(engine->maintainable->factoryManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[FACTORY_TYPE], ENGINE_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONENGINES:
		GetSomeThings(engine->maintainable->engineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ENGINE_TYPE], ENGINE_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONSHIPS:
		GetSomeThings(engine->maintainable->shipManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIP_TYPE], ENGINE_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONSSHIELDS:
		GetSomeThings(engine->maintainable->shipShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SSHIELD_TYPE], ENGINE_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONSHIPWEAPONS:
		GetSomeThings(engine->maintainable->shipWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIPWEAPON_TYPE], ENGINE_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONPLANETSHIELDS:
		GetSomeThings(engine->maintainable->planetShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETSHIELD_TYPE], ENGINE_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONPLANETWEAPONS:
		GetSomeThings(engine->maintainable->planetWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETWEAPON_TYPE], ENGINE_TYPE);
	break;
	case SOI_SHOWBUILDPRIMALELEMENTS:
		ShowSomeThings((const void *)&engine, engineSize, engineCurrent->name, ENGINE_TYPE, engine->buildable->elementPrimal, scg->nameStrGadget->Text(), editEngineWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWBUILDPRIMALCOMPOUNDS:
		ShowSomeThings((const void *)&engine, engineSize, engineCurrent->name, ENGINE_TYPE, engine->buildable->compoundPrimal, scg->nameStrGadget->Text(), editEngineWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWBUILDELEMENTS:
		ShowSomeThings((const void *)&engine, engineSize, engineCurrent->name, ENGINE_TYPE, engine->buildable->elementManufactured, scg->nameStrGadget->Text(), editEngineWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWBUILDCOMPOUNDS:
		ShowSomeThings((const void *)&engine, engineSize, engineCurrent->name, ENGINE_TYPE, engine->buildable->compoundManufactured, scg->nameStrGadget->Text(), editEngineWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWBUILDMINES:
		ShowSomeThings((const void *)&engine, engineSize, engineCurrent->name, ENGINE_TYPE, engine->buildable->mineManufactured, scg->nameStrGadget->Text(), editEngineWindow, dataListGlobal[MINE_TYPE]);
	break;
	case SOI_SHOWBUILDFACTORYS:
		ShowSomeThings((const void *)&engine, engineSize, engineCurrent->name, ENGINE_TYPE, engine->buildable->factoryManufactured, scg->nameStrGadget->Text(), editEngineWindow, dataListGlobal[FACTORY_TYPE]);
	break;
	case SOI_SHOWBUILDENGINES:
		ShowSomeThings((const void *)&engine, engineSize, engineCurrent->name, ENGINE_TYPE, engine->buildable->engineManufactured, scg->nameStrGadget->Text(), editEngineWindow, dataListGlobal[ENGINE_TYPE]);
	break;
	case SOI_SHOWBUILDSHIPS:
		ShowSomeThings((const void *)&engine, engineSize, engineCurrent->name, ENGINE_TYPE, engine->buildable->shipManufactured, scg->nameStrGadget->Text(), editEngineWindow, dataListGlobal[SHIP_TYPE]);
	break;
	case SOI_SHOWBUILDSSHIELDS:
		ShowSomeThings((const void *)&engine, engineSize, engineCurrent->name, ENGINE_TYPE, engine->buildable->shipShieldManufactured, scg->nameStrGadget->Text(), editEngineWindow, dataListGlobal[SSHIELD_TYPE]);
	break;
	case SOI_SHOWBUILDSHIPWEAPONS:
		ShowSomeThings((const void *)&engine, engineSize, engineCurrent->name, ENGINE_TYPE, engine->buildable->shipWeaponManufactured, scg->nameStrGadget->Text(), editEngineWindow, dataListGlobal[SHIPWEAPON_TYPE]);
	break;
	case SOI_SHOWBUILDPLANETSHIELDS:
		ShowSomeThings((const void *)&engine, engineSize, engineCurrent->name, ENGINE_TYPE, engine->buildable->planetShieldManufactured, scg->nameStrGadget->Text(), editEngineWindow, dataListGlobal[PLANETSHIELD_TYPE]);
	break;
	case SOI_SHOWBUILDPLANETWEAPONS:
		ShowSomeThings((const void *)&engine, engineSize, engineCurrent->name, ENGINE_TYPE, engine->buildable->planetWeaponManufactured, scg->nameStrGadget->Text(), editEngineWindow, dataListGlobal[PLANETWEAPON_TYPE]);
	break;
	case SOI_SHOWDOPRIMALELEMENTS:
		ShowSomeThings((const void *)&engine, engineSize, engineCurrent->name, ENGINE_TYPE, engine->doable->elementPrimal, scg->nameStrGadget->Text(), editEngineWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWDOPRIMALCOMPOUNDS:
		ShowSomeThings((const void *)&engine, engineSize, engineCurrent->name, ENGINE_TYPE, engine->doable->compoundPrimal, scg->nameStrGadget->Text(), editEngineWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWDOELEMENTS:
		ShowSomeThings((const void *)&engine, engineSize, engineCurrent->name, ENGINE_TYPE, engine->doable->elementManufactured, scg->nameStrGadget->Text(), editEngineWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWDOCOMPOUNDS:
		ShowSomeThings((const void *)&engine, engineSize, engineCurrent->name, ENGINE_TYPE, engine->doable->compoundManufactured, scg->nameStrGadget->Text(), editEngineWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWDOMINES:
		ShowSomeThings((const void *)&engine, engineSize, engineCurrent->name, ENGINE_TYPE, engine->doable->mineManufactured, scg->nameStrGadget->Text(), editEngineWindow, dataListGlobal[MINE_TYPE]);
	break;
	case SOI_SHOWDOFACTORYS:
		ShowSomeThings((const void *)&engine, engineSize, engineCurrent->name, ENGINE_TYPE, engine->doable->factoryManufactured, scg->nameStrGadget->Text(), editEngineWindow, dataListGlobal[FACTORY_TYPE]);
	break;
	case SOI_SHOWDOENGINES:
		ShowSomeThings((const void *)&engine, engineSize, engineCurrent->name, ENGINE_TYPE, engine->doable->engineManufactured, scg->nameStrGadget->Text(), editEngineWindow, dataListGlobal[ENGINE_TYPE]);
	break;
	case SOI_SHOWDOSHIPS:
		ShowSomeThings((const void *)&engine, engineSize, engineCurrent->name, ENGINE_TYPE, engine->doable->shipManufactured, scg->nameStrGadget->Text(), editEngineWindow, dataListGlobal[SHIP_TYPE]);
	break;
	case SOI_SHOWDOSSHIELDS:
		ShowSomeThings((const void *)&engine, engineSize, engineCurrent->name, ENGINE_TYPE, engine->doable->shipShieldManufactured, scg->nameStrGadget->Text(), editEngineWindow, dataListGlobal[SSHIELD_TYPE]);
	break;
	case SOI_SHOWDOSHIPWEAPONS:
		ShowSomeThings((const void *)&engine, engineSize, engineCurrent->name, ENGINE_TYPE, engine->doable->shipWeaponManufactured, scg->nameStrGadget->Text(), editEngineWindow, dataListGlobal[SHIPWEAPON_TYPE]);
	break;
	case SOI_SHOWDOPLANETSHIELDS:
		ShowSomeThings((const void *)&engine, engineSize, engineCurrent->name, ENGINE_TYPE, engine->doable->planetShieldManufactured, scg->nameStrGadget->Text(), editEngineWindow, dataListGlobal[PLANETSHIELD_TYPE]);
	break;
	case SOI_SHOWDOPLANETWEAPONS:
		ShowSomeThings((const void *)&engine, engineSize, engineCurrent->name, ENGINE_TYPE, engine->doable->planetWeaponManufactured, scg->nameStrGadget->Text(), editEngineWindow, dataListGlobal[PLANETWEAPON_TYPE]);
	break;
	case SOI_SHOWMAINTPRIMALELEMENTS:
		ShowSomeThings((const void *)&engine, engineSize, engineCurrent->name, ENGINE_TYPE, engine->maintainable->elementPrimal, scg->nameStrGadget->Text(), editEngineWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWMAINTPRIMALCOMPOUNDS:
		ShowSomeThings((const void *)&engine, engineSize, engineCurrent->name, ENGINE_TYPE, engine->maintainable->compoundPrimal, scg->nameStrGadget->Text(), editEngineWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWMAINTELEMENTS:
		ShowSomeThings((const void *)&engine, engineSize, engineCurrent->name, ENGINE_TYPE, engine->maintainable->elementManufactured, scg->nameStrGadget->Text(), editEngineWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWMAINTCOMPOUNDS:
		ShowSomeThings((const void *)&engine, engineSize, engineCurrent->name, ENGINE_TYPE, engine->maintainable->compoundManufactured, scg->nameStrGadget->Text(), editEngineWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWMAINTMINES:
		ShowSomeThings((const void *)&engine, engineSize, engineCurrent->name, ENGINE_TYPE, engine->maintainable->mineManufactured, scg->nameStrGadget->Text(), editEngineWindow, dataListGlobal[MINE_TYPE]);
	break;
	case SOI_SHOWMAINTFACTORYS:
		ShowSomeThings((const void *)&engine, engineSize, engineCurrent->name, ENGINE_TYPE, engine->maintainable->factoryManufactured, scg->nameStrGadget->Text(), editEngineWindow, dataListGlobal[FACTORY_TYPE]);
	break;
	case SOI_SHOWMAINTENGINES:
		ShowSomeThings((const void *)&engine, engineSize, engineCurrent->name, ENGINE_TYPE, engine->maintainable->engineManufactured, scg->nameStrGadget->Text(), editEngineWindow, dataListGlobal[ENGINE_TYPE]);
	break;
	case SOI_SHOWMAINTSHIPS:
		ShowSomeThings((const void *)&engine, engineSize, engineCurrent->name, ENGINE_TYPE, engine->maintainable->shipManufactured, scg->nameStrGadget->Text(), editEngineWindow, dataListGlobal[SHIP_TYPE]);
	break;
	case SOI_SHOWMAINTSSHIELDS:
		ShowSomeThings((const void *)&engine, engineSize, engineCurrent->name, ENGINE_TYPE, engine->maintainable->shipShieldManufactured, scg->nameStrGadget->Text(), editEngineWindow, dataListGlobal[SSHIELD_TYPE]);
	break;
	case SOI_SHOWMAINTSHIPWEAPONS:
		ShowSomeThings((const void *)&engine, engineSize, engineCurrent->name, ENGINE_TYPE, engine->maintainable->shipWeaponManufactured, scg->nameStrGadget->Text(), editEngineWindow, dataListGlobal[SHIPWEAPON_TYPE]);
	break;
	case SOI_SHOWMAINTPLANETSHIELDS:
		ShowSomeThings((const void *)&engine, engineSize, engineCurrent->name, ENGINE_TYPE, engine->maintainable->planetShieldManufactured, scg->nameStrGadget->Text(), editEngineWindow, dataListGlobal[PLANETSHIELD_TYPE]);
	break;
	case SOI_SHOWMAINTPLANETWEAPONS:
		ShowSomeThings((const void *)&engine, engineSize, engineCurrent->name, ENGINE_TYPE, engine->maintainable->planetWeaponManufactured, scg->nameStrGadget->Text(), editEngineWindow, dataListGlobal[PLANETWEAPON_TYPE]);
	break;
	case SOI_BLREMOVE:
		dataListGlobal[ENGINE_TYPE]->Remove();
		Quit();
	break;
	case SOI_BLLIST:
		GetFromList((void *)editEngineWindow, dataListGlobal[ENGINE_TYPE], scg->nameStrGadget->Text());
	break;
	case SOI_BLLISTGOT:
		if (validate) ValidateEngine();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateEngine();
			engineCurrent = engineNewCurrent;
			engine->maintainable->Copy(engineCurrent->maintainable);
			engine->buildable->Copy(engineCurrent->buildable);
			engine->doable->Copy(engineCurrent->doable);
			engine->possibleOrders = engineCurrent->possibleOrders;
			scg->nameStrGadget->SetText(engineCurrent->name);
			thisDNPtr = dataListGlobal[ENGINE_TYPE]->NextPrevItems((void *)engineCurrent, &nextDNPtr, &prevDNPtr, bb);
			if (!bb->gnu) 
			{
				BRect gnuRect(154,bottom, 189,34);
				bb->gnu = new BButton(gnuRect, "", newStr, new BMessage(SOI_BLGNU));
				AddChild(bb->gnu);
				bb->gnu->SetTarget(this);
				bb->add->SetLabel(removeStr);
				bb->add->SetMessage(new BMessage(SOI_BLREMOVE));
			}
		}
	break;
	case SOI_BLPREV:
		Engine * prevEngine = (Engine *)((DataNode *)prevDNPtr)->data;
		if (validate) ValidateEngine();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateEngine();
			engineCurrent = prevEngine;
			engine->maintainable->Copy(engineCurrent->maintainable);
			engine->buildable->Copy(engineCurrent->buildable);
			engine->doable->Copy(engineCurrent->doable);
			engine->possibleOrders = engineCurrent->possibleOrders;
			scg->nameStrGadget->SetText(engineCurrent->name);
			thisDNPtr = dataListGlobal[ENGINE_TYPE]->NextPrevItems((void *)engineCurrent, &nextDNPtr, &prevDNPtr, bb);
		}
	break;
	case SOI_BLDONE:
		if (!validate) 
		{
			Quit();
		}
		if (!strcmp(removeStr, bb->add->Label())) 
		{
			ValidateEngine();
			if (err == NO_ERR) 
			{
				UpdateEngine();
			}
		}
		if (err == NO_ERR) 
		{
			Quit();
		}
	break;
	case SOI_BLGNU:
		if (validate) ValidateEngine();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateEngine();
			engineCurrent = NULL;
			RemoveChild(bb->gnu);
			delete bb->gnu;
			bb->gnu = NULL;
			bb->add->SetLabel(addStr);
			bb->add->SetMessage(new BMessage(SOI_BLADD));
			scg->nameStrGadget->SetText("");
			scg->nameStrGadget->MakeFocus();
		}
	break;
	case SOI_BLADD:
		if (validate) ValidateEngine();
		else {
			err = NO_NAME;
			warning(everythingNamed);
		}//for add don't update
		if (err == NO_ERR) 
		{
			AddEngine();
			if (err) 
			{
				if (err != CREATEDNOTADDED) 
				{
					Quit();
				}
			}
			else {
				if (editUniverseWindow) 
				{
					editUniverseWindow->Lock();
					editUniverseWindow->buttons[DSN_ENGINE]->SetLabel(editThe[ENGINE_TYPE]);
					editUniverseWindow->bb->save->SetEnabled(true);
				}
				editUniverseWindow->Unlock();
				scg->nameStrGadget->SetText("");
				scg->nameStrGadget->MakeFocus();
				bb->save->SetEnabled(true);
				if (openingWindow) 
				{
					openingWindow->Lock();
					openingWindow->universeButton->SetLabel(editThe[UNIVERSE_TYPE]);
					openingWindow->createUniverseButton->SetEnabled(true);
					openingWindow->realUniverseButton->SetEnabled(true);
					openingWindow->Unlock();
				}
				engine->maintainable->EmptyList();
				engine->buildable->EmptyList();
				engine->doable->EmptyList();
			}
		}
	break;
	case SOI_BLSAVE:
		if (validate) ValidateEngine();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateEngine();
			//RunSavePanel("universe", saveThe[UNIVERSE_TYPE], saveStr, cancelStr);
		}
	break;
	case SOI_BLPIC:
	
	break;
	case SOI_LOADUNIVERSEFROMPANEL:
		LoadEngines("universe");//debug
		Quit();
	break;
	case SOI_BLLOAD:
		BMessage * bm = new BMessage(SOI_LOADUNIVERSEFROMPANEL);
		if (bm) break;//debug break;//debug be_app->RunFilePanel(loadThe[UNIVERSE_TYPE], loadStr, cancelStr, false, bm);
		else warning(failMemory);
	break;
	case SOI_BLNEXT:
		Engine * nextEngine = (Engine *)((DataNode *)nextDNPtr)->data;
		if (validate) ValidateEngine();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateEngine();
			engineCurrent = nextEngine;
			engine->maintainable->Copy(engineCurrent->maintainable);
			engine->buildable->Copy(engineCurrent->buildable);
			engine->doable->Copy(engineCurrent->doable);
			engine->possibleOrders = engineCurrent->possibleOrders;
			scg->nameStrGadget->SetText(engineCurrent->name);
			thisDNPtr = dataListGlobal[ENGINE_TYPE]->NextPrevItems((void *)engineCurrent, &nextDNPtr, &prevDNPtr, bb);
		}
	break;
	default:
		BWindow::MessageReceived(message);
	break;
}
}//end

bool EditEngineWindow::QuitRequested(void) 
{

if (strcmp(scg->nameStrGadget->Text(), "")) 
{
	if (engineCurrent) 
	{
		ValidateEngine();
		if (err == NO_ERR) 
		{
			UpdateEngine();
			if (err == NO_ERR) 
			{
				Quit();
				return(BWindow::QuitRequested());
			}
			else return false;
		}
		else return false;
	}
}
Quit();
return(BWindow::QuitRequested());
}//end


void EditEngineWindow::ValidateEngine(void) 
{

UniqueName(dataListGlobal[ENGINE_TYPE], scg->nameStrGadget->Text());
if (NO_UNIQUE == err) 
{
	warning(failNameUnique[ENGINE_TYPE]);
	return;
}
uint32 v, vp;

v = s2uint32(scg->vIntGadget->Text());
if (S2UIERR == err) 
{
	warning(SCGVolumeErr);
	return;
}
vp = s2uint32(scg->vperIntGadget->Text());
if (S2UIERR == err) 
{
	warning(SCGVolumePerErr);
	return;
}
engine->volume = v;
engine->vper = vp;
}//end


void EditEngineWindow::UpdateEngine(void) 
{

err = NO_ERR;
engine->mass = 0;
UIntPtrNode * node;
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)engine->buildable->elementPrimal->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	engine->mass += ((Element *)(node->data))->mass;
	engine->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)engine->buildable->compoundPrimal->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	engine->mass += ((Compound *)(node->data))->mass;
	engine->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)engine->buildable->elementManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	engine->mass += ((Element *)(node->data))->mass;
	engine->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)engine->buildable->compoundManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	engine->mass += ((Compound *)(node->data))->mass;
	engine->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)engine->buildable->engineManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	engine->mass += ((Engine *)(node->data))->mass;
	engine->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)engine->buildable->factoryManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	engine->mass += ((Factory *)(node->data))->mass;
	engine->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)engine->buildable->engineManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	engine->mass += ((Engine *)(node->data))->mass;
	engine->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)engine->buildable->shipManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	engine->mass += ((Ship *)(node->data))->mass;
	engine->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)engine->buildable->shipShieldManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	engine->mass += ((ShipShield *)(node->data))->mass;
	engine->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)engine->buildable->shipWeaponManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	engine->mass += ((ShipWeapon *)(node->data))->mass;
	engine->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)engine->buildable->planetShieldManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	engine->mass += ((PlanetShield *)(node->data))->mass;
	engine->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)engine->buildable->planetWeaponManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	engine->mass += ((PlanetWeapon *)(node->data))->mass;
	engine->mass *= node->number;
}
if (engineCurrent) 
{
	if (strcmp(engineCurrent->name, scg->nameStrGadget->Text())) 
	{
		if (engineCurrent->name) free(engineCurrent->name);
		engineCurrent->name = (char *)malloc(strlen(scg->nameStrGadget->Text()) + 1);
		if (engineCurrent->name) strcpy(engineCurrent->name, scg->nameStrGadget->Text());
		else {
			err = NO_NAME;
			warning(failName);
		}
	}
	engineCurrent->doable->Copy(engine->doable);
	engineCurrent->maintainable->Copy(engine->maintainable);
	engineCurrent->buildable->Copy(engine->buildable);
	engineCurrent->possibleOrders = engine->possibleOrders;
	//debug must do object as well
	engineCurrent->mass = engine->mass;
	engineCurrent->volume = engine->volume;
	engineCurrent->vper = engine->vper;
}
}//end


void EditEngineWindow::SaveEngines(const char * fileName) 
{

SaveUniverse(fileName);
}//end


void EditEngineWindow::LoadEngines(const char * fileName) 
{

LoadUniverse(fileName);
}//end
