//functions of EditElementWindow soi0.1

#include "windowGuts.h"
#include "editElementWindow.h"
#include "getFromList.h"
#include "myStringDrawer.h"
#include "fileHeaders.h"
#include "titleWindow.h"
#include "designButtons.h"

void EditElementWindow::SaveRequested(const char * fileName) 
{

SaveElements(fileName);
}//end


EditElementWindow::EditElementWindow(BRect area, const char *title) : BWindow(area, title, B_TITLED_WINDOW, B_NOT_RESIZABLE|B_NOT_ZOOMABLE), nameStrGadget(NULL), strView(NULL), eIntGadget(NULL), nIntGadget(NULL), pIntGadget(NULL), vIntGadget(NULL), vperIn
tGadget(NULL) 
{

bb = new BottomButtons;
if (bb) 
{
	if (editUniverseWindow) 
	{
		editUniverseWindow->Lock();
		editUniverseWindow->buttons[DFLT_ELEMENT]->SetEnabled(false);
		editUniverseWindow->buttons[DSN_ELEMENT]->SetEnabled(false);
		editUniverseWindow->buttons[LOAD_ELEMENT]->SetEnabled(false);
		editUniverseWindow->Unlock();
	}
}
else err = CREATEDNOTADDED;
editElementWindow = this;
if (!elementCurrent) if (dataListGlobal[ELEMENT_TYPE]->list->CountItems()) elementCurrent = (Element *)((DataNode *)dataListGlobal[ELEMENT_TYPE]->list->ItemAt(0))->data;
}//end


EditElementWindow::~EditElementWindow() 
{

if (nameStrGadget) 
{
	nameStrGadget->RemoveSelf();
	delete nameStrGadget;
}
if (eIntGadget) 
{
	eIntGadget->RemoveSelf();
	delete eIntGadget;
}
if (nIntGadget) 
{
	nIntGadget->RemoveSelf();
	delete nIntGadget;
}
if (pIntGadget) 
{
	pIntGadget->RemoveSelf();
	delete pIntGadget;
}
if (vIntGadget) 
{
	vIntGadget->RemoveSelf();
	delete vIntGadget;
}
if (vperIntGadget) 
{
	vperIntGadget->RemoveSelf();
	delete vperIntGadget;
}
if (strView) 
{
	strView->RemoveSelf();
	delete (strView);
}
if (bb) 
{
	if (editUniverseWindow) 
	{
		editUniverseWindow->Lock();
		editUniverseWindow->buttons[DFLT_ELEMENT]->SetEnabled(true);
		editUniverseWindow->buttons[DSN_ELEMENT]->SetEnabled(true);
		editUniverseWindow->buttons[LOAD_ELEMENT]->SetEnabled(true);
		editUniverseWindow->Unlock();
	}
	delete bb;
}
editElementWindow = NULL;
}//end


void EditElementWindow::AddElement(void) 
{

Element * e = new Element(element, nameStrGadget->Text(), dataListGlobal[ELEMENT_TYPE]);
if (e) 
{
	if (err != CREATED) 
	{
		delete e;
		return;
	}
}
else err = NO_ELEMENT;
}//end


void EditElementWindow::MessageReceived(BMessage *message) 
{

char prelimElectron[UINTSTRLEN];
char prelimNeutron[UINTSTRLEN];
char prelimProton[UINTSTRLEN];
char prelimVolume[UINTSTRLEN];
char prelimVPer[UINTSTRLEN];
bool validate = true;
if (!strcmp(nameStrGadget->Text(), "")) validate = false;

switch (message->what) 
{
	case SOI_ELECTRONELEMENT:
	case SOI_NEUTRONELEMENT:
	case SOI_NELEMENT:
	case SOI_NAME:
	case SOI_VOLUME:
	case SOI_VPER:
	
	break;
	case SOI_BLREMOVE:
		dataListGlobal[ELEMENT_TYPE]->Remove();
		Quit();
	break;
	case SOI_BLLIST:
		GetFromList((void *)editElementWindow, dataListGlobal[ELEMENT_TYPE], nameStrGadget->Text());
	break;
	case SOI_BLLISTGOT:
		if (validate) ValidateElement();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateElement();
			elementCurrent = elementNewCurrent;
			SPRTF(prelimElectron, "%u", elementCurrent->electron);
			SPRTF(prelimNeutron, "%u", elementCurrent->neutron);
			SPRTF(prelimProton, "%u", elementCurrent->proton);
			SPRTF(prelimVolume, "%u", elementCurrent->volume);
			SPRTF(prelimVPer, "%u", elementCurrent->vper);
			nameStrGadget->SetText(elementCurrent->name);
			eIntGadget->SetText(prelimElectron);
			nIntGadget->SetText(prelimNeutron);
			pIntGadget->SetText(prelimProton);
			vIntGadget->SetText(prelimVolume);
			vperIntGadget->SetText(prelimVPer);
			thisDNPtr = dataListGlobal[ELEMENT_TYPE]->NextPrevItems((void *)elementCurrent, &nextDNPtr, &prevDNPtr, bb);
			if (!bb->gnu) 
			{
				BRect gnuRect(154,bottom, 189,34);
				bb->gnu = new BButton(gnuRect, "", newStr, new BMessage(SOI_BLGNU));
				if (!bb->gnu) 
				{
					warning(failMemory);
					return;
				}
				AddChild(bb->gnu);
				bb->gnu->SetTarget(this);
				bb->add->SetLabel(removeStr);
				bb->add->SetMessage(new BMessage(SOI_BLREMOVE));
			}
		}
	break;
	case SOI_BLPREV:
		Element * prevElement = (Element *)((DataNode *)prevDNPtr)->data;
		if (validate) ValidateElement();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateElement();
			elementCurrent = prevElement;
			SPRTF(prelimElectron, "%u", elementCurrent->electron);
			SPRTF(prelimNeutron, "%u", elementCurrent->neutron);
			SPRTF(prelimProton, "%u", elementCurrent->proton);
			SPRTF(prelimVolume, "%u", elementCurrent->volume);
			SPRTF(prelimVPer, "%u", elementCurrent->vper);
			nameStrGadget->SetText(elementCurrent->name);
			eIntGadget->SetText(prelimElectron);
			nIntGadget->SetText(prelimNeutron);
			pIntGadget->SetText(prelimProton);
			vIntGadget->SetText(prelimVolume);
			vperIntGadget->SetText(prelimVPer);
			thisDNPtr = dataListGlobal[ELEMENT_TYPE]->NextPrevItems((void *)elementCurrent, &nextDNPtr, &prevDNPtr, bb);
		}
	break;
	case SOI_BLDONE:
		if (!validate) 
		{
			Quit();
		}
		if (!strcmp(removeStr, bb->add->Label())) 
		{
			ValidateElement();
			if (err == NO_ERR) 
			{
				UpdateElement();
			}
		}
		if (err == NO_ERR) 
		{
			Quit();
		}
	break;
	case SOI_BLGNU:
		if (validate) ValidateElement();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateElement();
			elementCurrent = NULL;
			RemoveChild(bb->gnu);
			delete bb->gnu;
			bb->gnu = NULL;
			bb->add->SetLabel(addStr);
			bb->add->SetMessage(new BMessage(SOI_BLADD));
			nameStrGadget->SetText("");
			nameStrGadget->MakeFocus();
			eIntGadget->SetText("");
			nIntGadget->SetText("");
			pIntGadget->SetText("");
			vIntGadget->SetText("");
			vperIntGadget->SetText("");
		}
	break;
	case SOI_BLADD:
		if (validate) ValidateElement();
		else {
			err = NO_NAME;
			warning(everythingNamed);
		}//for add don't update
		if (err == NO_ERR) 
		{
			AddElement();
			if (err) 
			{
				if (err != CREATEDNOTADDED) 
				{
					Quit();
				}
			}
			else {
				if (editUniverseWindow) 
				{
					editUniverseWindow->Lock();
					editUniverseWindow->buttons[DSN_ELEMENT]->SetLabel(editThe[ELEMENT_TYPE]);
					editUniverseWindow->bb->save->SetEnabled(true);
					editUniverseWindow->Unlock();
				}
				nameStrGadget->SetText("");
				nameStrGadget->MakeFocus();
				bb->save->SetEnabled(true);
				if (openingWindow) 
				{
					openingWindow->Lock();
					openingWindow->universeButton->SetLabel(editThe[UNIVERSE_TYPE]);
					openingWindow->createUniverseButton->SetEnabled(true);
					openingWindow->realUniverseButton->SetEnabled(true);
					openingWindow->Unlock();
				}
			}
		}
	break;
	case SOI_BLSAVE:
		if (validate) ValidateElement();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateElement();
			//RunSavePanel("elements", saveThe[ELEMENT_TYPE], saveStr, cancelStr);
		}
	break;
	case SOI_BLPIC:
	
	break;
	case SOI_LOADELEMENTFROMPANEL:
		LoadElements("elements");//debug
		Quit();
	break;
	case SOI_BLLOAD:
		BMessage * bm = new BMessage(SOI_LOADELEMENTFROMPANEL);
		if (bm) break; //debug break;//debug be_app->RunFilePanel(loadThe[ELEMENT_TYPE], loadStr, cancelStr, false, bm);
		else warning(failMemory);
	break;
	case SOI_BLNEXT:
		Element * nextElement = (Element *)((DataNode *)nextDNPtr)->data;
		if (validate) ValidateElement();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateElement();
			elementCurrent = nextElement;
			SPRTF(prelimElectron, "%u", elementCurrent->electron);
			SPRTF(prelimNeutron, "%u", elementCurrent->neutron);
			SPRTF(prelimProton, "%u", elementCurrent->proton);
			SPRTF(prelimVolume, "%u", elementCurrent->volume);
			SPRTF(prelimVPer, "%u", elementCurrent->vper);
			nameStrGadget->SetText(elementCurrent->name);
			eIntGadget->SetText(prelimElectron);
			nIntGadget->SetText(prelimNeutron);
			pIntGadget->SetText(prelimProton);
			vIntGadget->SetText(prelimVolume);
			vperIntGadget->SetText(prelimVPer);
			thisDNPtr = dataListGlobal[ELEMENT_TYPE]->NextPrevItems((void *)elementCurrent, &nextDNPtr, &prevDNPtr, bb);
		}
	break;
	default:
		BWindow::MessageReceived(message);
	break;
}
}//end

bool EditElementWindow::QuitRequested(void) 
{

if (strcmp(nameStrGadget->Text(), "")) 
{
	if (elementCurrent) 
	{
		ValidateElement();
		if (err == NO_ERR) 
		{
			UpdateElement();
			if (err == NO_ERR) 
			{
				Quit();
				return(BWindow::QuitRequested());
			}
			else return false;
		}
		else return false;
	}
}
Quit();
return(BWindow::QuitRequested());
}//end


void EditElementWindow::ValidateElement(void) 
{

UniqueName(dataListGlobal[ELEMENT_TYPE], nameStrGadget->Text());
if (NO_UNIQUE == err) 
{
	warning(failNameUnique[ELEMENT_TYPE]);
	return;
}
uint32 n, p, e, v, vp;

e = s2uint32(eIntGadget->Text());
if (S2UIERR == err) 
{
	warning(eListElectronErr);
	return;
}
n = s2uint32(nIntGadget->Text());
if (S2UIERR == err) 
{
	warning(eListNeutronErr);
	return;
}
p = s2uint32(pIntGadget->Text());
if (S2UIERR == err) 
{
	warning(eListProtonErr);
	return;
}
v = s2uint32(vIntGadget->Text());
if (S2UIERR == err) 
{
	warning(SCGVolumeErr);
	return;
}
vp = s2uint32(vperIntGadget->Text());
if (S2UIERR == err) 
{
	warning(SCGVolumePerErr);
	return;
}
element->electron = e;
element->neutron = n;
element->proton = p;
element->volume = v;
element->vper = vp;
//debug comment
//element->mass = (e * universe->electronMass) + (n * universe->neutronMass) + (p * universe->protonMass);
if (element->name) 
{
	if (strcmp(element->name, nameStrGadget->Text())) 
	{
		free(element->name);
		element->name = (char *)malloc(strlen(nameStrGadget->Text()) + 1);
		if (element->name) strcpy(element->name, nameStrGadget->Text());
		else {
			err = NO_NAME;
			warning(failName);
		}
	}
}
//debug must do object as well
}//end


void EditElementWindow::UpdateElement(void) 
{

err = NO_ERR;
if (elementCurrent) elementCurrent->Copy(element);
}//end


void EditElementWindow::SaveElements(const char * fileName) 
{

//BVolume volu;
//char nme[B_OS_NAME_LENGTH];
//int32 cnt = 0;
//bool doit = true;
//bool fileOpened = true;
////debug volu = volume_at(cnt);
//BFile * theFile = new BFile;
//
//if (!theFile) 
//{
//	warning(failMemory);
//	return;
//}
//while (doit) 
//{
//	if (volu.Error() != B_NO_ERROR) break;
//	volu.GetName(nme);
//	if (!strcmp(nme, "flopp")) 
//	{
//		BDirectory rootDir;
//		volu.GetRootDirectory(&rootDir);
//		rootDir.Create(fileName, theFile);
//		theFile->Open(B_EXCLUSIVE);
//		if (theFile->Error() != B_NO_ERROR) 
//		{
//			fileOpened = false;
//			warning(badFileNoOpen);
//		}
//	}
//	volu = volume_at(++cnt);
//	if (volu.Error() != B_NO_ERROR) 
//	{
//		doit = false;
//	}
//}
//if (fileOpened) 
//{
//	Element * saveme;
//	int32 num = dataListGlobal[ELEMENT_TYPE]->list->CountItems();
//	if (num) 
//	{
//		DataNode * node;
//		if (!PutFileHeader(ELEMENT_TYPE, num, theFile)) 
//		{
//			warning(noSave);
//			theFile->Close();
//			delete theFile;
//			return;
//		}
//		#pragma warn_possunwant off
//		for (int32 i = 0; node = (DataNode *)dataListGlobal[ELEMENT_TYPE]->list->ItemAt(i); i++) 
//		{
//		#pragma warn_possunwant reset
//			saveme = (Element *)node->data;
//			if (!(saveme->Save(theFile))) 
//			{
//				warning(noSave);
//				theFile->Close();
//				delete theFile;
//				return;
//			}
//		}
//	}
//	else warning(nothingToSave[ELEMENT_TYPE]);
//	theFile->Close();
//}
//delete theFile;
}//end


void EditElementWindow::LoadElements(const char * fileName) 
{

/*debug never called??*/warning("really called");
//BVolume volu;
//char nme[B_OS_NAME_LENGTH];
//int32 cnt = 0;
//bool doit = true;
////debug volu = volume_at(cnt);
//BFile * theFile = new BFile;
//int32 numCompounds, numElements;
//
//if (!theFile) 
//{
//	warning(failMemory);
//	return;
//}
//while (doit) 
//{
//	if (volu.Error() != B_NO_ERROR) break;
//	volu.GetName(nme);
//	if (!strcmp(nme, "flopp")) 
//	{
//		BDirectory rootDir;
//		volu.GetRootDirectory(&rootDir);
//		rootDir.GetFile(fileName, theFile);
//	}
//	volu = volume_at(++cnt);
//	if (volu.Error() != B_NO_ERROR) 
//	{
//		doit = false;
//	}
//}
//theFile->Open(B_READ_ONLY);
//if (theFile->Error() != B_NO_ERROR) 
//{
//	warning(badFileNoOpen);
//	delete theFile;
//	return;
//}
//MergeList * tempMergeList = new MergeList(ELEMENT_TYPE);
//if (!tempMergeList) 
//{
//	warning(failMergeList);
//	theFile->Close();
//	delete theFile;
//	return;
//}
//if (!StripFileHeaderPre(theFile)) 
//{
//	delete tempMergeList;
//	warning(noLoad);
//	theFile->Close();
//	delete theFile;
//	return;
//
//}
//if (!StripFileHeader(ELEMENT_TYPE, theFile, &numElements)) 
//{
//	delete tempMergeList;
//	warning(noLoad);
//	theFile->Close();
//	delete theFile;
//	return;
//}
//Element e;
//for (int32 i = 0; i < numElements; i++) 
//{
//	if (e.Load(theFile)) 
//	{
//		Element * newElement = new Element(&e, tempMergeList);
//		if (!newElement) 
//		{
//			warning(failCreate[ELEMENT_TYPE]);
//			i = numElements;
//		}
//		else if (err != CREATED) i = numElements;
//	}
//	else i = numElements;
//}
//dataListGlobal[ELEMENT_TYPE]->Merge(tempMergeList);
//delete tempMergeList;
//theFile->Close();
//delete theFile;
}//end
