//functions of EditBlackholeWindow soi0.1

#include "windowGuts.h"
#include "editBlackholeWindow.h"
#include "getFromList.h"
#include "saveLoadUniverse.h"
#include "titleWindow.h"
#include "designButtons.h"

void EditBlackholeWindow::SaveRequested(const char * fileName) 
{

SaveBlackholes(fileName);
}//end


EditBlackholeWindow::EditBlackholeWindow(BRect area, const char *title) : BWindow(area, title, B_TITLED_WINDOW, B_NOT_RESIZABLE|B_NOT_ZOOMABLE) 
{

editBlackholeWindow = this;
bb = new BottomButtons;
if (bb) 
{
	if (editUniverseWindow) 
	{
		editUniverseWindow->Lock();
		editUniverseWindow->buttons[DSN_BLACKHOLE]->SetEnabled(false);
		editUniverseWindow->Unlock();
	}
	BMessage * bmOrder = new BMessage(SOI_BLACKHOLEGETPOSSAFFECTS);
	if (bmOrder) 
	{
		BRect orderRect(210,355, 390,389);
		affectButton = new BButton(orderRect, "", getPossAffectStr, bmOrder);
	}
	else err = CREATEDNOTADDED;
}
else err = CREATEDNOTADDED;
if (!blackholeCurrent) if (dataListGlobal[BLACKHOLE_TYPE]->list->CountItems()) blackholeCurrent = (Blackhole *)((DataNode *)dataListGlobal[BLACKHOLE_TYPE]->list->ItemAt(0))->data;
}//end


EditBlackholeWindow::~EditBlackholeWindow() 
{

if (bb) 
{
	if (editUniverseWindow) 
	{
		editUniverseWindow->Lock();
		editUniverseWindow->buttons[DSN_BLACKHOLE]->SetEnabled(true);
		editUniverseWindow->Unlock();
	}
	delete bb;
}
if (affectButton) 
{
	affectButton->RemoveSelf();
	delete affectButton;
}
editBlackholeWindow = NULL;
}//end


void EditBlackholeWindow::AddBlackhole(void) 
{

Blackhole * g = new Blackhole(blackhole, nameStrGadget->Text(), dataListGlobal[BLACKHOLE_TYPE]);
if (g) 
{
	if (err != CREATED) 
	{
		delete g;
		return;
	}
}
else err = NO_BLACKHOLE;
}//end


void EditBlackholeWindow::MessageReceived(BMessage *message) 
{

bool validate = true;
if (!strcmp(nameStrGadget->Text(), "")) validate = false;

switch (message->what) 
{
	case SOI_NAME:
	case SOI_BLACKHOLEGETPOSSAFFECTS:
	
	break;
	case SOI_BLREMOVE:
		dataListGlobal[BLACKHOLE_TYPE]->Remove();
		Quit();
	break;
	case SOI_BLLIST:
		GetFromList((void *)editBlackholeWindow, dataListGlobal[BLACKHOLE_TYPE], nameStrGadget->Text());
	break;
	case SOI_BLLISTGOT:
		if (validate) ValidateBlackhole();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateBlackhole();
			blackholeCurrent = blackholeNewCurrent;
			nameStrGadget->SetText(blackholeCurrent->name);
			thisDNPtr = dataListGlobal[BLACKHOLE_TYPE]->NextPrevItems((void *)blackholeCurrent, &nextDNPtr, &prevDNPtr, bb);
			if (!bb->gnu) 
			{
				BRect gnuRect(154,bottom, 189,34);
				bb->gnu = new BButton(gnuRect, "", newStr, new BMessage(SOI_BLGNU));
				if (!bb->gnu) 
				{
					warning(failMemory);
					return;
				}
				AddChild(bb->gnu);
				bb->gnu->SetTarget(this);
				bb->add->SetLabel(removeStr);
				bb->add->SetMessage(new BMessage(SOI_BLREMOVE));
			}
		}
	break;
	case SOI_BLPREV:
		Blackhole * prevBlackhole = (Blackhole *)((DataNode *)prevDNPtr)->data;
		if (validate) ValidateBlackhole();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateBlackhole();
			blackholeCurrent = prevBlackhole;
			nameStrGadget->SetText(blackholeCurrent->name);
			thisDNPtr = dataListGlobal[BLACKHOLE_TYPE]->NextPrevItems((void *)blackholeCurrent, &nextDNPtr, &prevDNPtr, bb);
		}
	break;
	case SOI_BLDONE:
		if (!validate) 
		{
			Quit();
		}
		if (!strcmp(removeStr, bb->add->Label())) 
		{
			ValidateBlackhole();
			if (err == NO_ERR) 
			{
				UpdateBlackhole();
			}
		}
		if (err == NO_ERR) 
		{
			Quit();
		}
	break;
	case SOI_BLGNU:
		if (validate) ValidateBlackhole();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateBlackhole();
			blackholeCurrent = NULL;
			RemoveChild(bb->gnu);
			delete bb->gnu;
			bb->gnu = NULL;
			bb->add->SetLabel(addStr);
			bb->add->SetMessage(new BMessage(SOI_BLADD));
			nameStrGadget->SetText("");
			nameStrGadget->MakeFocus();
		}
	break;
	case SOI_BLADD:
		if (validate) ValidateBlackhole();
		else {
			err = NO_NAME;
			warning(everythingNamed);
		}//for add don't update
		if (err == NO_ERR) 
		{
			AddBlackhole();
			if (err) 
			{
				if (err != CREATEDNOTADDED) 
				{
					Quit();
				}
			}
			else {
				if (editUniverseWindow) 
				{
					editUniverseWindow->Lock();
					editUniverseWindow->buttons[DSN_BLACKHOLE]->SetLabel(editThe[BLACKHOLE_TYPE]);
					editUniverseWindow->Unlock();
					editUniverseWindow->bb->save->SetEnabled(true);
				}
				nameStrGadget->SetText("");
				nameStrGadget->MakeFocus();
				bb->save->SetEnabled(true);
				if (openingWindow) 
				{
					openingWindow->Lock();
					openingWindow->universeButton->SetLabel(editThe[UNIVERSE_TYPE]);
					openingWindow->createUniverseButton->SetEnabled(true);
					openingWindow->realUniverseButton->SetEnabled(true);
					openingWindow->Unlock();
				}
			}
		}
	break;
	case SOI_BLSAVE:
		if (validate) ValidateBlackhole();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateBlackhole();
			//RunSavePanel("universe", saveThe[UNIVERSE_TYPE], saveStr, cancelStr);
		}
	break;
	case SOI_BLPIC:
	
	break;
	case SOI_LOADUNIVERSEFROMPANEL:
		LoadBlackholes("universe");//debug
		Quit();
	break;
	case SOI_BLLOAD:
		BMessage * bm = new BMessage(SOI_LOADUNIVERSEFROMPANEL);
		if (bm) break;//debug break;//debug be_app->RunFilePanel(loadThe[UNIVERSE_TYPE], loadStr, cancelStr, false, bm);
		else warning(failMemory);
	break;
	case SOI_BLNEXT:
		Blackhole * nextBlackhole = (Blackhole *)((DataNode *)nextDNPtr)->data;
		if (validate) ValidateBlackhole();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateBlackhole();
			blackholeCurrent = nextBlackhole;
			nameStrGadget->SetText(blackholeCurrent->name);
			thisDNPtr = dataListGlobal[BLACKHOLE_TYPE]->NextPrevItems((void *)blackholeCurrent, &nextDNPtr, &prevDNPtr, bb);
		}
	break;
	default:
		BWindow::MessageReceived(message);
	break;
}
}//end


bool EditBlackholeWindow::QuitRequested(void) 
{

if (strcmp(nameStrGadget->Text(), "")) 
{
	if (blackholeCurrent) 
	{
		ValidateBlackhole();
		if (err == NO_ERR) 
		{
			UpdateBlackhole();
			if (err == NO_ERR) 
			{
				Quit();
				return(BWindow::QuitRequested());
			}
			else return false;
		}
		else return false;
	}
}
Quit();
return(BWindow::QuitRequested());
}//end


void EditBlackholeWindow::ValidateBlackhole(void) 
{

UniqueName(dataListGlobal[BLACKHOLE_TYPE], nameStrGadget->Text());
if (NO_UNIQUE == err) 
{
	warning(failNameUnique[BLACKHOLE_TYPE]);
	return;
}

if (blackhole->name) 
{
	if (strcmp(blackhole->name, nameStrGadget->Text())) 
	{
		free(blackhole->name);
		blackhole->name = (char *)malloc(strlen(nameStrGadget->Text()) + 1);
		if (blackhole->name) strcpy(blackhole->name, nameStrGadget->Text());
		else {
			err = NO_NAME;
			warning(failName);
		}
	}
}
//debug must do object as well
}//end


void EditBlackholeWindow::UpdateBlackhole(void) 
{

err = NO_ERR;
if (blackholeCurrent) 
{
	if (strcmp(blackholeCurrent->name, nameStrGadget->Text())) 
	{
		if (blackholeCurrent->name) free(blackholeCurrent->name);
		blackholeCurrent->name = (char *)malloc(strlen(nameStrGadget->Text()) + 1);
		if (blackholeCurrent->name) strcpy(blackholeCurrent->name, nameStrGadget->Text());
		else {
			err = NO_NAME;
			warning(failName);
		}
	}
	//debug must do object as well
}
}//end


void EditBlackholeWindow::SaveBlackholes(const char * fileName) 
{

SaveUniverse(fileName);
}//end


void EditBlackholeWindow::LoadBlackholes(const char * fileName) 
{

LoadUniverse(fileName);
}//end
