/*
	Application and window classes for Amiga-M.
	
	Amiga-M is 'know'-ware: let me know if you use it.
	(I promise I won't hold it against you).
	Just send a mail to <marcone@xs4all.nl>
*/

#include "appwin.h"

extern char normbuttondata[];
extern char presbuttondata[];
extern mywin *window;

myapp::myapp(char *id)
	: BApplication(id)
{
}

void myapp::AboutRequested()
{
	BAlert	*myAlert;
	myAlert = new BAlert("","Amiga-M 1.4\nBy Marco Nelissen  <marcone@xs4all.nl>","so what?");
	myAlert->Go();
}

mywin::mywin(BRect r,char *name,window_type type,ulong mode)
	: BWindow(r,name,type,mode,B_ALL_WORKSPACES)
{
}

bool mywin::QuitRequested()
{
	be_app->PostMessage(B_QUIT_REQUESTED);
	return TRUE;
}

void mywin::MessageReceived(BMessage *message)
{
	int numworkspaces;
	int currentworkspace;
	
	switch ( message->what )
	{
		case GOTOPREVWS:
			numworkspaces=count_workspaces();
			currentworkspace=current_workspace()-1;
			if(currentworkspace < 0) currentworkspace = numworkspaces-1;
			activate_workspace(currentworkspace);
			break;

		case GOTONEXTWS:
			numworkspaces=count_workspaces();
			currentworkspace=current_workspace()+1;
			if(currentworkspace >= numworkspaces) currentworkspace=0;
			activate_workspace(currentworkspace);
			break;

		case GOTOWS:
			activate_workspace(message->FindInt32("ws"));
			break;

		default:
			inherited::MessageReceived(message);
			break;
	}
	Activate(true);	 // should be false, but that will put it behind the
	                // tracker's backdrop window
}

void mywin::Place(void)
{
	BScreen	screen;
	BRect frame=screen.Frame();

	MoveTo(BPoint(frame.right-(WINWIDTH-1),frame.top));
	Activate(true);
}

void mywin::WorkspacesChanged(uint32 oldws, uint32 newws)
{
	Place();
}

void mywin::ScreenChanged(BRect frame, color_space colspace)
{
	Place();
}

myview::myview(BRect rect,char *name,ulong type,ulong flags)
	: BView(rect,name,type,flags)
{
	state=false;
	but1 = new BBitmap(BRect(0,0,((WINWIDTH+7)&0xfff8)-1,WINHEIGHT-1), B_COLOR_8_BIT);
	but1->SetBits((char*)normbuttondata, but1->BitsLength(), 0, B_COLOR_8_BIT);
	but2 = new BBitmap(BRect(0,0,((WINWIDTH+7)&0xfff8)-1,WINHEIGHT-1), B_COLOR_8_BIT);
	but2->SetBits((char*)presbuttondata, but2->BitsLength(), 0, B_COLOR_8_BIT);
	SetViewColor(B_TRANSPARENT_32_BIT);

	popup=NULL;
}

void myview::MouseDown(BPoint point)
{
	BPoint  cursor;
	ulong   buttons1;
	ulong	buttons2;
	BMessage *mes;
	int		numworkspaces;
	int		count;
	char	numbuf[3];  // "99 workspaces should be enough for anyone" ;)
	BMenuItem *item;

	GetMouse(&cursor, &buttons1,true);
// as I don't have a three-button mouse, I'm using button+shift for testing the popup.
	if(buttons1&B_TERTIARY_MOUSE_BUTTON || modifiers()&B_SHIFT_KEY)
	{
showpopup:
		numworkspaces=count_workspaces();
		popup=new BPopUpMenu("Amiga-M popup",false,false);
		for(count=0;count<numworkspaces;count++)
		{
			BMessage *mes=new BMessage(GOTOWS);
			mes->AddInt32("ws",count);
			sprintf(numbuf,"%d",count+1);
			popup->AddItem(item=new BMenuItem(numbuf,mes));
			item->SetTarget(window);
			if(count==current_workspace())
				item->SetMarked(true);
		}
		popup->AddSeparatorItem();
		popup->AddItem(item=new BMenuItem("About…", new BMessage(B_ABOUT_REQUESTED)));
		item->SetTarget(be_app);
		popup->AddItem(item=new BMenuItem("Quit", new BMessage(B_QUIT_REQUESTED)));
		item->SetTarget(be_app);
		ConvertToScreen(&point);
		point.y= 0;     // unfortunately, this doesn't put the popup against the
		                // upper side of the screen
		popup->Go(point,true);
		delete popup;
	}
	else
	{
		while(buttons1)
		{
			snooze(5000);
			buttons2=buttons1;
			GetMouse(&cursor, &buttons1,true);
			// Yay! This works now! DR9 rules! (sorta...)
 			if((buttons1&B_PRIMARY_MOUSE_BUTTON)&&(buttons1&B_SECONDARY_MOUSE_BUTTON))
 				goto showpopup;

			if(Bounds().Contains(cursor))
			{
				if(!state)
				{
					state=true;
					Draw(Bounds());
				}
			}	
			else
			{
				if(state)
				{
					state=false;
					Draw(Bounds());
				}
			}
		}
		state=false;Draw(Bounds());
		if(Bounds().Contains(cursor))
		{
			if(buttons2&B_SECONDARY_MOUSE_BUTTON)
			{
				mes=new BMessage(GOTOPREVWS);
			}
			else if(buttons2&B_PRIMARY_MOUSE_BUTTON)
			{
				mes=new BMessage(GOTONEXTWS);
			}
// third button is now used for popup
//			else if(buttons2&B_TERTIARY_MOUSE_BUTTON)
//			{
//				mes=new BMessage(GOTOWS);
//			}
			else
			{
				return;
			}
			window->PostMessage(mes);
		}
		else
		{
			// comment out this block if Amiga-M causes problems with your mouse/keyboard
			long rate;
			long long delay;

			if(B_NO_ERROR==get_key_repeat_rate(&rate))
				set_key_repeat_rate(rate);
			if(B_NO_ERROR==get_key_repeat_delay(&delay))
				set_key_repeat_delay(delay);
		}
	}
}

void myview::Draw(BRect clip)
{
	if(state)
		DrawBitmap(but2,BPoint(0,0));
	else
		DrawBitmap(but1,BPoint(0,0));
}