/******************************************************************************/
/* TestPlayer Player Stub Interface.                                          */
/******************************************************************************/
/* This is part of the APlayer Programming Package (APPP).                    */
/* Copyright (C) 1998-1999 by The APlayer-Team.                               */
/* All rights reserved.                                                       */
/*                                                                            */
/* This source, or parts thereof, may only be used in APlayer related         */
/* software. If you want to use it elsewhere, please contact the author for a */
/* permission.                                                                */
/******************************************************************************/


#define _BUILDING_APLAYER_ADDON_

// APlayer headers
#include "AddOn_Import.h"
#include "APAddOns.h"

// Player headers
#include "TestPlayer.h"


/******************************************************************************/
/* Add-On function: Load() is called when the add-on is loaded into the       */
/*      memory.                                                               */
/*                                                                            */
/* Input:  "global" is a pointer to the global data class.                    */
/******************************************************************************/
void Load(APGlobalData *global)
{
	printf("Load(): global = 0x%08X\n", (int)global);
}



/******************************************************************************/
/* Add-On function: Unload() is called just before the add-on is freed from   */
/*      the memory.                                                           */
/*                                                                            */
/* Input:  "global" is a pointer to the global data class.                    */
/******************************************************************************/
void Unload(APGlobalData *global)
{
	printf("Unload(): global = 0x%08X\n", (int)global);
}



/******************************************************************************/
/* Add-On function: GetInstance() will allocate a new add-on instance and     */
/*      return the pointer to it.                                             */
/*                                                                            */
/* Input:  "global" is a pointer to the global data class.                    */
/*                                                                            */
/* Output: A new add-on instance allocated with new.                          */
/******************************************************************************/
APAddOn *GetInstance(APGlobalData *global)
{
	printf("GetInstance(): global = 0x%08X\n", (int)global);
	return (new TestPlayer(global));
}
