/******************************************************************************/
/* APlayer Module Info list view class.                                       */
/******************************************************************************/
/* This is part of the APlayer Programming Package (APPP).                    */
/* Copyright (C) 1998-1999 by The APlayer-Team.                               */
/* All rights reserved.                                                       */
/*                                                                            */
/* This source, or parts thereof, may only be used in APlayer related         */
/* software. If you want to use it elsewhere, please contact the author for a */
/* permission.                                                                */
/******************************************************************************/


// APlayer headers
#include "ColumnListView.h"
#include "CLVColumnLabelView.h"

// Needed headers
#include "MIListView.h"


/******************************************************************************/
/* Constructor                                                                */
/******************************************************************************/
MIListView::MIListView(BRect frame, CLVContainerView** containerView, uint32 resizingMode, uint32 flags, list_view_type type, bool hierarchical, bool horizontal, bool vertical, bool scrollViewCorner, border_style border, const BFont* labelFont) :
	ColumnListView(frame, containerView, NULL, resizingMode, flags, type, hierarchical, horizontal, vertical, scrollViewCorner, border, labelFont)
{
	font_height fontAttr;

	be_plain_font->GetHeight(&fontAttr);
	fontHeight = ceil(fontAttr.ascent) + ceil(fontAttr.descent);
}



/******************************************************************************/
/* Destructor                                                                 */
/******************************************************************************/
MIListView::~MIListView(void)
{
}



/******************************************************************************/
/* KeyDown() is called for every key the user presses when the list has the   */
/*      focus. It parse key down and up so it list scrolls.                   */
/*                                                                            */
/* Input:  "bytes" is a pointer to the UTF-8 character.                       */
/*         "numBytes" is the number of bytes the key has.                     */
/******************************************************************************/
void MIListView::KeyDown(const char *bytes, int32 numBytes)
{
	if (numBytes == 1)
	{
		BRect curRect;

		// Get the showing rect
		curRect = Bounds();

		// Arrow down
		if (*bytes == B_DOWN_ARROW)
		{
			uint32 i, count;
			float height = 0;

			// Get the number of items in the list
			count = CountItems();

			// Calculate the total number of pixels to use
			for (i = 0; i < count; i++)
				height += ItemAt(i)->Height() + 1;

			if (count > 0)
				height -= 1;

			if (curRect.bottom < height)
				ScrollBy(0, fontHeight);
			return;
		}

		// Arrow up
		if (*bytes == B_UP_ARROW)
		{
			if (curRect.top > 0)
				ScrollBy(0, -fontHeight);
			return;
		}

		// Tab
		if (*bytes == B_TAB)
			return;
	}

	ColumnListView::KeyDown(bytes, numBytes);
}
