/******************************************************************************/
/* MIAgent header file.                                                       */
/******************************************************************************/
/* This is part of the APlayer Programming Package (APPP).                    */
/* Copyright (C) 1998-1999 by The APlayer-Team.                               */
/* All rights reserved.                                                       */
/*                                                                            */
/* This source, or parts thereof, may only be used in APlayer related         */
/* software. If you want to use it elsewhere, please contact the author for a */
/* permission.                                                                */
/******************************************************************************/


#ifndef __MIAgent_h
#define __MIAgent_h

// PolyKit headers
#include "PString.h"

// APlayer headers
#include "APAddOns.h"

// Needed headers
#include "MIWindow.h"


/******************************************************************************/
/* MIAgent class                                                              */
/******************************************************************************/
class MIAgent : public APAddOnAgent
{
public:
	MIAgent(APGlobalData *global);
	virtual ~MIAgent(void);

	float GetVersion(void);

	PString GetName(uint32 number);
	PString GetDescription(uint32 number);

	uint32 GetSupportFlags(void);

	bool InitAgent(void);
	void EndAgent(void);
	void OpenWindows(void);
	void Run(void);

	void Plugin_AfterInitSong(void);
	void Plugin_AfterFree(void);
	void Plugin_ModuleInfoChanged(uint32 line, ap_infoType type, PString newString);

protected:
	void FixRegistry(void);

	uint32 strings;

	MIWindow *window;
	bool openIt;
};

#endif
