/******************************************************************************/
/* MikModConverter Agent Stub Interface.                                      */
/******************************************************************************/
/* This is part of the APlayer Programming Package (APPP).                    */
/* Copyright (C) 1998-1999 by The APlayer-Team.                               */
/* All rights reserved.                                                       */
/*                                                                            */
/* This source, or parts thereof, may only be used in APlayer related         */
/* software. If you want to use it elsewhere, please contact the author for a */
/* permission.                                                                */
/******************************************************************************/


#define _BUILDING_APLAYER_ADDON_

// APlayer headers
#include "AddOn_Import.h"
#include "APAddOns.h"

// Needed headers
#include "MikAgent.h"
#include "MikIcons.h"


/******************************************************************************/
/* Add-On function: Load()                                                    */
/******************************************************************************/
void Load(APGlobalData *global)
{
	// Install the mime types + icons
	global->InstallModType("audio/x-669", "669", "8 channels 669 Tracker module", "669 Tracker Module", s69SmallIcon, s69LargeIcon);
	global->InstallModType("audio/x-amf", "amf", "1-32 channels DSMI module", "DSMI Module", amfSmallIcon, amfLargeIcon);
	global->InstallModType("audio/x-dsm", "dsm", "1-16 channels DSIK module", "DSIK Module", dsmSmallIcon, dsmLargeIcon);
	global->InstallModType("audio/x-far", "far", "16 channels Farandole module", "Farandole Module", farSmallIcon, farLargeIcon);
	global->InstallModType("audio/x-gdm", "gdm", "1-32 channels General DigiMusic module", "General DigiMusic Module", gdmSmallIcon, gdmLargeIcon);
	global->InstallModType("audio/x-imf", "imf", "1-32 channels Imago Orpheus module", "Imago Orpheus Module", imfSmallIcon, imfLargeIcon);
	global->InstallModType("audio/x-it", "it", "1-64 channels ImpulseTracker module", "ImpulseTracker Module", itSmallIcon, itLargeIcon);
	global->InstallModType("audio/x-mikmod", "mik", "1-64 channels MikMod (UNIMOD) module", "MikMod Module", mikSmallIcon, mikLargeIcon);
	global->InstallModType("audio/x-s3m", "s3m", "1-16 channels ScreamTracker 3.x module", "ScreamTracker 3.x Module", s3mSmallIcon, s3mLargeIcon);
	global->InstallModType("audio/x-stm", "stm", "4 channels ScreamTracker 2.x module", "ScreamTracker 2.x Module", stmSmallIcon, stmLargeIcon);
	global->InstallModType("audio/x-stx", "stx", "4 channels STMIK module", "STMIK Module", stxSmallIcon, stxLargeIcon);
	global->InstallModType("audio/x-ult", "ult", "1-32 channels UltraTracker module", "UltraTracker Module", ultSmallIcon, ultLargeIcon);
	global->InstallModType("audio/x-xm", "xm", "1-32 channels FastTracker II module", "FastTracker II Module", xmSmallIcon, xmLargeIcon);
}



/******************************************************************************/
/* Add-On function: Unload()                                                  */
/******************************************************************************/
void Unload(APGlobalData *global)
{
}



/******************************************************************************/
/* Add-On function: GetInstance()                                             */
/******************************************************************************/
APAddOn *GetInstance(APGlobalData *global)
{
	return (new MikAgent(global));
}
