/******************************************************************************/
/* APModuleList header file.                                                  */
/******************************************************************************/
/* This is part of the APlayer Programming Package (APPP).                    */
/* Copyright (C) 1998-1999 by The APlayer-Team.                               */
/* All rights reserved.                                                       */
/*                                                                            */
/* This source, or parts thereof, may only be used in APlayer related         */
/* software. If you want to use it elsewhere, please contact the author for a */
/* permission.                                                                */
/******************************************************************************/


#ifndef __APModuleList_h
#define __APModuleList_h

// PolyKit headers
#include "POS.h"
#include "PString.h"

// APlayer headers
#include "APlayer.h"
#include "APList.h"
#include "APlayerClasses_Import.h"


/******************************************************************************/
/* APModuleListItem class                                                     */
/******************************************************************************/
#if __p_os == __p_beos && __POWERPC__
#pragma export on
#endif

#if __p_os == __p_beos
class _IMPEXP_APLIB APModuleListItem : public BStringItem
#else
class _IMPEXP_APLIB APModuleListItem
#endif
{
public:
	enum ItemType {Normal};

	APModuleListItem(PString text, PString fileName);
	virtual ~APModuleListItem(void);

//	void ChangeToArchive(PString archiveName, ItemType type);

	void SetPlayingFlag(bool flag);
	bool IsPlaying(void);

	ItemType GetItemType(void);
	PString GetFileName(void);
//	PString GetArchiveName(void);

#if __p_os == __p_beos
	APModuleListItem(BMessage *archive);

	status_t Archive(BMessage *archive, bool deep = true) const;
	static APModuleListItem *Instantiate(BMessage *archive);
#endif

protected:
#if __p_os == __p_beos
	void DrawItem(BView *owner, BRect frame, bool complete = false);
	void Update(BView *owner, const BFont *font);
#endif

	ItemType itemType;
	PString itemFileName;
	PString itemArchiveName;
	bool playing;

#if __p_os == __p_beos
	float textOffset;
#endif
};



/******************************************************************************/
/* APModuleList class                                                         */
/******************************************************************************/
class _IMPEXP_APLIB APModuleList
{
public:
	enum ListType {Unknown = 0, APlayer, CL_Amp, SoundPlay};

	APModuleList(APGlobalData *globalData);
	virtual ~APModuleList(void);

#if __p_os == __p_beos

	void AddModuleList(BListView *list);
	void RemoveModuleList(BListView *list);

#endif

#if __p_os == __p_windows

	void AddModuleList(CListCtrl *list);
	void RemoveModuleList(CListCtrl *list);

#endif

#if __p_os == __p_linux
implement
#endif

	void LockList(void);
	void UnlockList(void);

	void RemoveModuleItems(void);
	int32 CountModuleItems(void);
	void SetPlayingFlag(int32 index, bool flag);

	void AddModuleListItem(APModuleListItem *item, int32 index = -1, bool callPlugins = true);
	void AddModuleListItem(PString dirName, int32 index = -1, bool callPlugins = true);
	void RemoveModuleListItem(int32 index, bool callPlugins = true);

	void SwapModuleListItems(int32 index1, int32 index2);
	void MoveModuleListItem(int32 oldIndex, int32 newIndex);
	void MoveModuleListItemToTop(int32 index);
	void MoveModuleListItemToBottom(int32 index);

	void ShuffleModuleList(int32 firstItem = -1);
	void SortModuleList(bool ascending = true);

	ListType CheckModuleListFile(PString fileName);
	void AppendModuleList(PString fileName, int32 index = -1);
	void SaveModuleList(PString fileName);

	const APModuleList & operator = (const APModuleList &list);

protected:
	void QuickSort_A(APModuleListItem **list, int32 count, int32 total, int32 left, int32 right);
	void QuickSort_D(APModuleListItem **list, int32 count, int32 total, int32 left, int32 right);

	void AddModuleList(BList *list, int32 index = -1);

	APGlobalData *global;

#if __p_os == __p_beos
	APList<BListView *> modLists;
#endif
};

#if __p_os == __p_beos && __POWERPC__
#pragma export off
#endif

#endif
