/*
	stretches a bitmap by two in horizontal AND vertical direction
	src			- pointer to source bitmap
	src_width	- width of source bitmap in pixels
	src_height	- height of source bitmap in pixels
	src_skip	- how many bytes to skip behind each line of data

	dest		- pointer to destination bitmap
		(dest size is of course src_width*2, src_height*2)
	dest_skip	- how many bytes to skip behind each line in dest bitmap
 */

#include <SupportDefs.h>

void stretchby2( uint32 *src, uint32 src_width, uint32 src_height, uint32 src_skip,
				 uint32 *dest, uint32 dest_skip)
{
	int		y,x;
	uint32	*dest2, *dest_tmp;
	uint32	srcv;
	for(y=0;y<src_height;y++)
	{
		dest_tmp = dest;
		dest2	 = (uint32*)(((char*)dest)+(src_width<<1)+dest_skip);
		for(x=0;x<(src_width>>2);x++)								// vidmem: 0xAABBCCDD	srcv:  0xDDCCBBAA
		{															//						dest1: 0xBBBBAAAA vid: 0xAAAABBBB
																	//						dest2: 0xDDDDCCCC vid: 0xCCCCDDDD
			srcv = *src++;
			*dest++	=	((srcv&0x0000FF00)<<16) |
					 	((srcv&0x0000FF00)<<8)	|
					 	((srcv&0x000000FF)<<8)	|
					 	((srcv&0x000000FF));
			*dest++ =	((srcv&0xFF000000))		|
						((srcv&0xFF000000)>>8)	|
						((srcv&0x00FF0000)>>8)	|
						((srcv&0x00FF0000)>>16);
		}
		while(dest_tmp < dest) //for(x=0; x<(src_width>>1); x++)
			*dest2++ = *dest_tmp++;
		dest = (uint32*)(((char*)dest2) + dest_skip);
		src = (uint32*)(((char*)src) + src_skip);
	}
}
