#ifndef	FieldViewH
#define	FieldViewH
//------------------------------------------------------------------------------
#include <Alert.h>
#include <Application.h>
#include <Clipboard.h>
#include <FilePanel.h>
#include <Path.h>
#include <ScrollBar.h>
#include <ScrollView.h>
#include <View.h>
#include <math.h>
#include <stdio.h>
#include <strstream.h>
#include <time.h>
#include <add/SHIFile.h>
#include <add/SHIString.h>
#include "CtrlView.h"
#include "Common.h"
//------------------------------------------------------------------------------
const char	FDFExt[] = ".blf";				//フィールドデータファイルの拡張子
const char	FDFHeader[] = "BLMD$1";			//フィールドデータファイルのヘッダ
const int	FReadMarginLen = 20;			//ファイル読み込みの際の遊び
const int	LifeFmtMaxLen = 120;			//Life形式読込み時の１行最大文字数
//------------------------------------------------------------------------------
class TFieldView : public BView
{
private:
	virtual void	AllAttached();
	virtual void	AttachedToWindow();
	bool			CreateMapArray();			//マップ配列作成
	void			CreateMapArrayRqtd();
	void			DestroyMapArray();			//マップ配列破棄
	void			DestroyMapArrayRqtd();
	virtual void	Draw(BRect Rect);
	void			DrawMap();					//マップ描画
	void			FieldDataFromClip();		//フィールドデータをクリボから
	void			FieldDataToClip(bool bDelData);	//フィールドデータをクリボへ
	virtual void	FrameResized(float fWidth,float fHeight);
	void			LoadBLMD1(TSHIFile &xFile);	//BLMD1形式フィールドデータロード
	void			LoadLife(TSHIFile &xFile);	//Life形式フィールドデータロード
	void			LoadLifeCvtCdn(int &iX,int &iY);	//座標変換
	void			ManageLife();				//生命体の配置・除去
	void			MenuCopyClicked();
	void			MenuCutClicked();
	void			MenuEnblocClicked();
	void			MenuGoStopClicked();
	void			MenuNewClicked();
	void			MenuOpenClicked();
	void			MenuPasteClicked();
	void			MenuRandomClicked();
	void			MenuSaveClicked();
	void			MenuSaveAsClicked();
	void			MenuSelAllClicked();
	void			MenuStepClicked();
	virtual void	MessageReceived(BMessage *xMsg);
	virtual void	MouseDown(BPoint xPoint);
	void			NextGeneration();			//１世代交代
	void			OpenData(BEntry *xEntry);	//データロード
	virtual void	Pulse();
	void			RedrawMap();				//マップ再描画
	void			RedrawMapRqtd();
	void			RefsReceived(BMessage *xMsg);
	void			SaveData(BEntry *xEntry);	//データセーブ
	void			SaveRequested(BMessage *xMsg);
	void			SelectField();				//フィールドを範囲選択
	void			SetScrlBar();				//スクロールバー設定
	void			ShineField();				//選択範囲を点滅
	void			StartGeneShift(int iGenes);	//世代交代開始
	void			StopGeneShift();			//世代交代停止
	virtual void	TargetedByScrollView(BScrollView *xScrlView);

	uchar		***mcMap;			//マップ（ページ、横、縦の順）
	int			miGeneLimit;		//停止する世代番号
	int			miGeneNo;			//世代番号
	int			miMapPage;			//マップのどのページにアクセスするか
	BFilePanel	*mxOpenPanel;		//開くダイアログ
	BFilePanel	*mxSavePanel;		//保存ダイアログ
	BScrollBar	*mxHBar;			//水平スクロールバー
	BScrollBar	*mxVBar;			//垂直スクロールバー
//	BScrollView	*mxFieldScrlView;	//スクロールビュー
	TCtrlView	*mxCtrlView;		//コントロールビュー
protected:
public:
	TFieldView(BRect xFrame);
	~TFieldView();
};
//------------------------------------------------------------------------------
#endif	//FieldViewH
