#ifndef	BeNaLifeCommonH
#define	BeNaLifeCommonH
//------------------------------------------------------------------------------
#include <Alert.h>
#include <Application.h>
#include <Clipboard.h>
#include <Directory.h>
#include <Entry.h>
#include <GraphicsDefs.h>
#include <Rect.h>
#include <SupportDefs.h>
#include <String.h>
#include <stdlib.h>
#include <string.h>
//------------------------------------------------------------------------------
const char	BLFData[] = "BeNaLifeFieldData";	//クリップボード用識別子
const char	HelpFName[] = "BeNaLife.htm";	//ヘルプファイル名
const int	BlockSizeMaxFig = 3;			//ブロックサイズの最大桁数
const int	ButtonHeight = 30;
const int	CmpMargin = 10;
const int	CtrlViewWidth = 100;
const int	IntervalMaxFig = 5;				//世代交代間隔の最大桁数
const int	MapBlockMaxFig = 4;				//マップのブロック数の最大桁数
enum		{ mipFile,miNew,miOpen,miSave,miSaveAs,miQuit };	//ファイルメニュー
enum		{ mipEdit,miCut,miCopy,miPaste,miSelAll };			//編集メニュー
enum		{ mipGene,miGo,miStop,miStep,miEnbloc };			//世代交代メニュー
enum		{ mipTool,miPref,miRTF,miRandom };					//ツールメニュー
enum		{ mipHelp,miHelp,miAbout };							//ヘルプメニュー
enum		{ IDNone,IDOK,IDCancel };							//ダイアログの戻り値
//------------------------------------------------------------------------------
const uint32	MENUENBLOC_CLICKED = 'bloc';
const uint32	CREATEMAPARRAY_RQTD = 'cmar';	//マップ配列生成要求
const uint32	CHANGEMBARSTATE_RQTD = 'cmnb';	//メニュー状態変更要求
//const uint32	MENUCOPY_CLICKED = 'copy';
//const uint32	MENUCUT_CLICKED = 'cut';
const uint32	CHANGEVIEWCOL_RQTD = 'cvcl';	//ビュー色変更要求
const uint32	DISABLECTRL_RQTD = 'dctl';		//ボタン操作不可要求
const uint32	DESTROYMAPARRAY_RQTD = 'dmar';	//マップ配列破棄要求
const uint32	ENABLECTRL_RQTD = 'ectl';		//ボタン操作可能要求
const uint32	MENUSETTING_CLICKED = 'eset';
const uint32	MENUGOSTOP_CLICKED = 'gost';
const uint32	MENUHELP_CLICKED = 'help';
const uint32	MENUNEW_CLICKED = 'new';
const uint32	MENUOPEN_CLICKED = 'open';
//const uint32	MENUPASTE_CLICKED = 'pste';
const uint32	REDRAWMAP_RQTD = 'rdmp';		//マップ再描画要求
const uint32	MENURANDOM_CLICKED = 'rndm';
const uint32	MENURESIZETOFIT_CLICKED = 'rsiz';
const uint32	MENUSAVE_CLICKED = 'save';
//const uint32	MENUSELALL_CLICKED = 'sela';
const uint32	MENUSAVEAS_CLICKED = 'svas';
const uint32	MENUSTEP_CLICKED = 'step';
//------------------------------------------------------------------------------
class TAppPrivacy	//アプリケーション全体で共有する情報
{
public:
	TAppPrivacy();
	~TAppPrivacy();
	
	bool		mbGoing;			//開始ボタンが押された状態
	bool		mbNewFile;			//新規ファイル
	BEntry		mxCurrentEnt;		//現在のファイル
	BRect		mxSelectedField;	//選択された範囲
};
//------------------------------------------------------------------------------
class TCustomSet	//ユーザーが設定できる項目
{
public:
	TCustomSet();
	~TCustomSet();

	int			miInterval;			//世代交代の間隔 [ms]
	int			miLang;				//言語
	int			miXBlockSize;		//１つのブロックの横の大きさ [pixel]
	int			miYBlockSize;		//１つのブロックの縦の大きさ [pixel]
	int			miXBlocks;			//横のブロック数
	int			miYBlocks;			//縦のブロック数
	rgb_color	mxCtrlViewColor;	//コントロールビューの色
	rgb_color	mxEmptyColor;		//非生命体の色
	rgb_color	mxLifeColor;		//生命体の色
};
//------------------------------------------------------------------------------
class TExitState	//終了時の状態
{
public:
	TExitState();
	~TExitState();
	
	BRect	mxFrame;							//ウィンドウの位置
	char	mszOPanelPath[B_PATH_NAME_LENGTH];	//開くダイアログのパス
	char	mszSPanelPath[B_PATH_NAME_LENGTH];	//保存ダイアログのパス
};
//------------------------------------------------------------------------------
class TLLMsg	//ローカライズされた言語でのメッセージ
{
public:
	TLLMsg();
	~TLLMsg();
	
	BString	mxAlertCaption[2];			//アラートウィンドウのキャプション
	BString	mxAppInfo[2];				//アプリケーション情報
	BString	mxBoxBlock;					//ブロックサイズボックス
	BString	mxBoxCol;					//色ボックス
	BString	mxBoxField;					//フィールドサイズボックス
	BString	mxBoxLang;					//言語ボックス
	BString	mxButtonCancel;				//キャンセルボタン
	BString	mxButtonEmptyCol;			//非生命体色ボタン
	BString	mxButtonEnbloc;				//一括ボタン
	BString	mxButtonGo;					//開始ボタン
	BString	mxButtonHelp;				//ヘルプボタン
	BString	mxButtonLifeCol;			//生命体色ボタン
	BString	mxButtonNo;					//いいえボタン
	BString	mxButtonOK;					//ＯＫボタン
	BString	mxButtonOpen;				//開くボタン
	BString	mxButtonPanelCol;			//パネル色ボタン
	BString	mxButtonSave;				//保存ボタン
	BString	mxButtonStep;				//ステップボタン
	BString	mxButtonStop;				//停止ボタン
	BString	mxButtonYes;				//はいボタン
	BString	mxDiffeFmtErr;				//データファイルの形式が違うエラー
	BString	mxEditEnbloc;				//一括エディット
	BString	mxHelpErr[2];				//ヘルプエラー
	BString	mxLabelEnbloc;				//一括ラベル
	BString	mxLabelHeight;				//縦ラベル
	BString	mxLabelInterval;			//世代交代間隔ラベル
	BString	mxLabelWidth;				//横ラベル
	BString	mxLLMsgFErr;				//ローカライズファイルエラー
	BString	mxMenuEdit[miSelAll+1];		//編集メニュー
	BString	mxMenuFile[miQuit+1];		//ファイルメニュー
	BString	mxMenuGene[miEnbloc+1];		//世代交代メニュー
	BString	mxMenuHelp[miAbout+1];		//ヘルプメニュー
	BString	mxMenuTool[miRandom+1];		//ツールメニュー
	BString	mxMItemEnbloc;				//世代交代コマンド
	BString	mxNewConfirm;				//新規作成確認
	BString	mxNotOpenErr;				//データファイルが開けないエラー
	BString	mxNotSaveErr;				//データを保存できないエラー
	BString	mxOPanelTitle;				//開くパネルタイトル
	BString	mxOWConfirm;				//上書き確認
	BString	mxRButtonLang[2];			//言語ボタン
	BString	mxSetFCmt;					//設定ファイルコメント
	BString	mxSetWinTitle;				//設定ウィンドウタイトル
	BString	mxSPanelTitle;				//保存パネルタイトル
};
//------------------------------------------------------------------------------
char*	AlertCaption();				//アラートボックスの最上部の文字列
void	AlertErr(/*const */BString &xErr);	//エラーメッセージの表示
bool	ClipHasData();				//クリボがＢeなＬifeのデータを持っているか
float	Max(float a,float b);		//大きい方を返す
void	ShowHelp();					//ヘルプを表示
int		StrToInt(const char *szStr,int iMaxFig);	//文字列を数値に変換
void	Swap(float &a,float &b);	//価を入れ替える
//------------------------------------------------------------------------------
extern const char	*gszAppName;
extern TAppPrivacy	*gxAppPrivacy;
extern TCustomSet	*gxCustomSet;
extern TExitState	*gxExitState;
extern TLLMsg		*gxLLMsg;
//------------------------------------------------------------------------------
#endif	//BeNaLifeCommonH
