#ifndef	BeNaLifeWindowH
#define	BeNaLifeWindowH
//------------------------------------------------------------------------------
#include <Application.h>
#include <Menu.h>
#include <MenuBar.h>
#include <MenuItem.h>
#include <MessageFilter.h>
#include <Screen.h>
#include <Window.h>
#include "BeNaLifeView.h"
#include "CtrlView.h"
#include "Common.h"
#include "SettingWindow.h"
//------------------------------------------------------------------------------
class TPulseFilter;
//------------------------------------------------------------------------------
class TBeNaLifeWindow : public BWindow
{
private:
	void			ChangeMBarState();		//メニューの状態を変更
	void			ChangeMBarStateRqtd();
	void			ChangeMenuEditState();	//編集メニューの状態を変更
	void			ChangeMenuFileState();	//ファイルメニューの状態を変更
	void			ChangeMenuGeneState();	//世代交代メニューの状態を変更
	void			ChangeMenuToolState();	//ツールメニューの状態を変更
	virtual void	MenusBeginning();
	void			MenuResizeToFitClicked();
	void			MenuSettingClicked();
	virtual void	MessageReceived(BMessage *xMsg);
	virtual bool	QuitRequested();
	void			ReflectSetting();		//設定を反映
	
	BMenu			*mxMenuEdit;		//編集メニュー
	BMenu			*mxMenuFile;		//ファイルメニュー
	BMenu			*mxMenuGene;		//世代交代メニュー
	BMenu			*mxMenuTool;		//ツールメニュー
	BMenuBar		*mxMBar;			//メニューバー
	BMenuItem		*mxMItemCopy;		//コピー
	BMenuItem		*mxMItemCut;		//切り取り
	BMenuItem		*mxMItemEnbloc;		//一括メニュー
	BMenuItem		*mxMItemGo;			//開始メニュー
	BMenuItem		*mxMItemNew;		//新規作成メニュー
	BMenuItem		*mxMItemOpen;		//開くメニュー
	BMenuItem		*mxMItemPaste;		//張り付けメニュー
	BMenuItem		*mxMItemRandom;		//ランダム配置メニュー
	BMenuItem		*mxMItemSave;		//保存メニュー
	BMenuItem		*mxMItemSaveAs;		//名前をつけて保存メニュー
	BMenuItem		*mxMItemSelAll;		//全て選択メニュー
	BMenuItem		*mxMItemSetting;	//環境設定メニュー
	BMenuItem		*mxMItemStep;		//ステップメニュー
	BMenuItem		*mxMItemStop;		//停止メニュー
	TCtrlView		*mxCtrlView;		//コントロールビュー
	TFieldView		*mxFieldView;		//フィールドビュー
	TPulseFilter	*mxPulseFilter;		//B_PULSE抑制フィルタ
protected:
public:
	TBeNaLifeWindow(BRect xFrame);
	~TBeNaLifeWindow();
	
	TFieldView	*FieldView();		//フィールドビュー
};
//==============================================================================
class	TPulseFilter : public BMessageFilter
{
private:
	virtual filter_result	Filter(BMessage *xMsg, BHandler **xTgt);
public:
	TPulseFilter();
};
//------------------------------------------------------------------------------
#endif	//TBeNaLifeWindowH
