/*****************************************************************************

	Projet	: Droids

	Fichier	:	bCViewEcran.cpp
	Partie	: Video

	Auteur	: RM
	Date		: 110297
	Format	: tabs==2

*****************************************************************************/

#include "machine.h"
#include "bCViewEcran.h"
#include "gCMoteur.h"
#include "externs.h"

//---------------------------------------------------------------------------


//***************************************************************************
CViewEcran::CViewEcran(bool main, BRect viewFrame, BRect blitFrame, char *titre)
						:BView(viewFrame, titre, 	B_FOLLOW_NONE, B_FRAME_EVENTS|B_WILL_DRAW)
//***************************************************************************
{
	mMain = main;
	mEcran = NULL;
	mBounds = viewFrame,
	mEcranBounds = blitFrame;
	mEcranBounds.OffsetTo(0,0);
	mScrollX = 0.0;
	mScrollY = 0.0;
} // end of constructor for CViewEcran


//***************************************************************************
CViewEcran::~CViewEcran(void)
//***************************************************************************
{
	if (mEcran) delete mEcran;
} // end of destructor for CViewEcran


//---------------------------------------------------------------------------


//***************************************************************************
BOOL CViewEcran::init(void)
//***************************************************************************
{
	printf("CViewEcran::init\n");
	SetViewColor(B_TRANSPARENT_32_BIT);
	mEcran = new BBitmap(mEcranBounds, B_COLOR_8_BIT);
	if (mEcran)
	{
		memset(mEcran->Bits(), 0, mEcran->BitsLength());
		return TRUE;
	}
	else
		return FALSE;
} // end of init for CViewEcran



//***************************************************************************
void CViewEcran::MessageReceived(BMessage *msg)
//***************************************************************************
{
	if (msg->what == B_MOUSE_UP)
		gMoteur->mouseUp();
}


//***************************************************************************
void CViewEcran::AttachedToWindow(void)
//***************************************************************************
{
	if (Window()->Lock())
	{
		mBounds = Bounds();
		BView::AttachedToWindow();
		SetViewColor(0,0,0);
		Window()->Unlock();
	}
}


//***************************************************************************
void CViewEcran::FrameResized(float new_width, float new_height)
//***************************************************************************
{
	mBounds = Bounds();
	BView::FrameResized(new_width, new_height);
}


//***************************************************************************
void CViewEcran::Draw(BRect updateRect)
//***************************************************************************
{
	//BStopWatch toto("  CViewEcran::Draw");
	if (Window()->Lock())
	{
		DrawBitmap(mEcran, updateRect, updateRect);
/*
		if (mMain)
		{
			// print scroll range
			BRect rect;
			rect.Set(mScrollX,mScrollY,
								mScrollX+mEcranBounds.Width()*0.05,		// 1.0/20.0 = 0.05
								mScrollY+mEcranBounds.Height()*0.05);
			if (updateRect.Intersects(rect))
			{
				Sync();
				SetHighColor(240,240,240);
				StrokeRect(rect);
	
				rect.Set(	mScrollX*1.05,
									mScrollY*1.05,
									mScrollX*1.05+mBounds.Width()*0.05,
									mScrollX*1.05+mBounds.Height()*0.05);
				SetHighColor(240,20,20);
				StrokeRect(rect);
			}
		}
*/
		Window()->Unlock();
	}
} // end of Draw for CViewEcran


//---------------------------------------------------------------------------


//***************************************************************************
void CViewEcran::MouseDown(BPoint where)
//***************************************************************************
{
	MakeFocus(true);
	if (mMain)
		gMoteur->mouseDown(where.x, where.y);
	else
	{
		// control pannel : simulate key '1' -> '8'
		long x,y;
		x = (long)where.x;
		y = (long)where.y;
		if (x < 64*4)
		{
			long touche = ((long)(x/64))+4*(y>=64);
			if (touche >= 0 && touche <= 7) gMoteur->keyDown('1'+touche);
		}
	}
} // end of MouseDown for CViewEcran


//***************************************************************************
void CViewEcran::KeyDown(const char *bytes, int32 numBytes)
//***************************************************************************
{
	//printf("CViewEcran::KeyDown -- code %d\n", aKey);
	if (numBytes < 1 || !bytes) return;
	gMoteur->keyDown(bytes[0]);
} // end of KeyDown for CViewEcran


//***************************************************************************
void CViewEcran::MouseMoved(BPoint where, uint32 code, const BMessage * /*a_message*/)
//***************************************************************************
{
	if (code == B_ENTERED_VIEW) MakeFocus(true);
	if (mMain)
		gMoteur->mouseMoved(where.x, where.y, code);
} // end of MouseMoved for CViewEcran

//---------------------------------------------------------------------------


//***************************************************************************
BOOL CViewEcran::getVideoBase(UBYTE * &address, ULONG &length, ULONG &brp)
//***************************************************************************
{
	if (!mEcran) return FALSE;
	address = (UBYTE *)mEcran->Bits();
	length = mEcran->BitsLength();
	brp = mEcran->BytesPerRow();
	return (address && length && brp);
} // end of getVideoBase for CViewEcran



//---------------------------------------------------------------------------

#ifdef _GIRNGJFNBIJFDB_
//***************************************************************************
void CViewEcran::blitSpriteNoMask(ULONG x, ULONG y, SbSprite *sp)
//***************************************************************************
{
BBitmap *bitmap = mEcran;
UBYTE *dest = (UBYTE *)bitmap->Bits();
ULONG bpr = bitmap->BytesPerRow();
UBYTE *data;
long sx;
long sy;

	if (!sp) return;
	if (Window() && Window()->Lock())
	{
		dest += x+bpr*y;
	
		data = sp->data;
		sx = sp->sx;
		sy = sp->sy;
	
		// copie rapide sans masque
		for(; sy>0; sy--, dest+=bpr, data+=sx)
			memcpy(dest, data, sx);

		//BRect updt(x,y,x+sx,y+sy);
		//Draw(updt);
		Draw(mBounds);
		Window()->Unlock();
	}

} // end of blitSpriteNoMask for CViewEcran


//***************************************************************************
void CViewEcran::blitSpriteMask(ULONG x, ULONG y, SbSprite *sp)
//***************************************************************************
{
BBitmap *bitmap = mEcran;
UBYTE *dest = (UBYTE *)bitmap->Bits();
ULONG bpr = bitmap->BytesPerRow();
UBYTE *data;
//UBYTE *mask;
long sx;
long sy;

	if (!sp) return;
	if (mEcran->Lock())
	{
		dest += x+bpr*y;

		data = sp->data;
		sx = sp->sx;
		sy = sp->sy;

		// copie rapide sans masque
		for(; sy>0; sy--, dest+=bpr, data+=sx)
			memcpy(dest, data, sx);

		//BRect updt(x,y,x+sx,y+sy);
		//Draw(updt);
		Draw(mBounds);
		mEcran->Unlock();
	}

} // end of blitSpriteMask for CViewEcran
#endif // of #ifdef _GIRNGJFNBIJFDB_


//---------------------------------------------------------------------------


//***************************************************************************
void CViewEcran::setScroll(ULONG x, ULONG y)
//***************************************************************************
{
	mScrollX = x;
	mScrollY = y;
} // end of setScroll for CViewEcran




//---------------------------------------------------------------------------


// eoc
