// CMAMEWindow.h

#pragma once

#include "CMAMEDisplay.h"

class CIOThread;
class CMAMEView;

class CMAMEWindow : public BWindow, public CMAMEDisplay {
public:
						CMAMEWindow(
							const char	*inName,
							BRect		inRect);
						~CMAMEWindow();
	virtual void			Quit();
	virtual void			WindowActivated(
							bool 		inState);
	virtual void			FrameMoved(
							BPoint		new_position);
	virtual void			Show();						
	virtual void			MessageReceived(
							BMessage		*inMessage);
	virtual void			Init();
	virtual void			Exit();
	virtual void			InitPalette();
	virtual void			SetPen(
							int16		inPen,
							uchar		inRed,
							uchar		inGreen,
							uchar		inBlue);
	virtual void			GetPen(
							int16		inPen,
							uchar		*outRed,
							uchar		*outGreen,
							uchar		*outBlue);
	virtual void			Resize(
							int16		inWidth,
							int16		inHeight);
	virtual void			CopyBits(
							void			*inSrc,
							int16		inHeight,
							int16		inWidth);
	virtual void			PollMouse();
	virtual void			ReadMouse(
							int16		*outX,
							int16		*outY);
		
private:
	void					SetupMenus(
							BRect		inFrame);
	void					SetupViews(
							BRect		inFrame);
		
	CMAMEView		*mView;
	CIOThread		*mIO;
	BPoint		mCurPt;
	BPoint		mLastPt;
	rgb_color		mPalette[256];
	uchar		mPenIndex[256];
};

class CMAMEView : public BView {
public:
					CMAMEView(
						BRect		inRect);
					~CMAMEView();
	void				Resize(
						float		inWidth,
						float		inHeight);
	virtual void		Draw(
						BRect		inRect);
	virtual void		MessageReceived(
						BMessage		 *inMessage);
	void				FixFrame();
	inline BBitmap	*Bitmap()		{ return mBitmap;}
	
private:
	BBitmap		*mBitmap;
};