// CMAMEDisplay.cpp
// A mix in that creates either a full screen or windowed display.
// Casey Fleser
// Nevember 1, 1997

#include <BeHeaders>

#include "CMAMEDisplay.h"
#include "CMAMEScreen.h"
#include "CMAMEWindow.h"

status_t		CMAMEDisplay::sWinErr;

struct { char *desc; int32	space; } screenRes[] = {
	{ "-640x480",		B_8_BIT_640x480 },
	{ "-640",			B_8_BIT_640x480 },
	{ "-800x600",		B_8_BIT_800x600 },
	{ "-800",			B_8_BIT_800x600 },
	{ "-1024x768",	B_8_BIT_1024x768 },
	{ "-1024",		B_8_BIT_1024x768 },
	{ "-1280x1024",	B_8_BIT_1280x1024 },
	{ "-1280"	,		B_8_BIT_1280x1024 },
	{ "-1600x1200",	B_8_BIT_1600x1200 },
	{ "-1600"	,		B_8_BIT_1600x1200 },
	{ NULL,			0}
};

CMAMEDisplay *
CMAMEDisplay::CreateMAMEDisplay(
	int			argc,
	char 		**argv)
{
	CMAMEDisplay		*newDisplay;
	int32			space = B_8_BIT_640x480;
	bool				full = false;
	
	for (int32 i=1; i<argc; i++) {
		if (!strcasecmp(argv[i], "-full"))
			full = true;
			
		for (int32 j=0; screenRes[j].desc != NULL; j++) {
			if (!strcasecmp(argv[i], screenRes[j].desc)) {
				space = screenRes[j].space;
				break;
			}
		}
	}

	if (full) {
		newDisplay = new CMAMEScreen(space, "MAME", &sWinErr);
		if ((sWinErr == B_NO_ERROR)/* && (gWindow->CanControlFrameBuffer())*/) {
			newDisplay->Init();
		}
		else {
			delete newDisplay;
			newDisplay = NULL;
			printf("BSorry, no advanced GameKit support\n");
		}
	}
	else {
		newDisplay = new CMAMEWindow("MAME", BRect(80,80,400,400));
		newDisplay->Init();
	}
	
	return newDisplay;
}

CMAMEDisplay::CMAMEDisplay()
{
}

CMAMEDisplay::~CMAMEDisplay()
{
}
