// CIOThread.h

class CMAMEDisplay;

class CIOThread {
public:
					CIOThread(
						CMAMEDisplay	*inDisplay);
					~CIOThread();
	
	int32			Go();
	static void		ClearKeys();
	static uchar		GetKey();

	void				ReadKeys();
	void				Activate(
						bool			inState);
private:
	static int32		Entry(
						void			*arg);
	int32			MainLoop();
	void				Snooze();
	void				SetNextTime();
	
	/* vars */
	static key_info		sTheKeys[2];
	static int32			sCurIndex;
	
	thread_id			mID;
	bigtime_t			mNextTime;
	bool				mQuitting;
	bool				mActive;
	CMAMEDisplay		*mDisplay;
};
