// CAudio.h

class Benaphore;

#define BUF_LEN	32*1024

typedef struct SVoiceRec {
	uint32	length;
	char		*sample;
	char		*cur;
	double	byteCount;
	int32	freq;
	int16	volume;
	bool		loop;
	bool		active;
	char		streamBuf[BUF_LEN];
} SVoiceRec, *SVoicePtr;

class CAudio {
public:	
					CAudio(
						int32		inVoices);
					~CAudio();
	void				SetMasterVolume(
						int16		inNewVolume);
	void				PlaySample(
						int32		inVoice,
						void			*inData,
						int32		inLen,
						int32		inFreq,
						int32		inVolume,
						int32		inLoop);
	void				PlayStreamedSample(
						int32		inVoice,
						void			*inData,
						int32		inLen,
						int32		inFreq,
						int32		inVolume);
	void				AdjustSample(
						int32		inVoice,
						int32		inFreq,
						int32		inVolume);
	void				StopSample(
						int32		inVoice);
	void				RestartSample(
						int32		inVoice);
	static int32		Entry(
						void			*arg);
	int32			MainLoop();
	static bool		FillBuffer(
						void 		*arg,
						char 		*inBuf,
						size_t		inCount,
						void 		*inHeader);
	bool				FillBuf(				
						char 		*inBuf,
						size_t		inCount);
	void				MakeVolumeTable();
	
private:
	thread_id			mID;
	BSubscriber		*mSubscriber;
	BDACStream		*mDACStream;
	float			mSampleRate;
	SVoiceRec			*mVoices;
	int32			mNumVoices;
	int16			*mVolLookup;
	float			mMasterVol;
};