Scanner Eradication Program  9/16/92
------------------------------------

At the present time there are nine scanner/vampire/slavers on the hill.  I
believe this is due to two factors:  first, the success of Flash Paper is
making it a target, and the easiest way to beat FP is through scanning.
Regardless, FP continues to dominate the top of the heap.  Second, there
is a notable lack of bombers out there.  Bombers generally beat scanners
something like 80% of the time.  Where are all the bomber developers?

In an attempt to promote some renewed work in bombers I am posting this
article discussing some of my own innovations.  I think you'll see there
is plenty of room for ingenuity in old Stone.

Here is an old-fashioned stone-type bomber:

	;name Twill
	;author Andy Pierce
	offset	dat #-5138,#5138
	start	spl 0,0
		add offset,1
		mov <0,0
		jmp -2,0
		end start

Now, just because it's old-fashioned, doesn't mean it's not effective.  Twill
seems to hang around the top of the hill most of the time, because it beats
up on all the scanners out there.  

The two important considerations for bombers are pattern and throw-weight.
Twill has a excellent pattern, checkering core rapidly then filling in 
most of the blanks.  Twill also has fair throw-weight, bombing one location
and decrementing one every three instructions, or 66% of c.

Now consider this fighter:

	;redcode
	;name Emerald
	;author P.Kline
	inc      dat #-2045,#2045
	emerald  spl 0,100
	stone    mov <cnt+102-300,<cnt+100
	         add inc,stone
	cnt      djn stone,<-3799
	         end emerald

Emerald exhibits two improvements that give it greater throw-weight, 
bombing one location and decrementing three every three instructions.
First, on the 'cnt' line, note the use of djn.  Every time 'cnt' executes,
it decrements a new location, working backword from -3799.  Charon v 7.0
and Flash Paper do the same thing.

Second, note the b-operand on the 'stone' line.  It is predecremented
just like the a-operand.  This gives the effect of decrementing a location,
then bombing wherever it then points.  Line 'stone' decrements two locations
and bombs a third.

Emerald is the same size as Twill, but trashes core at twice the rate.  
Now the pattern becomes a problem.  I haven't discovered a pattern that is
as efficient as Twill's that doesn't also trash Emerald.  Currently Emerald 
haunts the lower half of the hill, awaiting a better pattern to push it 
up on top.

Emerald trashes core at 133% of c, previously thought to be impossible.
But 133% is not the limit.  If we expand Emerald like this:

	;redcode
	;name Emerald
	;author P.Kline
	inc      dat #-2045,#2045
	emerald  spl 0,100
	stone1   mov <a,<c
	         add inc,stone1
	stone2   mov <c,<d
	         add inc,stone2
	cnt      djn stone1,<-3799
                 end emerald

we now have two mov instructions, each trashing three locations every time
through the loop - seven locations trashed with five instructions - for
a rate of 140% of c.  In fact if we had an endless stream of mov/add 
lines, the rate would be 150%, which is the limit using this technique.
Of course as Emerald gets larger it becomes much harder to protect it
from itself, and also makes it a bigger target for scanners.

Now consider another fighter:

	;redcode
	;name ExtraExtra
	;author P.Kline
 inc      dat #0-4023,#4023
 stone    mov <1,<1+24
          spl -1,<cnt-796
 next     add inc,stone
 cnt      djn stone,<-797
          dat #100
          dat #100
          dat #100

ExtraExtra decrements both the a- and b-operands, and uses the djn instruction
just like Emerald, yet is different.  The spl 0 instruction has been moved
below 'stone' and is changed to a spl -1.  You have to observe this to see
the effect in action.  There are growing bursts of mov/add instructions
alternating with bursts of spl/djn instructions.  The result is longer and
longer bursts of mov/add instructions, trashing core at 150% of c.  Eventually
the bursts become long enough that the entire core is checkered at 150% of c.
I also modified the spl to predecrement the same location as the djn, so
that it trashes every other location.

ExtraExtra is the only bomber I have seen that goes head-to-head with 
Note Paper (a very successful replicator) for most of the battle.  Midway
through the fight, there are no Note Paper colonies, only a few individuals,
and ExtraExtra seems to be catching them when - it self-destructs.

Self-destruction on the part of bombers is a serious problem.  Ideally
they would use a pattern that would knock out every location in core,
except the ones they are occupying, then switch to serial core-clearing to
mop up any cripples.  

Another enhancement would be to begin by throwing a small number of 
spl/jmp 'stunners' out in the hopes of stalling any colony-replicators,
ie, Paper products, before beginning the bombing runs.  Note Paper and
Flash Paper are both about 100 instructions long and should be easy to catch.

For all you determined Flash Paper haters, consider this.  FP
beats scanners (at least mine) about 20-30% of the time, getting a lot
of easy points.  If we reduce the number of scanners by putting more bombers
on the hill, then more replicators can survive there too, and FP
can't beat replicators, only tie them.  In fact, when my replicator Eloquent
was on the hill, FP was out of the top ten for a while.  Then
along came some more scanners - Eloquent was booted off, and FP floated to
the top again.

If you need more encouragement, remember that Smooth Noodle Map is mostly
a bomber - only switching to replicator after a long bombing session.
SNM is also a successful player on the hill.

Until we restore some balance among Stone/Scissors/Paper on the hill, we
won't see much progress into the next generation of fighters.  I consider
Flash Paper and Smooth Noodle Map to be next-generation, because they
are combinations of Stone and Paper, not relying solely on either technique.
Well where are the Scissors/Paper and Stone/Scissors combos?

Paul Kline
pdk@admin.drake.edu
