#import "View.h"

@implementation View

- (void)setHorizontal:(BOOL)value {
	horizontal = value;
}

- (void)setIndicators:(NSArray*)value {
	indicators = value;
}

- (void)cleanup {
	CGLayerRelease(scurve);
	CGLayerRelease(frontline);
	CGLayerRelease(indicator);
}

- (BOOL)wantsDefaultClipping {
	return NO;
}

CGImageRef imageNamed(const char *filename) {
	// Get the URL to the bundle resource
	CFBundleRef mainBundle = CFBundleGetMainBundle();
	CFStringRef name = CFStringCreateWithCString(NULL, filename, 
												 kCFStringEncodingUTF8);
	CFURLRef url = CFBundleCopyResourceURL(mainBundle, name, CFSTR("png"), 
										   NULL);
	CFRelease(name);
	
	// Create the data provider object
	CGDataProviderRef provider = CGDataProviderCreateWithURL(url);
	CFRelease(url);
	
	// Create the image object from that provider
	CGImageRef image = CGImageCreateWithPNGDataProvider(provider, NULL, true, 
														kCGRenderingIntentDefault);
	CGDataProviderRelease(provider);
	
	return image;
}

CGLayerRef layerFromImage(CGImageRef cgi) {
	CGContextRef	cContext;
	CGContextRef	lContext;
	CGColorSpaceRef	cspace;
	CGLayerRef		tLayer;
	CGBitmapInfo	bmInfo;
	
	int				imgw;
	int				imgh;
	
	imgw	= CGImageGetWidth(cgi);
	imgh	= CGImageGetHeight(cgi);
	cspace	= CGImageGetColorSpace(cgi);
	bmInfo	= CGImageGetBitmapInfo(cgi);				//kCGBitmapByteOrder32Host | kCGImageAlphaPremultipliedFirst
	
	const int	bytesPerPixel	= 4;
	const int	rowBytes		= imgw * bytesPerPixel;
	void*		imageData		= malloc( (rowBytes * imgh) );
	
	cContext	= CGBitmapContextCreate(	imageData,
											imgw,
											imgh,
											8,			// bits per component
											rowBytes,
											cspace,
											bmInfo		);
	
	tLayer		= CGLayerCreateWithContext(cContext,CGSizeMake(imgw,imgh),NULL);
	lContext	= CGLayerGetContext(tLayer);
	
	CGContextDrawImage(lContext,CGRectMake(0,0,imgw,imgh),cgi);
	
	CGContextRelease(cContext);
	CGColorSpaceRelease(cspace);
	free(imageData);
	
	return tLayer;
}

- (id)initWithFrame:(NSRect)frame {
	CGImageRef image = nil;
	
	self = [super initWithFrame:frame];
	if (self) {
		image = imageNamed("scurve");
		scurve = layerFromImage(image);
		CGImageRelease(image);
		image = imageNamed("frontline");
		frontline = layerFromImage(image);
		CGImageRelease(image);
		image = imageNamed("indicator");
		indicator = layerFromImage(image);
		CGImageRelease(image);
	}
	
	return self;
}

CGImageRef getDesktop(CGRect rect, BOOL horizontal) {
	CGImageRef result = nil;
	
	// update rect to reflection area
//	if (horizontal)	// bottom
//		rect.origin.y += rect.size.height;
//	else if (rect.origin.x <= 0)	// left
//		rect.origin.x += rect.size.width;
//	else	// right
//		rect.origin.x -= rect.size.width;
	
	// TODO: get screenshot 
	
	// TODO: flip image
	//	if (horizontal) {
	//		vertically
	//	} else {
	//		horizontally
	//	}
	
	return result;
}

CGImageRef getIcons(CGRect rect, BOOL horizontal) {
	CGImageRef result = nil;
	
	// no ideas yet :(
	// get image of a layer (the icon layer of dock 21 i think)
	// flip vertically
	
	return result;
}

- (void)drawRect:(NSRect)rect {
	float takeIn = rect.size.height * 3/4;	// amount to go in at edges
	CGContextRef myContext = [[NSGraphicsContext currentContext] graphicsPort];	// obtain graphics context for this view
	
	CGContextClearRect(myContext, *(CGRect*)&rect);	// clear
	
	// create clipping path
	CGContextBeginPath(myContext);	// begin path
	CGContextMoveToPoint(myContext, 0, 0);	// move to start
	CGContextAddLineToPoint(myContext, takeIn, rect.size.height);	// left edge
	CGContextAddLineToPoint(myContext, rect.size.width - takeIn, 
							rect.size.height);	// right edge
	CGContextAddLineToPoint(myContext, rect.size.width, 0);	// bottom right corner
	CGContextClosePath(myContext);	// close shape
	CGContextClip(myContext);	// clip to path
	
	// desktop reflection
	CGImageRef desktop = getDesktop(*(CGRect*)&rect, horizontal);
	CGContextDrawImage(myContext, *(CGRect*)&rect, desktop);
	CGImageRelease(desktop);
	
	// icons reflection
	CGImageRef icons = getIcons(*(CGRect*)&rect, horizontal);
	CGContextDrawImage(myContext, *(CGRect*)&rect, icons);
	CGImageRelease(icons);
	
	CGContextDrawLayerInRect(myContext, *(CGRect*)&rect, scurve);
	
	NSRect frontlineRect;	// right now only horizontal
	frontlineRect = NSMakeRect(0, 0, rect.size.width, 2);	// we know the height is 2
	CGContextDrawLayerInRect(myContext, *(CGRect*)&frontlineRect, frontline);	// frontline
	
	// app indicators
	if (indicators) {
		// TODO
	}	
}

@end
