#import "Controller.h"

@implementation Controller

pid_t getDockPID() {
	ProcessSerialNumber psn;
	CFDictionaryRef dict;
	CFStringRef string;
	pid_t result;
	
	psn.highLongOfPSN = kNoProcess;
	psn.lowLongOfPSN = kNoProcess;
	
	while (GetNextProcess(&psn) == noErr)  {
		dict = ProcessInformationCopyDictionary(&psn, kProcessDictionaryIncludeAllInformationMask);
		string = CFDictionaryGetValue(dict, kCFBundleIdentifierKey);
		if (string && CFStringCompare((CFStringRef)@"com.apple.dock", string, 
									  0) == kCFCompareEqualTo) {
			GetProcessPID(&psn, &result);
			CFRelease(dict);
			break;
		}
		CFRelease(dict);
	}
	
	return result;
}

AXUIElementRef connectToDock() {
	AXUIElementRef result;
	OSStatus status = !kAXErrorSuccess;
	NSArray *array;
	
	while (status != kAXErrorSuccess) {
		result = AXUIElementCreateApplication(getDockPID());
		status = AXUIElementCopyAttributeValue(result, kAXChildrenAttribute, 
											   (CFTypeRef*)&array);
	}
	result = (AXUIElementRef)[array objectAtIndex:0];	// set dock container
	
	return result;
}

- (NSRect)getDockRect {
	NSRect result;
	AXValueRef value;
	OSStatus status;
	
	// size
	status = AXUIElementCopyAttributeValue(dock, kAXSizeAttribute, 
										   (CFTypeRef*)&value);
	if (status != kAXErrorSuccess)
		return NSZeroRect;
	AXValueGetValue(value, kAXValueCGSizeType, (void*)&result.size);
	
	// origin
	status = AXUIElementCopyAttributeValue(dock, kAXPositionAttribute, 
										   (CFTypeRef*)&value);
	if (status != kAXErrorSuccess)
		return NSZeroRect;
	AXValueGetValue(value, kAXValueCGPointType, (void*)&result.origin);
	
	// orientation
	NSString *orientation;
	AXUIElementCopyAttributeValue(dock, kAXOrientationAttribute, 
								  (CFTypeRef*)&orientation);
	if (status != kAXErrorSuccess)
		return NSZeroRect;
	horizontal = CFEqual(orientation, kAXHorizontalOrientationValue);
	[view setHorizontal:horizontal];
	
	// flip y (origin: accessability (top-left) cocoa (bottom-left)
	result.origin.y = screen.height - result.origin.y - result.size.height;
	
	float increase;	// to allow for edges
	if (horizontal) {
		result.size.height /= 2;
		increase = result.size.height * 3/4;
		result.origin.x -= increase;
		result.size.width += increase * 2;
	} else {
		result.size.width /= 2;
		increase = result.size.width * 3/4;
		result.origin.y -= increase;
		result.size.height += increase * 2;
		if (result.origin.x > screen.width)
			result.origin.x += result.size.width;
	}
	
	// TODO: get icons and set up list of indicators
	[view setIndicators:nil];
	
	return result;
}

- (void)resize {
	static NSRect rect;
	rect = [self getDockRect];
	[window setFrame:rect
			 display:YES
			 animate:NO];
	if (NSEqualRects(rect, NSZeroRect))
		dock = connectToDock();
}

- (void)applicationDidFinishLaunching:(NSNotification*)theNotification {
	// check if assistive api is enabled
	if (!AXAPIEnabled()) {
		int ret = NSRunAlertPanel(@"LigerDock requires that the Accessibility API be enabled.", 
								  @"Would you like me to launch System Preferences so that you can turn on \"Enable access for assistive devices\"?\n\nYou will need to relaunch LigerDock once the Accessibility API is enabled.", 
								  @"Launch System Preferences", 
								  @"Quit",
								  nil);
		switch (ret) {
			case NSAlertDefaultReturn:
				[[NSWorkspace sharedWorkspace] openFile:@"/System/Library/PreferencePanes/UniversalAccessPref.prefPane"];
			case NSAlertAlternateReturn:
				[NSApp terminate:self];
			default:
				break;
		}
	}
	
	dock = connectToDock();
	screen = [[[NSScreen screens] objectAtIndex: 0] frame].size;
	
	// initial animation
	NSRect rect = [self getDockRect];
	rect.size.width = rect.size.height = 1;
	if (horizontal) {
		rect.origin.x = screen.width / 2;
		rect.origin.y = -1;
	} else {
		if (rect.origin.x < screen.width / 2)
			rect.origin.x = -1;
		else
			rect.origin.x = screen.width;
		rect.origin.y = screen.height / 2;
	}
	[window setFrame:rect
			 display:NO
			 animate:NO];
	[window setFrame:[self getDockRect]
			 display:YES
			 animate:YES];
	
	// TODO: join in run queue (THIS WAY IS REALLY SHIT AND LAGGY)
	[NSTimer scheduledTimerWithTimeInterval:0.1
									 target:self 
								   selector:@selector(resize) 
								   userInfo:nil 
									repeats:YES];
}

- (BOOL)applicationShouldHandleReopen:(NSApplication*)theApplication 
					hasVisibleWindows:(BOOL)flag {
	return NO;
}

- (void)applicationDidChangeScreenParameters:(NSNotification*)theNotification {
	screen = [[[NSScreen screens] objectAtIndex: 0] frame].size;
}

- (void)applicationWillTerminate:(NSNotification*)theNotification {
	[view cleanup];
}

@end
