/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.local;

import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.EventLoop;
import io.netty.channel.SingleThreadEventLoop;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannelRegistry;
import io.netty.channel.local.LocalServerChannel;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.SingleThreadEventExecutor;
import io.netty.util.internal.PlatformDependent;
import java.net.SocketAddress;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.NotYetConnectedException;
import java.util.Queue;

public class LocalChannel
extends AbstractChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(false);
    private static final int MAX_READER_STACK_DEPTH = 8;
    private static final ThreadLocal<Integer> READER_STACK_DEPTH = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };
    private final ChannelConfig config = new DefaultChannelConfig(this);
    private final Queue<Object> inboundBuffer = PlatformDependent.newArrayDeque();
    private final Runnable readTask = new Runnable(){

        public void run() {
            Object m;
            ChannelPipeline pipeline = LocalChannel.this.pipeline();
            while ((m = LocalChannel.this.inboundBuffer.poll()) != null) {
                pipeline.fireChannelRead(m);
            }
            pipeline.fireChannelReadComplete();
        }
    };
    private final Runnable shutdownHook = new Runnable(){

        public void run() {
            LocalChannel.this.unsafe().close(LocalChannel.this.unsafe().voidPromise());
        }
    };
    private volatile int state;
    private volatile LocalChannel peer;
    private volatile LocalAddress localAddress;
    private volatile LocalAddress remoteAddress;
    private volatile ChannelPromise connectPromise;
    private volatile boolean readInProgress;

    public LocalChannel() {
        super(null);
    }

    LocalChannel(LocalServerChannel parent, LocalChannel peer) {
        super(parent);
        this.peer = peer;
        this.localAddress = parent.localAddress();
        this.remoteAddress = peer.localAddress();
    }

    public ChannelMetadata metadata() {
        return METADATA;
    }

    public ChannelConfig config() {
        return this.config;
    }

    public LocalServerChannel parent() {
        return (LocalServerChannel)super.parent();
    }

    public LocalAddress localAddress() {
        return (LocalAddress)super.localAddress();
    }

    public LocalAddress remoteAddress() {
        return (LocalAddress)super.remoteAddress();
    }

    public boolean isOpen() {
        return this.state < 3;
    }

    public boolean isActive() {
        return this.state == 2;
    }

    protected AbstractChannel.AbstractUnsafe newUnsafe() {
        return new LocalUnsafe();
    }

    protected boolean isCompatible(EventLoop loop) {
        return loop instanceof SingleThreadEventLoop;
    }

    protected SocketAddress localAddress0() {
        return this.localAddress;
    }

    protected SocketAddress remoteAddress0() {
        return this.remoteAddress;
    }

    protected void doRegister() throws Exception {
        if (this.peer != null) {
            this.state = 2;
            this.peer.remoteAddress = this.parent().localAddress();
            this.peer.state = 2;
            this.peer.eventLoop().execute(new Runnable(){

                public void run() {
                    LocalChannel.this.peer.pipeline().fireChannelActive();
                    LocalChannel.this.peer.connectPromise.setSuccess();
                }
            });
        }
        ((SingleThreadEventExecutor)this.eventLoop()).addShutdownHook(this.shutdownHook);
    }

    protected void doBind(SocketAddress localAddress) throws Exception {
        this.localAddress = LocalChannelRegistry.register(this, this.localAddress, localAddress);
        this.state = 1;
    }

    protected void doDisconnect() throws Exception {
        this.doClose();
    }

    protected void doClose() throws Exception {
        LocalChannel peer;
        if (this.state <= 2) {
            if (this.localAddress != null) {
                if (this.parent() == null) {
                    LocalChannelRegistry.unregister(this.localAddress);
                }
                this.localAddress = null;
            }
            this.state = 3;
        }
        if ((peer = this.peer) != null && peer.isActive()) {
            EventLoop eventLoop = peer.eventLoop();
            if (eventLoop.inEventLoop()) {
                peer.unsafe().close(this.unsafe().voidPromise());
            } else {
                peer.eventLoop().execute(new Runnable(){

                    public void run() {
                        peer.unsafe().close(LocalChannel.this.unsafe().voidPromise());
                    }
                });
            }
            this.peer = null;
        }
    }

    protected void doDeregister() throws Exception {
        if (this.isOpen()) {
            this.unsafe().close(this.unsafe().voidPromise());
        }
        ((SingleThreadEventExecutor)this.eventLoop()).removeShutdownHook(this.shutdownHook);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doBeginRead() throws Exception {
        if (this.readInProgress) {
            return;
        }
        ChannelPipeline pipeline = this.pipeline();
        Queue<Object> inboundBuffer = this.inboundBuffer;
        if (inboundBuffer.isEmpty()) {
            this.readInProgress = true;
            return;
        }
        Integer stackDepth = READER_STACK_DEPTH.get();
        if (stackDepth < 8) {
            READER_STACK_DEPTH.set(stackDepth + 1);
            try {
                Object received;
                while ((received = inboundBuffer.poll()) != null) {
                    pipeline.fireChannelRead(received);
                }
                pipeline.fireChannelReadComplete();
                Object var6_5 = null;
                READER_STACK_DEPTH.set(stackDepth);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                READER_STACK_DEPTH.set(stackDepth);
                throw throwable;
            }
        } else {
            this.eventLoop().execute(this.readTask);
        }
    }

    protected void doWrite(ChannelOutboundBuffer in) throws Exception {
        if (this.state < 2) {
            throw new NotYetConnectedException();
        }
        if (this.state > 2) {
            throw new ClosedChannelException();
        }
        final LocalChannel peer = this.peer;
        final ChannelPipeline peerPipeline = peer.pipeline();
        EventLoop peerLoop = peer.eventLoop();
        if (peerLoop == this.eventLoop()) {
            Object msg;
            while ((msg = in.current()) != null) {
                peer.inboundBuffer.add(msg);
                ReferenceCountUtil.retain((Object)msg);
                in.remove();
            }
            LocalChannel.finishPeerRead(peer, peerPipeline);
        } else {
            final Object[] msgsCopy = new Object[in.size()];
            for (int i = 0; i < msgsCopy.length; ++i) {
                msgsCopy[i] = ReferenceCountUtil.retain((Object)in.current());
                in.remove();
            }
            peerLoop.execute(new Runnable(){

                public void run() {
                    for (int i = 0; i < msgsCopy.length; ++i) {
                        peer.inboundBuffer.add(msgsCopy[i]);
                    }
                    LocalChannel.finishPeerRead(peer, peerPipeline);
                }
            });
        }
    }

    private static void finishPeerRead(LocalChannel peer, ChannelPipeline peerPipeline) {
        if (peer.readInProgress) {
            Object received;
            peer.readInProgress = false;
            while ((received = peer.inboundBuffer.poll()) != null) {
                peerPipeline.fireChannelRead(received);
            }
            peerPipeline.fireChannelReadComplete();
        }
    }

    private class LocalUnsafe
    extends AbstractChannel.AbstractUnsafe {
        private LocalUnsafe() {
        }

        public void connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            Channel boundChannel;
            if (!this.ensureOpen(promise)) {
                return;
            }
            if (LocalChannel.this.state == 2) {
                AlreadyConnectedException cause = new AlreadyConnectedException();
                promise.setFailure(cause);
                LocalChannel.this.pipeline().fireExceptionCaught(cause);
                return;
            }
            if (LocalChannel.this.connectPromise != null) {
                throw new ConnectionPendingException();
            }
            LocalChannel.this.connectPromise = promise;
            if (LocalChannel.this.state != 1 && localAddress == null) {
                localAddress = new LocalAddress(LocalChannel.this);
            }
            if (localAddress != null) {
                try {
                    LocalChannel.this.doBind(localAddress);
                }
                catch (Throwable t) {
                    promise.setFailure(t);
                    LocalChannel.this.pipeline().fireExceptionCaught(t);
                    this.close(this.voidPromise());
                    return;
                }
            }
            if (!((boundChannel = LocalChannelRegistry.get(remoteAddress)) instanceof LocalServerChannel)) {
                ChannelException cause = new ChannelException("connection refused");
                promise.setFailure(cause);
                this.close(this.voidPromise());
                return;
            }
            LocalServerChannel serverChannel = (LocalServerChannel)boundChannel;
            LocalChannel.this.peer = serverChannel.serve(LocalChannel.this);
        }
    }
}

