/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.spi;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.spi.MutableThreadContextStack;
import org.apache.logging.log4j.spi.ThreadContextStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultThreadContextStack
implements ThreadContextStack {
    private static final long serialVersionUID = 5050501L;
    private static final ThreadLocal<MutableThreadContextStack> stack = new ThreadLocal();
    private final boolean useStack;

    public DefaultThreadContextStack(boolean useStack) {
        this.useStack = useStack;
    }

    private MutableThreadContextStack getNonNullStackCopy() {
        MutableThreadContextStack values = stack.get();
        return values == null ? new MutableThreadContextStack() : values.copy();
    }

    @Override
    public boolean add(String s) {
        if (!this.useStack) {
            return false;
        }
        MutableThreadContextStack copy = this.getNonNullStackCopy();
        copy.add(s);
        copy.freeze();
        stack.set(copy);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends String> strings) {
        if (!this.useStack || strings.isEmpty()) {
            return false;
        }
        MutableThreadContextStack copy = this.getNonNullStackCopy();
        copy.addAll(strings);
        copy.freeze();
        stack.set(copy);
        return true;
    }

    @Override
    public List<String> asList() {
        MutableThreadContextStack values = stack.get();
        if (values == null) {
            return Collections.emptyList();
        }
        return values.asList();
    }

    @Override
    public void clear() {
        stack.remove();
    }

    @Override
    public boolean contains(Object o) {
        MutableThreadContextStack values = stack.get();
        return values != null && values.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        if (objects.isEmpty()) {
            return true;
        }
        MutableThreadContextStack values = stack.get();
        return values != null && values.containsAll(objects);
    }

    @Override
    public ThreadContextStack copy() {
        MutableThreadContextStack values = null;
        if (!this.useStack || (values = stack.get()) == null) {
            return new MutableThreadContextStack();
        }
        return values.copy();
    }

    @Override
    public boolean equals(Object obj) {
        ThreadContextStack other;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof DefaultThreadContextStack) {
            other = (DefaultThreadContextStack)obj;
            if (this.useStack != other.useStack) {
                return false;
            }
        }
        if (!(obj instanceof ThreadContextStack)) {
            return false;
        }
        other = (ThreadContextStack)obj;
        MutableThreadContextStack values = stack.get();
        if (values == null) {
            return other == null;
        }
        return values.equals(other);
    }

    @Override
    public int getDepth() {
        MutableThreadContextStack values = stack.get();
        return values == null ? 0 : values.getDepth();
    }

    @Override
    public int hashCode() {
        MutableThreadContextStack values = stack.get();
        int prime = 31;
        int result = 1;
        result = 31 * result + (values == null ? 0 : values.hashCode());
        return result;
    }

    @Override
    public boolean isEmpty() {
        MutableThreadContextStack values = stack.get();
        return values == null || values.isEmpty();
    }

    @Override
    public Iterator<String> iterator() {
        MutableThreadContextStack values = stack.get();
        if (values == null) {
            List empty = Collections.emptyList();
            return empty.iterator();
        }
        return values.iterator();
    }

    @Override
    public String peek() {
        MutableThreadContextStack values = stack.get();
        if (values == null || values.size() == 0) {
            return null;
        }
        return values.peek();
    }

    @Override
    public String pop() {
        if (!this.useStack) {
            return "";
        }
        MutableThreadContextStack values = stack.get();
        if (values == null || values.size() == 0) {
            throw new NoSuchElementException("The ThreadContext stack is empty");
        }
        MutableThreadContextStack copy = (MutableThreadContextStack)values.copy();
        String result = copy.pop();
        copy.freeze();
        stack.set(copy);
        return result;
    }

    @Override
    public void push(String message) {
        if (!this.useStack) {
            return;
        }
        this.add(message);
    }

    @Override
    public boolean remove(Object o) {
        if (!this.useStack) {
            return false;
        }
        MutableThreadContextStack values = stack.get();
        if (values == null || values.size() == 0) {
            return false;
        }
        MutableThreadContextStack copy = (MutableThreadContextStack)values.copy();
        boolean result = copy.remove(o);
        copy.freeze();
        stack.set(copy);
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        if (!this.useStack || objects.isEmpty()) {
            return false;
        }
        MutableThreadContextStack values = stack.get();
        if (values == null || values.isEmpty()) {
            return false;
        }
        MutableThreadContextStack copy = (MutableThreadContextStack)values.copy();
        boolean result = copy.removeAll(objects);
        copy.freeze();
        stack.set(copy);
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> objects) {
        if (!this.useStack || objects.isEmpty()) {
            return false;
        }
        MutableThreadContextStack values = stack.get();
        if (values == null || values.isEmpty()) {
            return false;
        }
        MutableThreadContextStack copy = (MutableThreadContextStack)values.copy();
        boolean result = copy.retainAll(objects);
        copy.freeze();
        stack.set(copy);
        return result;
    }

    @Override
    public int size() {
        MutableThreadContextStack values = stack.get();
        return values == null ? 0 : values.size();
    }

    @Override
    public Object[] toArray() {
        MutableThreadContextStack result = stack.get();
        if (result == null) {
            return new String[0];
        }
        return result.toArray(new Object[result.size()]);
    }

    @Override
    public <T> T[] toArray(T[] ts) {
        MutableThreadContextStack result = stack.get();
        if (result == null) {
            if (ts.length > 0) {
                ts[0] = null;
            }
            return ts;
        }
        return result.toArray(ts);
    }

    public String toString() {
        MutableThreadContextStack values = stack.get();
        return values == null ? "[]" : values.toString();
    }

    @Override
    public void trim(int depth) {
        if (depth < 0) {
            throw new IllegalArgumentException("Maximum stack depth cannot be negative");
        }
        MutableThreadContextStack values = stack.get();
        if (values == null) {
            return;
        }
        MutableThreadContextStack copy = (MutableThreadContextStack)values.copy();
        copy.trim(depth);
        copy.freeze();
        stack.set(copy);
    }

    @Override
    public ThreadContext.ContextStack getImmutableStackOrNull() {
        return stack.get();
    }
}

