/*
 * Decompiled with CFR 0.152.
 */
package optifine.xdelta;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import optifine.xdelta.ByteArraySeekableSource;
import optifine.xdelta.PatchException;
import optifine.xdelta.RandomAccessFileSeekableSource;
import optifine.xdelta.SeekableSource;

public class GDiffPatcher {
    public GDiffPatcher(File sourceFile, File patchFile, File outputFile) throws IOException, PatchException {
        RandomAccessFileSeekableSource randomaccessfileseekablesource = new RandomAccessFileSeekableSource(new RandomAccessFile(sourceFile, "r"));
        FileInputStream inputstream = new FileInputStream(patchFile);
        FileOutputStream outputstream = new FileOutputStream(outputFile);
        try {
            GDiffPatcher.runPatch(randomaccessfileseekablesource, inputstream, outputstream);
        }
        catch (IOException ioexception) {
            throw ioexception;
        }
        catch (PatchException patchexception) {
            throw patchexception;
        }
        finally {
            randomaccessfileseekablesource.close();
            ((InputStream)inputstream).close();
            ((OutputStream)outputstream).close();
        }
    }

    public GDiffPatcher(byte[] source, InputStream patch, OutputStream output) throws IOException, PatchException {
        this(new ByteArraySeekableSource(source), patch, output);
    }

    public GDiffPatcher(SeekableSource source, InputStream patch, OutputStream out) throws IOException, PatchException {
        GDiffPatcher.runPatch(source, patch, out);
    }

    private static void runPatch(SeekableSource source, InputStream patch, OutputStream out) throws IOException, PatchException {
        DataOutputStream dataoutputstream = new DataOutputStream(out);
        DataInputStream datainputstream = new DataInputStream(patch);
        try {
            byte[] abyte = new byte[256];
            int i2 = 0;
            if (datainputstream.readUnsignedByte() == 209 && datainputstream.readUnsignedByte() == 255 && datainputstream.readUnsignedByte() == 209 && datainputstream.readUnsignedByte() == 255 && datainputstream.readUnsignedByte() == 4) {
                i2 += 5;
                block21: while (datainputstream.available() > 0) {
                    int j2 = datainputstream.readUnsignedByte();
                    int k2 = 0;
                    int l2 = 0;
                    switch (j2) {
                        case 0: {
                            continue block21;
                        }
                        case 1: {
                            GDiffPatcher.append(1, datainputstream, dataoutputstream);
                            i2 += 2;
                            continue block21;
                        }
                        case 2: {
                            GDiffPatcher.append(2, datainputstream, dataoutputstream);
                            i2 += 3;
                            continue block21;
                        }
                        case 246: {
                            GDiffPatcher.append(246, datainputstream, dataoutputstream);
                            i2 += 247;
                            continue block21;
                        }
                        case 247: {
                            k2 = datainputstream.readUnsignedShort();
                            GDiffPatcher.append(k2, datainputstream, dataoutputstream);
                            i2 += k2 + 3;
                            continue block21;
                        }
                        case 248: {
                            k2 = datainputstream.readInt();
                            GDiffPatcher.append(k2, datainputstream, dataoutputstream);
                            i2 += k2 + 5;
                            continue block21;
                        }
                        case 249: {
                            l2 = datainputstream.readUnsignedShort();
                            k2 = datainputstream.readUnsignedByte();
                            GDiffPatcher.copy(l2, k2, source, dataoutputstream);
                            i2 += 4;
                            continue block21;
                        }
                        case 250: {
                            l2 = datainputstream.readUnsignedShort();
                            k2 = datainputstream.readUnsignedShort();
                            GDiffPatcher.copy(l2, k2, source, dataoutputstream);
                            i2 += 5;
                            continue block21;
                        }
                        case 251: {
                            l2 = datainputstream.readUnsignedShort();
                            k2 = datainputstream.readInt();
                            GDiffPatcher.copy(l2, k2, source, dataoutputstream);
                            i2 += 7;
                            continue block21;
                        }
                        case 252: {
                            l2 = datainputstream.readInt();
                            k2 = datainputstream.readUnsignedByte();
                            GDiffPatcher.copy(l2, k2, source, dataoutputstream);
                            i2 += 8;
                            continue block21;
                        }
                        case 253: {
                            l2 = datainputstream.readInt();
                            k2 = datainputstream.readUnsignedShort();
                            GDiffPatcher.copy(l2, k2, source, dataoutputstream);
                            i2 += 7;
                            continue block21;
                        }
                        case 254: {
                            l2 = datainputstream.readInt();
                            k2 = datainputstream.readInt();
                            GDiffPatcher.copy(l2, k2, source, dataoutputstream);
                            i2 += 9;
                            continue block21;
                        }
                        case 255: {
                            long i1 = datainputstream.readLong();
                            k2 = datainputstream.readInt();
                            GDiffPatcher.copy(i1, k2, source, dataoutputstream);
                            i2 += 13;
                            continue block21;
                        }
                    }
                    GDiffPatcher.append(j2, datainputstream, dataoutputstream);
                    i2 += j2 + 1;
                }
                return;
            }
            System.err.println("magic string not found, aborting!");
        }
        catch (PatchException patchexception) {
            throw patchexception;
        }
        finally {
            dataoutputstream.flush();
        }
    }

    protected static void copy(long offset, int length, SeekableSource source, OutputStream output) throws IOException, PatchException {
        if (offset + (long)length > source.length()) {
            throw new PatchException("truncated source file, aborting");
        }
        byte[] abyte = new byte[256];
        source.seek(offset);
        while (length > 0) {
            int i2 = length > 256 ? 256 : length;
            int j2 = source.read(abyte, 0, i2);
            output.write(abyte, 0, j2);
            length -= j2;
        }
    }

    protected static void append(int length, InputStream patch, OutputStream output) throws IOException {
        byte[] abyte = new byte[256];
        while (length > 0) {
            int i2 = length > 256 ? 256 : length;
            int j2 = patch.read(abyte, 0, i2);
            output.write(abyte, 0, j2);
            length -= j2;
        }
    }

    public static void main(String[] argv) {
        if (argv.length != 3) {
            System.err.println("usage GDiffPatch source patch output");
            System.err.println("aborting..");
        } else {
            try {
                File file1 = new File(argv[0]);
                File file2 = new File(argv[1]);
                File file3 = new File(argv[2]);
                if (file1.length() > Integer.MAX_VALUE || file2.length() > Integer.MAX_VALUE) {
                    System.err.println("source or patch is too large, max length is 2147483647");
                    System.err.println("aborting..");
                    return;
                }
                new GDiffPatcher(file1, file2, file3);
                System.out.println("finished patching file");
            }
            catch (Exception exception) {
                System.err.println("error while patching: " + exception);
            }
        }
    }
}

